/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.service.prov.api.filter;

import com.sap.cloud.sdk.service.prov.api.filter.Expression;
import com.sap.cloud.sdk.service.prov.api.filter.ExpressionAPIUtility;
import com.sap.cloud.sdk.service.prov.api.filter.ExpressionOperatorTypes;
import com.sap.cloud.sdk.service.prov.api.filter.LiteralNode;
import com.sap.cloud.sdk.service.prov.api.filter.PropertyNode;
import java.util.List;

public interface ExpressionNode
extends Expression {
    public boolean isLeafUnit();

    public ExpressionOperatorTypes.NODE_KIND getKind();

    default public boolean isLiteralNode() {
        return this instanceof LiteralNode;
    }

    default public boolean isPropertyNode() {
        return this instanceof PropertyNode;
    }

    default public boolean hasProperty(String propertyName) {
        List<ExpressionNode> children = new ExpressionAPIUtility().getChildren(this);
        if (children == null) {
            return false;
        }
        return children.stream().filter(node -> node.getKind() == ExpressionOperatorTypes.NODE_KIND.PROPERTY).filter(node -> {
            PropertyNode memberNode = (PropertyNode)node;
            return memberNode.getPath().equals(propertyName);
        }).findAny().isPresent();
    }

    default public boolean hasOperator(ExpressionOperatorTypes.OPERATOR operator) {
        return new ExpressionAPIUtility().hasOperator(this, operator);
    }

    default public boolean hasFunction(ExpressionOperatorTypes.FUNCTION function) {
        return new ExpressionAPIUtility().hasFunction(this, function);
    }
}

