/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.service.prov.api.filter.impl;

import com.sap.cloud.sdk.service.prov.api.filter.ExpressionNode;
import com.sap.cloud.sdk.service.prov.api.filter.ExpressionOperatorTypes;
import com.sap.cloud.sdk.service.prov.api.filter.FunctionNode;
import com.sap.cloud.sdk.service.prov.api.filter.impl.FilterNodeInternal;
import com.sap.cloud.sdk.service.prov.api.filter.impl.NodeInfoImpl;
import java.util.List;
import java.util.stream.Collectors;

public class FunctionNodeImpl
implements FunctionNode,
FilterNodeInternal {
    private String functionName;
    private NodeInfoImpl nodeInfo;
    private List<FilterNodeInternal> parameters;
    private boolean leafUnitNode = false;

    public FunctionNodeImpl(String functionName, List<FilterNodeInternal> parameters, NodeInfoImpl nodeInfo) {
        this.functionName = functionName;
        this.parameters = parameters;
        this.nodeInfo = nodeInfo;
        this.leafUnitNode = this.getChildren().stream().filter(node -> node.getKind() == ExpressionOperatorTypes.NODE_KIND.PROPERTY || node.getKind() == ExpressionOperatorTypes.NODE_KIND.LITERAL).findAny().isPresent();
    }

    @Override
    public boolean isLeafUnit() {
        return this.leafUnitNode;
    }

    @Override
    public String getFunctionName() {
        return this.functionName;
    }

    @Override
    public int getParameterCount() {
        return this.parameters.size();
    }

    @Override
    public List<ExpressionNode> getParameters() {
        return this.parameters.stream().map(nodeInternal -> nodeInternal).collect(Collectors.toList());
    }

    @Override
    public ExpressionOperatorTypes.NODE_KIND getKind() {
        return this.nodeInfo.getNodeKind();
    }

    @Override
    public List<FilterNodeInternal> getChildren() {
        return this.parameters;
    }

    @Override
    public boolean isCustomNode() {
        return this.nodeInfo.isCustomNode();
    }

    @Override
    public String getOperator() {
        return this.nodeInfo.getNodeOperator();
    }
}

