/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.service.prov.api.response.impl;

import com.sap.cloud.sdk.service.prov.api.EntityData;
import com.sap.cloud.sdk.service.prov.api.response.CreateResponse;
import com.sap.cloud.sdk.service.prov.api.response.CreateResponseBuilder;
import com.sap.cloud.sdk.service.prov.api.response.impl.CreateResponseImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateResponseBuilderImpl
implements CreateResponseBuilder {
    private static Logger log = LoggerFactory.getLogger(CreateResponseBuilderImpl.class);
    private Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private Object data;
    private boolean enable = false;

    @Override
    public CreateResponseBuilder setData(Map<String, Object> data) {
        this.data = data;
        return this;
    }

    @Override
    public CreateResponseBuilder setData(EntityData entityData) {
        this.data = entityData;
        return this;
    }

    @Override
    public CreateResponseBuilder setData(Object pojoData) {
        this.data = pojoData;
        return this;
    }

    @Override
    public CreateResponseBuilder addHeaders(Map<String, List<String>> headers) {
        if (headers != null && !headers.isEmpty()) {
            if (this.headers.isEmpty()) {
                this.headers.putAll(headers);
            } else {
                for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
                    if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
                    String headerName = this.getHeaderName(entry.getKey());
                    if (this.headers.get(headerName) == null) {
                        this.headers.put(headerName, new ArrayList(entry.getValue()));
                        continue;
                    }
                    this.headers.get(headerName).addAll((Collection<String>)entry.getValue());
                }
            }
        }
        return this;
    }

    @Override
    public CreateResponseBuilder setHeader(String name, String value) {
        String headerName = this.getHeaderName(name);
        ArrayList<String> valueList = new ArrayList<String>();
        valueList.add(value);
        if (log.isDebugEnabled()) {
            log.debug("Set header name " + name + " with value " + value + ".");
        }
        this.headers.put(headerName, valueList);
        return this;
    }

    @Override
    public CreateResponseBuilder addHeader(String name, String value) {
        String headerName = this.getHeaderName(name);
        List<String> valueList = this.headers.get(headerName);
        if (valueList == null) {
            valueList = new ArrayList<String>();
        }
        valueList.add(value);
        if (log.isDebugEnabled()) {
            log.debug("Replace header name " + name + ". Setting name " + headerName + " with value " + value + ".");
        }
        this.headers.put(headerName, valueList);
        return this;
    }

    @Override
    public CreateResponse response() {
        CreateResponseImpl createResponse = new CreateResponseImpl();
        createResponse.setData(this.data);
        createResponse.setHeaders(this.headers);
        createResponse.audit(this.enable);
        return createResponse;
    }

    @Override
    @Deprecated
    public CreateResponseBuilder audit(boolean enable) {
        this.enable = enable;
        return this;
    }

    protected String getHeaderName(String name) {
        if (name == null || "".equals(name.trim()) || this.headers == null) {
            return name;
        }
        for (String headerName : this.headers.keySet()) {
            if (!headerName.equalsIgnoreCase(name)) continue;
            return headerName;
        }
        return name;
    }
}

