/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.service.prov.api.response.impl;

import com.sap.cloud.sdk.service.prov.api.response.ErrorResponse;
import com.sap.cloud.sdk.service.prov.api.response.ReadResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadResponseImpl
extends ReadResponse {
    private static Logger log = LoggerFactory.getLogger(ReadResponseImpl.class);
    private Object data;
    private ErrorResponse errorResponse;
    private boolean enableAuditing = false;

    public ReadResponseImpl() {
    }

    public ReadResponseImpl(ErrorResponse error) {
        this.errorResponse = error;
    }

    public ErrorResponse getErrorResponse() {
        return this.errorResponse;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public Object getData() {
        return this.data;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    @Deprecated
    public void audit(boolean enable) {
        this.enableAuditing = enable;
    }

    @Deprecated
    public boolean isAuditingEnabled() {
        return this.enableAuditing;
    }

    public void setHeaders(Map<String, List<String>> headers) {
        this.headers = headers;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public void setHeader(String name, String value) {
        this.removeHeader(name);
        ArrayList<String> valueList = new ArrayList<String>();
        valueList.add(value);
        if (log.isDebugEnabled()) {
            log.debug("Set header name " + name + " with value " + value + ".");
        }
        this.headers.put(name, valueList);
    }

    public List<String> removeHeader(String name) {
        String headerName = this.getHeaderName(name);
        if (log.isDebugEnabled()) {
            log.debug("Remove header name " + name + ". Removing header name " + headerName + ".");
        }
        return (List)this.headers.remove(headerName);
    }

    public String getHeader(String name) {
        if (name == null || "".equals(name.trim()) || this.headers == null) {
            return null;
        }
        String headerName = this.getHeaderName(name);
        List valueList = (List)this.headers.get(headerName);
        return valueList == null ? null : (valueList.size() > 0 ? (String)valueList.get(0) : null);
    }

    protected String getHeaderName(String name) {
        if (name == null || "".equals(name.trim()) || this.headers == null) {
            return name;
        }
        for (String headerName : this.headers.keySet()) {
            if (!headerName.equalsIgnoreCase(name)) continue;
            return headerName;
        }
        return name;
    }
}

