/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.service.prov.api.statistics;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SAPStatistics {
    public static final String GENERICDATAPROVIDER = "db";
    public static final String EXTENSIONDATAPROVIDER = "ext";
    public static final String SRVIMPLEMENTATION = "impl";
    public static final String FRAMEWORK = "fw";
    public static final String TOTAL = "total";
    public static final String STATISTICSHEADER = "sap-statistics-xsa-java-odatav4";
    public static final String STATISTICSHEADER_CXS = "sap-statistics";
    private HashMap<String, Long> timingsMap = new HashMap();

    public HashMap<String, Long> getTimingsMap() {
        return this.timingsMap;
    }

    public void addTimings(String type, long elapsedTime) {
        Long curVal = this.timingsMap.get(type);
        if (curVal != null) {
            Long val = elapsedTime + curVal;
            this.timingsMap.put(type, val);
        } else {
            this.timingsMap.put(type, elapsedTime);
        }
    }

    public Map<String, Long> getcurrentTimings() {
        Map<String, Long> timings = Collections.unmodifiableMap(this.timingsMap);
        return timings;
    }

    public String getTimings(Long startTime) {
        StringBuilder timingsString = new StringBuilder(70);
        Long componentsTime = new Long(0L);
        for (Map.Entry<String, Long> entry : this.timingsMap.entrySet()) {
            timingsString.append(entry.getKey() + "=" + entry.getValue() + ";");
            componentsTime = componentsTime + entry.getValue();
        }
        Long totalTime = System.currentTimeMillis() - startTime;
        Long fwTime = totalTime - componentsTime;
        timingsString.append("fw=" + fwTime + ";" + TOTAL + "=" + totalTime);
        return timingsString.toString();
    }

    public void clear() {
        this.timingsMap = new HashMap();
    }

    public void addTimings(SAPStatistics statisctics) {
        for (String key : statisctics.getcurrentTimings().keySet()) {
            this.addTimings(key, statisctics.getcurrentTimings().get(key));
        }
    }
}

