/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.service.prov.model.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sap.cloud.sdk.service.prov.model.internal.CSNAnnotationModel;
import com.sap.cloud.sdk.service.prov.model.internal.CSNAssociationModel;
import com.sap.cloud.sdk.service.prov.model.internal.CSNElementModel;
import com.sap.cloud.sdk.service.prov.model.internal.CSNEntityModel;
import com.sap.cloud.sdk.service.prov.model.internal.CSNMetaModel;
import com.sap.cloud.sdk.service.prov.model.internal.CSNOperationModel;
import com.sap.cloud.sdk.service.prov.model.internal.CSNParamModel;
import com.sap.cloud.sdk.service.prov.model.internal.CSNQueryModel;
import com.sap.cloud.sdk.service.prov.model.internal.CSNServiceModel;
import com.sap.cloud.sdk.service.prov.model.internal.CsnParserUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSNParser {
    Map<String, CSNServiceModel> csnServiceMap = new HashMap<String, CSNServiceModel>();
    Map<String, CSNEntityModel> csnIndpendentEntityMap = new HashMap<String, CSNEntityModel>();
    CSNMetaModel csnMetaModel = new CSNMetaModel();
    private static Logger log = LoggerFactory.getLogger(CSNParser.class);
    private InputStream csn = null;
    Map<String, String> svcMap = new HashMap<String, String>();
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public CSNMetaModel readAndParse(InputStream csnInputStream) {
        this.csn = csnInputStream;
        return this.readAndParse();
    }

    public CSNMetaModel readAndParse(byte[] csnByteArray) {
        CsnParserUtil.logDebug(log, "readAndParse started");
        try {
            Map csnMap = new HashMap();
            csnMap = (Map)objectMapper.readValue(csnByteArray, HashMap.class);
            CSNServiceModel serviceModel = null;
            Map definitionMap = (Map)csnMap.get("definitions");
            for (Map.Entry entry : definitionMap.entrySet()) {
                Map entryValue = (Map)entry.getValue();
                String csnObjKind = (String)entryValue.get("kind");
                String entryKey = (String)entry.getKey();
                if (!"service".equals(csnObjKind)) continue;
                serviceModel = new CSNServiceModel();
                serviceModel.setServiceName(entryKey);
                this.svcMap.put(entryKey, entryKey);
                ArrayList<CSNEntityModel> entities = new ArrayList<CSNEntityModel>();
                serviceModel.setEntities(entities);
                if (entryValue.containsKey("actions")) {
                    Map actionsMap = (Map)entryValue.get("actions");
                    this.addOperationsToService(actionsMap, serviceModel);
                }
                this.csnServiceMap.put(entryKey, serviceModel);
            }
            this.addEntitiesToService(definitionMap, this.svcMap);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        CsnParserUtil.logDebug(log, "readAndParse ended");
        this.csnMetaModel.setService(this.csnServiceMap);
        this.csnMetaModel.setEntities(this.csnIndpendentEntityMap);
        return this.csnMetaModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CSNMetaModel readAndParse() {
        CsnParserUtil.logDebug(log, "readAndParse started");
        InputStream csnInputStream = null;
        try {
            csnInputStream = this.csn == null ? CSNParser.class.getClassLoader().getResourceAsStream("edmx/csn.json") : this.csn;
            byte[] mapData = IOUtils.toByteArray((InputStream)csnInputStream);
            CSNMetaModel cSNMetaModel = this.readAndParse(mapData);
            return cSNMetaModel;
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (csnInputStream != null) {
                    csnInputStream.close();
                } else {
                    log.debug("csnInputStream was null");
                }
            }
            catch (IOException e) {
                log.error("Error in closing inputstream for csn parsing", (Throwable)e);
            }
        }
        CsnParserUtil.logDebug(log, "readAndParse ended");
        return this.csnMetaModel;
    }

    private void addOperationsToService(Map<String, Object> actionsMap, CSNServiceModel serviceModel) {
        if (serviceModel == null || actionsMap == null || actionsMap.isEmpty()) {
            return;
        }
        ArrayList<CSNOperationModel> actions = new ArrayList<CSNOperationModel>();
        ArrayList<CSNOperationModel> functions = new ArrayList<CSNOperationModel>();
        for (Map.Entry<String, Object> operation : actionsMap.entrySet()) {
            Map opValue = (Map)operation.getValue();
            String opName = operation.getKey();
            if ("action".equals(opValue.get("kind"))) {
                actions.add(this.constructCsnOperation(serviceModel.getServiceName(), opName, opValue));
                continue;
            }
            if (!"function".equals(opValue.get("kind"))) continue;
            functions.add(this.constructCsnOperation(serviceModel.getServiceName(), opName, opValue));
        }
        serviceModel.setActions(actions);
        serviceModel.setFunctions(functions);
    }

    private void addOperationsToEntity(Map<String, Object> actionsMap, String serviceName, CSNEntityModel entityModel) {
        if (entityModel == null || actionsMap == null || actionsMap.isEmpty()) {
            return;
        }
        ArrayList<CSNOperationModel> actions = new ArrayList<CSNOperationModel>();
        ArrayList<CSNOperationModel> functions = new ArrayList<CSNOperationModel>();
        for (Map.Entry<String, Object> operation : actionsMap.entrySet()) {
            Map opValue = (Map)operation.getValue();
            String opName = operation.getKey();
            if ("action".equals(opValue.get("kind"))) {
                actions.add(this.constructCsnOperation(serviceName, opName, opValue));
                continue;
            }
            if (!"function".equals(opValue.get("kind"))) continue;
            functions.add(this.constructCsnOperation(serviceName, opName, opValue));
        }
        entityModel.setActions(actions);
        entityModel.setFunctions(functions);
    }

    private void addEntitiesToService(Map<String, Object> definitionMap, Map<String, String> svcMap) {
        for (Map.Entry<String, Object> entry : definitionMap.entrySet()) {
            Map entryValue = (Map)entry.getValue();
            String csnObjKind = (String)entryValue.get("kind");
            String entryKey = entry.getKey();
            if (!"entity".equals(csnObjKind) && !"view".equals(csnObjKind)) continue;
            CSNEntityModel csnEntity = new CSNEntityModel();
            Map elementMap = (Map)entryValue.get("elements");
            ArrayList<Map> queryList = null;
            Map<String, String> names = this.getEntityAndServiceName(entryKey);
            if (!svcMap.containsKey(names.get("service"))) continue;
            csnEntity.setEntityName(names.get("entity"));
            csnEntity.setParentService(names.get("service"));
            csnEntity.setElements(this.constructCsnElementList(elementMap));
            csnEntity.setAssociations(this.constructCsnAssociationList(elementMap));
            csnEntity.setAnnotations(this.constructCsnAnnotationList(entryValue));
            if (entryValue.get("query") instanceof List) {
                queryList = (ArrayList<Map>)entryValue.get("query");
            } else {
                Map query = (Map)entryValue.get("query");
                if (query != null) {
                    queryList = new ArrayList<Map>();
                    queryList.add(query);
                }
            }
            csnEntity.setQueries(this.constructCsnQueryList((List<Object>)queryList));
            if (entryValue.containsKey("actions") && entryValue.containsKey("@odata.draft.enabled") && entryValue.get("@odata.draft.enabled") != null && ((Boolean)entryValue.get("@odata.draft.enabled")).booleanValue()) {
                csnEntity.setDraftEnabled((Boolean)entryValue.get("@odata.draft.enabled"));
                Map actionsMap = (Map)entryValue.get("actions");
                this.addOperationsToEntity(actionsMap, names.get("service"), csnEntity);
            }
            if (entryValue.containsKey("@cds.persistence.skip")) {
                if (entryValue.get("@cds.persistence.skip") instanceof Boolean) {
                    csnEntity.setCdsPersistenceSkipAnnotationEnabled((Boolean)entryValue.get("@cds.persistence.skip"));
                } else if (entryValue.get("@cds.persistence.skip") instanceof String && "if-unused".equals(entryValue.get("@cds.persistence.skip"))) {
                    csnEntity.setCdsPersistenceSkipAnnotationEnabled(true);
                } else if (this.getPersistenceValue(entryValue)) {
                    csnEntity.setCdsPersistenceSkipAnnotationEnabled(true);
                }
            }
            if (!"".equals(csnEntity.getParentService())) {
                this.csnServiceMap.get(names.get("service")).getEntities().add(csnEntity);
                continue;
            }
            this.csnIndpendentEntityMap.put(csnEntity.getEntityName(), csnEntity);
        }
    }

    private boolean getPersistenceValue(Map<String, Object> entryValue) {
        Map entry = (Map)entryValue.get("@cds.persistence.skip");
        return "if-unused".equals(entry.get("="));
    }

    private Map<String, String> getEntityAndServiceName(String fullname) {
        HashMap<String, String> names = new HashMap<String, String>();
        if (fullname.indexOf(46) > 0) {
            int lastIndex = fullname.lastIndexOf(46);
            String entityName = fullname.substring(lastIndex + 1, fullname.length());
            String serviceName = fullname.substring(0, lastIndex);
            names.put("entity", entityName);
            names.put("service", serviceName);
        } else if (fullname.indexOf(46) == -1) {
            names.put("entity", fullname);
            names.put("service", "");
        }
        return names;
    }

    private CSNElementModel constructCsnElement(String elementName, Map<String, Object> elementValueMap) {
        CsnParserUtil.logDebug(log, "constructCsnElement started");
        CSNElementModel element = new CSNElementModel();
        element.setName(elementName);
        for (Map.Entry<String, Object> entry : elementValueMap.entrySet()) {
            String eleAttributeKey;
            switch (eleAttributeKey = entry.getKey()) {
                case "type": {
                    element.setType((String)entry.getValue());
                    break;
                }
                case "key": {
                    element.setKey((Boolean)entry.getValue());
                    break;
                }
                case "not null": {
                    element.setNotnull((Boolean)entry.getValue());
                    break;
                }
                case "length": {
                    element.setLength((Integer)entry.getValue());
                }
            }
        }
        CsnParserUtil.logDebug(log, "constructCsnElement ended");
        return element;
    }

    private List<CSNElementModel> constructCsnElementList(Map<String, Object> elementsMap) {
        ArrayList<CSNElementModel> elements = new ArrayList<CSNElementModel>();
        CsnParserUtil.logDebug(log, "constructCsnElementList started");
        for (Map.Entry<String, Object> entry : elementsMap.entrySet()) {
            String elementName = entry.getKey();
            Map ele = (Map)entry.getValue();
            if ("cds.Association".equals(ele.get("type")) || "cds.Composition".equals(ele.get("type"))) continue;
            elements.add(this.constructCsnElement(elementName, ele));
        }
        CsnParserUtil.logDebug(log, "constructCsnElementList ended");
        return elements;
    }

    private CSNAssociationModel constructCsnAssociation(String associationName, Map<String, Object> associationValueMap) {
        CsnParserUtil.logDebug(log, "constructCsnAssociation started");
        CSNAssociationModel association = new CSNAssociationModel();
        association.setAssociationName(associationName);
        for (Map.Entry<String, Object> entry : associationValueMap.entrySet()) {
            String eleAttributeKey;
            switch (eleAttributeKey = entry.getKey()) {
                case "type": {
                    association.setType((String)entry.getValue());
                    break;
                }
                case "target": {
                    String qualifiedEntityName = (String)entry.getValue();
                    if (qualifiedEntityName.indexOf(46) == -1) {
                        association.setTargetEntity(qualifiedEntityName);
                        break;
                    }
                    if (qualifiedEntityName.indexOf(46) <= 0) break;
                    Map<String, String> names = this.getEntityAndServiceName(qualifiedEntityName);
                    association.setTargetEntity(names.get("entity"));
                    association.setTargetService(names.get("service"));
                    break;
                }
                case "cardinality": {
                    association.setCardinality((Map)entry.getValue());
                    break;
                }
                case "on": {
                    if (entry.getValue() instanceof String) {
                        association.setOn((String)entry.getValue());
                        break;
                    }
                    if (!(entry.getValue() instanceof ArrayList)) break;
                    association.setOn((ArrayList)entry.getValue());
                }
            }
        }
        CsnParserUtil.logDebug(log, "constructCsnAssociation ended");
        return association;
    }

    private List<CSNAssociationModel> constructCsnAssociationList(Map<String, Object> elementsMap) {
        CsnParserUtil.logDebug(log, "constructCsnAssociationList started");
        ArrayList<CSNAssociationModel> associations = new ArrayList<CSNAssociationModel>();
        for (Map.Entry<String, Object> entry : elementsMap.entrySet()) {
            String associationName = entry.getKey();
            Map ele = (Map)entry.getValue();
            if (!"cds.Association".equals(ele.get("type")) && !"cds.Composition".equals(ele.get("type"))) continue;
            associations.add(this.constructCsnAssociation(associationName, ele));
        }
        CsnParserUtil.logDebug(log, "constructCsnAssociationList ended");
        return associations;
    }

    private List<CSNQueryModel> constructCsnQueryList(List<Object> queryList) {
        CsnParserUtil.logDebug(log, "constructCsnQueryList started");
        ArrayList<CSNQueryModel> querys = new ArrayList<CSNQueryModel>();
        if (queryList != null) {
            for (Object queryObj : queryList) {
                CSNQueryModel csnQuery = new CSNQueryModel();
                csnQuery.setValue(queryObj);
                querys.add(csnQuery);
            }
        }
        CsnParserUtil.logDebug(log, "constructCsnQueryList ended");
        return querys;
    }

    private List<CSNAnnotationModel> constructCsnAnnotationList(Map<String, Object> entityMap) {
        CsnParserUtil.logDebug(log, "constructCsnAnnotationList started");
        ArrayList<CSNAnnotationModel> annotations = new ArrayList<CSNAnnotationModel>();
        for (Map.Entry<String, Object> entry : entityMap.entrySet()) {
            String entryKey = entry.getKey();
            if ('@' != entryKey.charAt(0)) continue;
            CSNAnnotationModel anno = new CSNAnnotationModel();
            anno.setName(entryKey);
            anno.setValue(entry.getValue());
            annotations.add(anno);
        }
        CsnParserUtil.logDebug(log, "constructCsnAnnotationList ended");
        return annotations;
    }

    private List<CSNParamModel> constructCsnParamList(Map<String, Object> paramMap) {
        ArrayList<CSNParamModel> params = new ArrayList<CSNParamModel>();
        if (paramMap == null || paramMap.isEmpty()) {
            return params;
        }
        for (Map.Entry<String, Object> entry : paramMap.entrySet()) {
            CSNParamModel param = new CSNParamModel();
            param.setName(entry.getKey());
            Map paramValue = (Map)entry.getValue();
            param.setType((String)paramValue.get("type"));
            params.add(param);
        }
        return params;
    }

    private CSNOperationModel constructCsnOperation(String parentService, String opName, Map<String, Object> operationMap) {
        CsnParserUtil.logDebug(log, "constructCsnOperation started");
        CSNOperationModel operation = null;
        if ("action".equals(operationMap.get("kind")) || "function".equals(operationMap.get("kind"))) {
            operation = new CSNOperationModel();
            operation.setName(opName);
            operation.setParentService(parentService);
            Map params = (Map)operationMap.get("params");
            Map returns = (Map)operationMap.get("returns");
            operation.setParams(this.constructCsnParamList(params));
            operation.setReturns(returns);
        }
        CsnParserUtil.logDebug(log, "constructCsnOperation ended");
        return operation;
    }
}

