/*
 * Decompiled with CFR 0.152.
 */
package com.srm.bpmn.common.utils;

import cn.hutool.core.util.ArrayUtil;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class StringUtil {
    public static boolean isStartWithNumber(String str) {
        Pattern pattern = Pattern.compile("[0-9]*");
        Matcher isNum = pattern.matcher("" + str.charAt(0));
        return isNum.matches();
    }

    public static String join(Iterable<String> strs) {
        return StringUtil.join(strs, ",");
    }

    public static String join(Iterable<String> iterable, String split) {
        StringBuilder sb = new StringBuilder();
        for (String str : iterable) {
            sb.append(str);
            sb.append(split);
        }
        return sb.substring(0, sb.length() - split.length());
    }

    public static String upperFirst(String str) {
        return StringUtil.toFirst(str, true);
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtil.isEmpty(str);
    }

    public static boolean isEmpty(String str) {
        if (str == null) {
            return true;
        }
        return str.trim().equals("");
    }

    public static boolean isZeroEmpty(String tmp) {
        boolean isEmpty = StringUtil.isEmpty(tmp);
        if (isEmpty) {
            return true;
        }
        return "0".equals(tmp);
    }

    public static boolean isNotZeroEmpty(String tmp) {
        return !StringUtil.isZeroEmpty(tmp);
    }

    public static String lowerFirst(String str) {
        return StringUtil.toFirst(str, false);
    }

    public static String toFirst(String str, boolean isUpper) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return "";
        }
        char first = str.charAt(0);
        String firstChar = new String(new char[]{first});
        firstChar = isUpper ? firstChar.toUpperCase() : firstChar.toLowerCase();
        return firstChar + str.substring(1);
    }

    public static String convertDbFieldToField(String dbField) {
        return StringUtil.convertDbFieldToField(dbField, "_", true);
    }

    public static String convertDbFieldToField(String dbField, String symbol, boolean isIgnoreFirst) {
        StringBuilder result = new StringBuilder();
        if (dbField.startsWith(symbol)) {
            dbField = dbField.substring(1);
        }
        if (dbField.endsWith(symbol)) {
            dbField = dbField.substring(0, dbField.length() - 1);
        }
        String[] arr = dbField.split(symbol);
        for (int i = 0; i < arr.length; ++i) {
            Object str = arr[i];
            if (isIgnoreFirst && i != 0) {
                char oldChar = ((String)str).charAt(0);
                char newChar = ("" + oldChar).toUpperCase().charAt(0);
                str = newChar + ((String)str).substring(1);
            }
            result.append((String)str);
        }
        return result.toString();
    }

    public static String[] getStringAryByStr(String str) {
        if (StringUtil.isEmpty(str)) {
            Collections.emptyList();
        }
        return str.split(",");
    }

    public static String join(String[] vals, String separator) {
        if (ArrayUtil.isEmpty((Object[])vals)) {
            return "";
        }
        Object val = "";
        for (int i = 0; i < vals.length; ++i) {
            val = i == 0 ? (String)val + vals[i] : (String)val + separator + vals[i];
        }
        return val;
    }

    public static String trimSuffix(String content, String suffix) {
        String resultStr = content;
        while (resultStr.endsWith(suffix)) {
            resultStr = resultStr.substring(0, resultStr.length() - suffix.length());
        }
        return resultStr;
    }

    public static String trimPrefix(String content, String prefix) {
        String resultStr = content;
        while (resultStr.startsWith(prefix)) {
            resultStr = resultStr.substring(prefix.length());
        }
        return resultStr;
    }
}

