/*
 * Decompiled with CFR 0.152.
 */
package com.srm.bpmn.common.utils;

import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.Assert;

public class TemplateUtils {
    private static Pattern PATTERN = Pattern.compile("^\\d+(,\\d+)*(\\.\\d+)*$");
    private static Pattern EXPRESS = Pattern.compile("\\$\\{([^}]+)}");
    private static String defaultCharacter = "UTF-8";

    private TemplateUtils() {
    }

    public static String processTemplate(String myTemplate, Map<String, Object> map) {
        String result = null;
        String name = "template";
        Matcher matcher = EXPRESS.matcher(myTemplate);
        while (matcher.find()) {
            Matcher rowMatcher;
            String fieldName = matcher.group(1);
            Object o = map.get(fieldName);
            Assert.isTrue((o != null ? 1 : 0) != 0, (String)("\u8868\u8fbe\u5f0f\u3010" + myTemplate + "\u3011\u4e2d\u7684\u5b57\u6bb5\u3010" + fieldName + "\u3011\u53d8\u91cf\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01"));
            if (o == null || !(rowMatcher = PATTERN.matcher(o.toString())).find()) continue;
            map.put(fieldName, o.toString().replaceAll(",", ""));
        }
        try {
            StringTemplateLoader stringTemplateLoader = new StringTemplateLoader();
            stringTemplateLoader.putTemplate(name, myTemplate);
            Configuration cfg = new Configuration(Configuration.VERSION_2_3_27);
            cfg.setDefaultEncoding(defaultCharacter);
            cfg.setTagSyntax(0);
            cfg.setNumberFormat("0.########");
            cfg.setTemplateLoader((TemplateLoader)stringTemplateLoader);
            Template template = cfg.getTemplate(name, defaultCharacter);
            StringWriter out = new StringWriter();
            template.process(map, (Writer)out);
            out.flush();
            result = out.toString();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

