/*
 * Decompiled with CFR 0.152.
 */
package com.srm.bpmn.common.utils;

import cn.hutool.core.collection.CollectionUtil;
import com.srm.bpmn.common.core.domain.TreeEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public final class TreeUtils {
    private TreeUtils() {
    }

    public static <T extends TreeEntity> List<T> loadTree(List<T> trees) {
        List result = trees.stream().filter(m -> StringUtils.isBlank((CharSequence)m.getParentId())).map(m -> {
            m.setChildren(TreeUtils.getChildrenList(m, trees));
            return m;
        }).collect(Collectors.toList());
        return CollectionUtil.isEmpty(result) ? trees : result;
    }

    public static <T extends TreeEntity> List<T> getChildrenList(T root, List<T> list) {
        List children = list.stream().filter(item -> Objects.equals(item.getParentId(), root.getId())).map(item -> {
            item.setChildren(TreeUtils.getChildrenList(item, list));
            return item;
        }).collect(Collectors.toList());
        return children;
    }

    public static <T extends TreeEntity> List<T> getChildrenListByParentId(List<T> sourceList, String parentId) {
        ArrayList children = new ArrayList();
        TreeUtils.getChildrenListByParentId(sourceList, children, parentId);
        return children;
    }

    private static <T extends TreeEntity> void getChildrenListByParentId(List<T> sourceList, List<T> childMenu, String parentId) {
        if (sourceList == null || sourceList.isEmpty() || parentId == null) {
            return;
        }
        sourceList.stream().filter(menu -> StringUtils.isNotBlank((CharSequence)menu.getParentId()) && parentId.equals(menu.getParentId())).forEach(menu -> {
            childMenu.add(menu);
            TreeUtils.getChildrenListByParentId(sourceList, childMenu, menu.getId());
        });
    }
}

