/*
 * Decompiled with CFR 0.152.
 */
package com.talanlabs.avatargenerator.layers.shadows;

import com.talanlabs.avatargenerator.IAvatarInfo;
import com.talanlabs.avatargenerator.layers.shadows.AbstractShadowLayer;
import java.awt.Color;
import java.awt.image.BufferedImage;

public class LongShadowLayer
extends AbstractShadowLayer {
    private Color shadowColor;

    public LongShadowLayer() {
        this(new Color(0, 0, 0, 64));
    }

    public LongShadowLayer(Color shadowColor) {
        super(true);
        this.shadowColor = shadowColor;
    }

    public Color getShadowColor() {
        return this.shadowColor;
    }

    public void setShadowColor(Color shadowColor) {
        this.shadowColor = shadowColor;
    }

    @Override
    protected BufferedImage buildShadow(IAvatarInfo avatarInfo, BufferedImage src) {
        int width = src.getWidth();
        int height = src.getHeight();
        double n = this.shadowColor.getAlpha();
        double step = n / (double)(width + height);
        BufferedImage dest = new BufferedImage(width, height, 2);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (!this.isInShade(src, x, y)) continue;
                int alpha = (int)(n - (double)(x + y) * step);
                int[] colors = new int[]{this.shadowColor.getRed(), this.shadowColor.getGreen(), this.shadowColor.getBlue(), alpha};
                dest.getRaster().setPixel(x, y, colors);
            }
        }
        return dest;
    }

    private boolean isInShade(BufferedImage src, int x, int y) {
        int tx = x;
        int ty = y;
        int[] colors = new int[4];
        do {
            if (--tx < 0 || --ty < 0) {
                return false;
            }
            src.getRaster().getPixel(tx, ty, colors);
        } while (colors[3] <= 0);
        return true;
    }
}

