/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc;

import com.taosdata.jdbc.TSDBConnection;
import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.TSDBJNIConnector;
import com.taosdata.jdbc.TSDBParameterMetaData;
import com.taosdata.jdbc.TSDBStatement;
import com.taosdata.jdbc.TaosGlobalConfig;
import com.taosdata.jdbc.utils.Utils;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.PriorityQueue;

public class TSDBPreparedStatement
extends TSDBStatement
implements PreparedStatement {
    private String rawSql;
    private Object[] parameters = new Object[0];
    private long nativeStmtHandle;
    private String tableName;
    private ArrayList<TableTagInfo> tableTags;
    private int tagValueLength;
    private PriorityQueue<ColumnInfo> queue = new PriorityQueue();

    TSDBPreparedStatement(TSDBConnection connection, String sql) throws SQLException {
        super(connection);
        this.rawSql = sql;
        int parameterCnt = 0;
        if (!sql.contains("?")) {
            return;
        }
        for (int i = 0; i < sql.length(); ++i) {
            if ('?' != sql.charAt(i)) continue;
            ++parameterCnt;
        }
        this.parameters = new Object[parameterCnt];
        TSDBJNIConnector connector = ((TSDBConnection)this.getConnection()).getConnector();
        this.nativeStmtHandle = connector.prepareStmt(this.rawSql);
        this.tableTags = new ArrayList();
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        String sql = Utils.getNativeSql(this.rawSql, this.parameters);
        return this.executeQuery(sql);
    }

    @Override
    public int executeUpdate() throws SQLException {
        String sql = Utils.getNativeSql(this.rawSql, this.parameters);
        return this.executeUpdate(sql);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.setObject(parameterIndex, null);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.setObject(parameterIndex, Float.valueOf(x));
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.setObject(parameterIndex, x.doubleValue());
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.setObject(parameterIndex, new Timestamp(x.getTime()));
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.setObject(parameterIndex, new Timestamp(x.getTime()));
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void clearParameters() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        this.parameters = new Object[this.parameters.length];
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        if (parameterIndex < 1 && parameterIndex >= this.parameters.length) {
            throw TSDBError.createSQLException(8973);
        }
        this.parameters[parameterIndex - 1] = x;
    }

    @Override
    public boolean execute() throws SQLException {
        String sql = Utils.getNativeSql(this.rawSql, this.parameters);
        return this.execute(sql);
    }

    @Override
    public void addBatch() throws SQLException {
        String sql = Utils.getNativeSql(this.rawSql, this.parameters);
        this.addBatch(sql);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.getResultSet() == null) {
            return null;
        }
        return this.getResultSet().getMetaData();
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        return new TSDBParameterMetaData(this.parameters);
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.setString(parameterIndex, value);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    public void setTableName(String name) throws SQLException {
        if (this.nativeStmtHandle == 0L) {
            TSDBJNIConnector connector = ((TSDBConnection)this.getConnection()).getConnector();
            this.nativeStmtHandle = connector.prepareStmt(this.rawSql);
        }
        if (this.tableName != null) {
            this.columnDataAddBatch();
            this.columnDataClearBatchInternal();
        }
        this.tableName = name;
    }

    private void ensureTagCapacity(int index) {
        if (this.tableTags.size() < index + 1) {
            int delta = index + 1 - this.tableTags.size();
            this.tableTags.addAll(Collections.nCopies(delta, null));
        }
    }

    public void setTagNull(int index, int type) {
        this.ensureTagCapacity(index);
        this.tableTags.set(index, TableTagInfo.createNullTag(type));
    }

    public void setTagBoolean(int index, boolean value) {
        this.ensureTagCapacity(index);
        this.tableTags.set(index, new TableTagInfo(value, 1));
        ++this.tagValueLength;
    }

    public void setTagInt(int index, int value) {
        this.ensureTagCapacity(index);
        this.tableTags.set(index, new TableTagInfo(value, 4));
        this.tagValueLength += 4;
    }

    public void setTagByte(int index, byte value) {
        this.ensureTagCapacity(index);
        this.tableTags.set(index, new TableTagInfo(value, 2));
        ++this.tagValueLength;
    }

    public void setTagShort(int index, short value) {
        this.ensureTagCapacity(index);
        this.tableTags.set(index, new TableTagInfo(value, 3));
        this.tagValueLength += 2;
    }

    public void setTagLong(int index, long value) {
        this.ensureTagCapacity(index);
        this.tableTags.set(index, new TableTagInfo(value, 5));
        this.tagValueLength += 8;
    }

    public void setTagTimestamp(int index, long value) {
        this.ensureTagCapacity(index);
        this.tableTags.set(index, new TableTagInfo(value, 9));
        this.tagValueLength += 8;
    }

    public void setTagFloat(int index, float value) {
        this.ensureTagCapacity(index);
        this.tableTags.set(index, new TableTagInfo(Float.valueOf(value), 6));
        this.tagValueLength += 4;
    }

    public void setTagDouble(int index, double value) {
        this.ensureTagCapacity(index);
        this.tableTags.set(index, new TableTagInfo(value, 7));
        this.tagValueLength += 8;
    }

    public void setTagString(int index, String value) {
        this.ensureTagCapacity(index);
        this.tableTags.set(index, new TableTagInfo(value, 8));
        this.tagValueLength += value.getBytes().length;
    }

    public void setTagNString(int index, String value) {
        this.ensureTagCapacity(index);
        this.tableTags.set(index, new TableTagInfo(value, 10));
        String charset = TaosGlobalConfig.getCharset();
        try {
            this.tagValueLength += value.getBytes(charset).length;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public void setTagJson(int index, String value) {
        this.ensureTagCapacity(index);
        this.tableTags.set(index, new TableTagInfo(value, 15));
        String charset = TaosGlobalConfig.getCharset();
        try {
            this.tagValueLength += value.getBytes(charset).length;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public void setTagVarbinary(int index, byte[] value) {
        this.ensureTagCapacity(index);
        this.tableTags.set(index, new TableTagInfo(value, 16));
        this.tagValueLength += value.length;
    }

    public void setTagGeometry(int index, byte[] value) {
        this.ensureTagCapacity(index);
        this.tableTags.set(index, new TableTagInfo(value, 20));
        this.tagValueLength += value.length;
    }

    public <T> void setValueImpl(int columnIndex, ArrayList<T> list, int type, int bytes) throws SQLException {
        ColumnInfo p = new ColumnInfo();
        p.setType(type);
        p.bytes = bytes;
        p.data = (ArrayList)list.clone();
        p.index = columnIndex;
        this.queue.add(p);
    }

    public void setInt(int columnIndex, ArrayList<Integer> list) throws SQLException {
        this.setValueImpl(columnIndex, list, 4, 4);
    }

    public void setFloat(int columnIndex, ArrayList<Float> list) throws SQLException {
        this.setValueImpl(columnIndex, list, 6, 4);
    }

    public void setTimestamp(int columnIndex, ArrayList<Long> list) throws SQLException {
        this.setValueImpl(columnIndex, list, 9, 8);
    }

    public void setLong(int columnIndex, ArrayList<Long> list) throws SQLException {
        this.setValueImpl(columnIndex, list, 5, 8);
    }

    public void setDouble(int columnIndex, ArrayList<Double> list) throws SQLException {
        this.setValueImpl(columnIndex, list, 7, 8);
    }

    public void setBoolean(int columnIndex, ArrayList<Boolean> list) throws SQLException {
        this.setValueImpl(columnIndex, list, 1, 1);
    }

    public void setByte(int columnIndex, ArrayList<Byte> list) throws SQLException {
        this.setValueImpl(columnIndex, list, 2, 1);
    }

    public void setShort(int columnIndex, ArrayList<Short> list) throws SQLException {
        this.setValueImpl(columnIndex, list, 3, 2);
    }

    public void setString(int columnIndex, ArrayList<String> list, int size) throws SQLException {
        this.setValueImpl(columnIndex, list, 8, size);
    }

    public void setVarbinary(int columnIndex, ArrayList<byte[]> list, int size) throws SQLException {
        this.setValueImpl(columnIndex, list, 16, size);
    }

    public void setGeometry(int columnIndex, ArrayList<byte[]> list, int size) throws SQLException {
        this.setValueImpl(columnIndex, list, 20, size);
    }

    public void setNString(int columnIndex, ArrayList<String> list, int size) throws SQLException {
        this.setValueImpl(columnIndex, list, 10, size * 4);
    }

    public void columnDataAddBatch() throws SQLException {
        if (this.rawSql == null) {
            throw TSDBError.createSQLException(9040, "sql statement not set yet");
        }
        int numOfCols = this.queue.size();
        if (numOfCols == 0) {
            throw TSDBError.createSQLException(9040, "column data not bind");
        }
        if (this.nativeStmtHandle == 0L) {
            throw TSDBError.createSQLException(9040, "stmt is null");
        }
        TSDBJNIConnector connector = ((TSDBConnection)this.getConnection()).getConnector();
        if ((this.tableTags == null || this.tableTags.size() == 0) && this.tableName != null) {
            connector.setBindTableName(this.nativeStmtHandle, this.tableName);
        } else if (this.tableTags != null && this.tableTags.size() > 0) {
            if (this.tableName == null) {
                throw TSDBError.createSQLException(9040, "table name not set yet");
            }
            int tagSize = this.tableTags.size();
            ByteBuffer tagDataList = ByteBuffer.allocate(this.tagValueLength);
            tagDataList.order(ByteOrder.LITTLE_ENDIAN);
            ByteBuffer typeList = ByteBuffer.allocate(tagSize);
            typeList.order(ByteOrder.LITTLE_ENDIAN);
            ByteBuffer lengthList = ByteBuffer.allocate(tagSize * 4);
            lengthList.order(ByteOrder.LITTLE_ENDIAN);
            ByteBuffer isNullList = ByteBuffer.allocate(tagSize * 1);
            isNullList.order(ByteOrder.LITTLE_ENDIAN);
            for (TableTagInfo tag : this.tableTags) {
                if (tag.isNull) {
                    typeList.put((byte)tag.type);
                    isNullList.put((byte)1);
                    lengthList.putInt(0);
                    continue;
                }
                switch (tag.type) {
                    case 4: {
                        Object val = (Integer)tag.value;
                        tagDataList.putInt((Integer)val);
                        lengthList.putInt(4);
                        break;
                    }
                    case 2: {
                        Object val = (Byte)tag.value;
                        tagDataList.put((Byte)val);
                        lengthList.putInt(1);
                        break;
                    }
                    case 1: {
                        Object val = (Boolean)tag.value;
                        tagDataList.put((byte)(((Boolean)val).booleanValue() ? 1 : 0));
                        lengthList.putInt(1);
                        break;
                    }
                    case 3: {
                        Object val = (Short)tag.value;
                        tagDataList.putShort((Short)val);
                        lengthList.putInt(2);
                        break;
                    }
                    case 5: 
                    case 9: {
                        Object val = (Long)tag.value;
                        tagDataList.putLong(val == null ? 0L : (Long)val);
                        lengthList.putInt(8);
                        break;
                    }
                    case 6: {
                        Object val = (Float)tag.value;
                        tagDataList.putFloat(val == null ? 0.0f : ((Float)val).floatValue());
                        lengthList.putInt(4);
                        break;
                    }
                    case 7: {
                        Object val = (Double)tag.value;
                        tagDataList.putDouble(val == null ? 0.0 : (Double)val);
                        lengthList.putInt(8);
                        break;
                    }
                    case 8: 
                    case 10: 
                    case 15: {
                        byte[] b;
                        String charset = TaosGlobalConfig.getCharset();
                        String val = (String)tag.value;
                        try {
                            b = tag.type == 8 ? val.getBytes() : val.getBytes(charset);
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new RuntimeException(e.getMessage());
                        }
                        tagDataList.put(b);
                        lengthList.putInt(b.length);
                        break;
                    }
                    case 16: 
                    case 20: {
                        Object val = (byte[])tag.value;
                        tagDataList.put((byte[])val);
                        lengthList.putInt(((Object)val).length);
                        break;
                    }
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: {
                        throw TSDBError.createSQLException(9040, "not support data types");
                    }
                }
                typeList.put((byte)tag.type);
                isNullList.put(tag.isNull ? (byte)1 : 0);
            }
            connector.setBindTableNameAndTags(this.nativeStmtHandle, this.tableName, this.tableTags.size(), tagDataList, typeList, lengthList, isNullList);
        }
        ArrayList<ColumnInfo> colData = new ArrayList<ColumnInfo>();
        for (int i = 0; i < numOfCols; ++i) {
            colData.add(this.queue.poll());
        }
        ColumnInfo colInfo = (ColumnInfo)colData.get(0);
        if (colInfo == null) {
            throw TSDBError.createSQLException(9040, "column data not bind");
        }
        int rows = colInfo.data.size();
        for (int i = 0; i < numOfCols; ++i) {
            ColumnInfo col1 = (ColumnInfo)colData.get(i);
            if (col1 == null || !col1.isTypeSet()) {
                throw TSDBError.createSQLException(9040, "column data not bind");
            }
            if (rows != col1.data.size()) {
                throw TSDBError.createSQLException(9040, "the rows in column data not identical");
            }
            ByteBuffer colDataList = ByteBuffer.allocate(rows * col1.bytes);
            colDataList.order(ByteOrder.LITTLE_ENDIAN);
            ByteBuffer lengthList = ByteBuffer.allocate(rows * 4);
            lengthList.order(ByteOrder.LITTLE_ENDIAN);
            ByteBuffer isNullList = ByteBuffer.allocate(rows * 1);
            isNullList.order(ByteOrder.LITTLE_ENDIAN);
            switch (col1.type) {
                case 4: {
                    for (int j = 0; j < rows; ++j) {
                        Integer val = (Integer)col1.data.get(j);
                        colDataList.putInt(val == null ? Integer.MIN_VALUE : val);
                        isNullList.put((byte)(val == null ? 1 : 0));
                    }
                    break;
                }
                case 2: {
                    for (int j = 0; j < rows; ++j) {
                        Byte val = (Byte)col1.data.get(j);
                        colDataList.put(val == null ? (byte)0 : val);
                        isNullList.put((byte)(val == null ? 1 : 0));
                    }
                    break;
                }
                case 1: {
                    for (int j = 0; j < rows; ++j) {
                        Boolean val = (Boolean)col1.data.get(j);
                        if (val == null) {
                            colDataList.put((byte)0);
                        } else {
                            colDataList.put((byte)(val != false ? 1 : 0));
                        }
                        isNullList.put((byte)(val == null ? 1 : 0));
                    }
                    break;
                }
                case 3: {
                    for (int j = 0; j < rows; ++j) {
                        Short val = (Short)col1.data.get(j);
                        colDataList.putShort(val == null ? (short)0 : val);
                        isNullList.put((byte)(val == null ? 1 : 0));
                    }
                    break;
                }
                case 5: 
                case 9: {
                    for (int j = 0; j < rows; ++j) {
                        Long val = (Long)col1.data.get(j);
                        colDataList.putLong(val == null ? 0L : val);
                        isNullList.put((byte)(val == null ? 1 : 0));
                    }
                    break;
                }
                case 6: {
                    for (int j = 0; j < rows; ++j) {
                        Float val = (Float)col1.data.get(j);
                        colDataList.putFloat(val == null ? 0.0f : val.floatValue());
                        isNullList.put((byte)(val == null ? 1 : 0));
                    }
                    break;
                }
                case 7: {
                    for (int j = 0; j < rows; ++j) {
                        Double val = (Double)col1.data.get(j);
                        colDataList.putDouble(val == null ? 0.0 : val);
                        isNullList.put((byte)(val == null ? 1 : 0));
                    }
                    break;
                }
                case 8: 
                case 10: {
                    String charset = TaosGlobalConfig.getCharset();
                    for (int j = 0; j < rows; ++j) {
                        String val = (String)col1.data.get(j);
                        colDataList.position(j * col1.bytes);
                        if (val != null) {
                            byte[] b;
                            try {
                                b = col1.type == 8 ? val.getBytes() : val.getBytes(charset);
                            }
                            catch (UnsupportedEncodingException e) {
                                throw new RuntimeException(e.getMessage());
                            }
                            if (val.length() > col1.bytes) {
                                throw TSDBError.createSQLException(9040, "string data too long");
                            }
                            colDataList.put(b);
                            lengthList.putInt(b.length);
                            isNullList.put((byte)0);
                            continue;
                        }
                        lengthList.putInt(0);
                        isNullList.put((byte)1);
                    }
                    break;
                }
                case 16: 
                case 20: {
                    for (int j = 0; j < rows; ++j) {
                        byte[] val = (byte[])col1.data.get(j);
                        colDataList.position(j * col1.bytes);
                        if (val != null) {
                            if (val.length > col1.bytes) {
                                throw TSDBError.createSQLException(9040, "varbinary/geometry data too long");
                            }
                            colDataList.put(val);
                            lengthList.putInt(val.length);
                            isNullList.put((byte)0);
                            continue;
                        }
                        lengthList.putInt(0);
                        isNullList.put((byte)1);
                    }
                    break;
                }
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    throw TSDBError.createSQLException(9040, "not support data types");
                }
            }
            connector.bindColumnDataArray(this.nativeStmtHandle, colDataList, lengthList, isNullList, col1.type, col1.bytes, rows, i);
        }
        connector.addBatch(this.nativeStmtHandle);
        this.columnDataClearBatchInternal();
    }

    public void columnDataExecuteBatch() throws SQLException {
        TSDBJNIConnector connector = ((TSDBConnection)this.getConnection()).getConnector();
        connector.executeBatch(this.nativeStmtHandle);
        this.columnDataClearBatchInternal();
    }

    @Deprecated
    public void columnDataClearBatch() {
        this.columnDataClearBatchInternal();
    }

    private void columnDataClearBatchInternal() {
        this.tableName = null;
        if (this.tableTags != null) {
            this.tableTags.clear();
        }
        this.tagValueLength = 0;
    }

    public void columnDataCloseBatch() throws SQLException {
        TSDBJNIConnector connector = ((TSDBConnection)this.getConnection()).getConnector();
        connector.closeBatch(this.nativeStmtHandle);
        this.nativeStmtHandle = 0L;
        this.tableName = null;
    }

    @Override
    public void close() throws SQLException {
        if (this.nativeStmtHandle != 0L) {
            this.columnDataClearBatchInternal();
            this.columnDataCloseBatch();
        }
        super.close();
    }

    private static class TableTagInfo {
        private boolean isNull;
        private final Object value;
        private final int type;

        public TableTagInfo(Object value, int type) {
            this.value = value;
            this.type = type;
        }

        public static TableTagInfo createNullTag(int type) {
            TableTagInfo info = new TableTagInfo(null, type);
            info.isNull = true;
            return info;
        }
    }

    private static class ColumnInfo
    implements Comparable<ColumnInfo> {
        private ArrayList data;
        private int type;
        private int bytes;
        private boolean typeIsSet = false;
        private int index;

        public void setType(int type) throws SQLException {
            if (this.isTypeSet()) {
                throw TSDBError.createSQLException(9040, "column data type has been set");
            }
            this.typeIsSet = true;
            this.type = type;
        }

        public boolean isTypeSet() {
            return this.typeIsSet;
        }

        @Override
        public int compareTo(ColumnInfo c) {
            return this.index > c.index ? 1 : -1;
        }
    }
}

