/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.utils;

import java.util.Properties;
import java.util.StringTokenizer;

public class StringUtils {
    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isNumeric(String str) {
        if (StringUtils.isEmpty(str)) {
            return false;
        }
        int i = str.length();
        while (--i >= 0) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static Properties parseUrl(String url, Properties defaults) {
        int indexOfColon;
        Properties urlProps;
        Properties properties = urlProps = defaults != null ? defaults : new Properties();
        if (StringUtils.isEmpty(url)) {
            return urlProps;
        }
        int beginningOfSlashes = url.indexOf("//");
        int index = url.indexOf("?");
        if (index != -1) {
            String paramString = url.substring(index + 1);
            url = url.substring(0, index);
            StringTokenizer queryParams = new StringTokenizer(paramString, "&");
            while (queryParams.hasMoreElements()) {
                String parameterValuePair = queryParams.nextToken();
                int indexOfEqual = parameterValuePair.indexOf("=");
                String parameter = null;
                String value = null;
                if (indexOfEqual != -1) {
                    parameter = parameterValuePair.substring(0, indexOfEqual);
                    if (indexOfEqual + 1 < parameterValuePair.length()) {
                        value = parameterValuePair.substring(indexOfEqual + 1);
                    }
                }
                if (value == null || value.length() <= 0 || parameter.length() <= 0) continue;
                urlProps.setProperty(parameter, value);
            }
        }
        String dbProductName = url.substring(0, beginningOfSlashes);
        dbProductName = dbProductName.substring(dbProductName.indexOf(":") + 1);
        dbProductName = dbProductName.substring(0, dbProductName.indexOf(":"));
        urlProps.setProperty("productName", dbProductName);
        url = url.substring(beginningOfSlashes + 2);
        int indexOfSlash = url.indexOf("/");
        if (indexOfSlash != -1) {
            if (indexOfSlash + 1 < url.length()) {
                urlProps.setProperty("dbname", url.substring(indexOfSlash + 1).toLowerCase());
            }
            url = url.substring(0, indexOfSlash);
        }
        if ((indexOfColon = url.indexOf(":")) != -1) {
            if (indexOfColon + 1 < url.length()) {
                urlProps.setProperty("port", url.substring(indexOfColon + 1));
            }
            url = url.substring(0, indexOfColon);
        }
        if (url.length() > 0 && url.trim().length() > 0) {
            urlProps.setProperty("host", url);
        }
        return urlProps;
    }

    public static byte[] hexToBytes(String hex) {
        int byteLen = hex.length() / 2;
        byte[] bytes = new byte[byteLen];
        for (int i = 0; i < hex.length() / 2; ++i) {
            byte b;
            int i2 = 2 * i;
            if (i2 + 1 > hex.length()) {
                throw new IllegalArgumentException("Hex string has odd length");
            }
            int nib1 = StringUtils.hexToInt(hex.charAt(i2));
            int nib0 = StringUtils.hexToInt(hex.charAt(i2 + 1));
            bytes[i] = b = (byte)((nib1 << 4) + (byte)nib0);
        }
        return bytes;
    }

    private static int hexToInt(char hex) {
        int nib = Character.digit(hex, 16);
        if (nib < 0) {
            throw new IllegalArgumentException("Invalid hex digit: '" + hex + "'");
        }
        return nib;
    }

    public static String bytesToHex(byte[] bytes) {
        return StringUtils.toHex(bytes);
    }

    public static String toHex(byte[] bytes) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            buf.append(StringUtils.toHexDigit(b >> 4 & 0xF));
            buf.append(StringUtils.toHexDigit(b & 0xF));
        }
        return buf.toString();
    }

    private static char toHexDigit(int n) {
        if (n < 0 || n > 15) {
            throw new IllegalArgumentException("Nibble value out of range: " + n);
        }
        if (n <= 9) {
            return (char)(48 + n);
        }
        return (char)(65 + (n - 10));
    }
}

