/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.ws;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.taosdata.jdbc.AbstractConnection;
import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.enums.WSFunction;
import com.taosdata.jdbc.rs.ConnectionParam;
import com.taosdata.jdbc.rs.RestfulDatabaseMetaData;
import com.taosdata.jdbc.utils.ReqId;
import com.taosdata.jdbc.ws.FutureResponse;
import com.taosdata.jdbc.ws.InFlightRequest;
import com.taosdata.jdbc.ws.TSWSPreparedStatement;
import com.taosdata.jdbc.ws.Transport;
import com.taosdata.jdbc.ws.WSStatement;
import com.taosdata.jdbc.ws.entity.Code;
import com.taosdata.jdbc.ws.entity.ConnectReq;
import com.taosdata.jdbc.ws.entity.ConnectResp;
import com.taosdata.jdbc.ws.entity.Request;
import com.taosdata.jdbc.ws.entity.Response;
import com.taosdata.jdbc.ws.stmt.entity.STMTAction;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;

public class WSConnection
extends AbstractConnection {
    private final Transport transport;
    private final DatabaseMetaData metaData;
    private String database;
    private final ConnectionParam param;
    private Transport prepareTransport;
    CopyOnWriteArrayList<Statement> statementList = new CopyOnWriteArrayList();

    public WSConnection(String url, Properties properties, Transport transport, ConnectionParam param) {
        super(properties);
        this.transport = transport;
        this.database = param.getDatabase();
        this.param = param;
        this.metaData = new RestfulDatabaseMetaData(url, properties.getProperty("user"), this);
    }

    @Override
    public Statement createStatement() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        if (this.getClientInfo("dbname") != null) {
            this.database = this.getClientInfo("dbname");
        }
        WSStatement statement = new WSStatement(this.transport, this.database, this);
        this.statementList.add(statement);
        return statement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        if (this.getClientInfo("dbname") != null) {
            this.database = this.getClientInfo("dbname");
        }
        if (this.prepareTransport != null && !this.prepareTransport.isClosed()) {
            return new TSWSPreparedStatement(this.transport, this.prepareTransport, this.param, this.database, this, sql);
        }
        WSConnection wSConnection = this;
        synchronized (wSConnection) {
            if (this.prepareTransport != null && !this.prepareTransport.isClosed()) {
                return new TSWSPreparedStatement(this.transport, this.prepareTransport, this.param, this.database, this, sql);
            }
            this.prepareTransport = WSConnection.initPrepareTransport(this.param, this.database);
        }
        TSWSPreparedStatement preparedStatement = new TSWSPreparedStatement(this.transport, this.prepareTransport, this.param, this.database, this, sql);
        this.statementList.add(preparedStatement);
        return preparedStatement;
    }

    @Override
    public void close() throws SQLException {
        for (Statement statement : this.statementList) {
            statement.close();
        }
        this.transport.close();
        if (this.prepareTransport != null) {
            this.prepareTransport.close();
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.transport.isClosed();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        return this.metaData;
    }

    public static Transport initPrepareTransport(ConnectionParam param, String db) throws SQLException {
        InFlightRequest inFlightRequest = new InFlightRequest(param.getRequestTimeout(), param.getMaxRequest());
        Transport ts = new Transport(WSFunction.STMT, param, inFlightRequest);
        ts.setTextMessageHandler(message -> {
            STMTAction action;
            JSONObject jsonObject = JSON.parseObject((String)message);
            Response response = (Response)jsonObject.toJavaObject((action = STMTAction.of(jsonObject.getString("action"))).getClazz());
            FutureResponse remove = inFlightRequest.remove(response.getAction(), response.getReqId());
            if (null != remove) {
                remove.getFuture().complete(response);
            }
        });
        Transport.checkConnection(ts, param.getConnectTimeout());
        ConnectReq connectReq = new ConnectReq();
        connectReq.setReqId(ReqId.getReqID());
        connectReq.setUser(param.getUser());
        connectReq.setPassword(param.getPassword());
        connectReq.setDb(db);
        if (param.getConnectMode() == 1) {
            connectReq.setMode(0);
        }
        ConnectResp auth = (ConnectResp)ts.send(new Request(STMTAction.CONN.getAction(), connectReq));
        if (Code.SUCCESS.getCode() != auth.getCode()) {
            ts.close();
            throw new SQLException("(0x" + Integer.toHexString(auth.getCode()) + "):prepareStatement auth failure:" + auth.getMessage());
        }
        return ts;
    }

    public ConnectionParam getParam() {
        return this.param;
    }
}

