/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.tencent.ads.ApiCallback;
import com.tencent.ads.ApiClient;
import com.tencent.ads.ApiException;
import com.tencent.ads.ApiResponse;
import com.tencent.ads.Configuration;
import com.tencent.ads.Pair;
import com.tencent.ads.ProgressRequestBody;
import com.tencent.ads.ProgressResponseBody;
import com.tencent.ads.model.DailyReportsGetResponse;
import com.tencent.ads.model.FilteringStruct;
import com.tencent.ads.model.OrderByStruct;
import com.tencent.ads.model.ReportDateRange;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class DailyReportsApi {
    private ApiClient apiClient;

    public DailyReportsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DailyReportsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call dailyReportsGetCall(Long accountId, String level, ReportDateRange dateRange, List<FilteringStruct> filtering, List<String> groupBy, List<OrderByStruct> orderBy, Long page, Long pageSize, String timeLine, List<String> fields, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/daily_reports/get";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (accountId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("account_id", accountId));
        }
        if (level != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("level", level));
        }
        if (dateRange != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("date_range", dateRange));
        }
        if (filtering != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "filtering", filtering));
        }
        if (groupBy != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "group_by", groupBy));
        }
        if (orderBy != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "order_by", orderBy));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page_size", pageSize));
        }
        if (timeLine != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("time_line", timeLine));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "fields", fields));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call dailyReportsGetValidateBeforeCall(Long accountId, String level, ReportDateRange dateRange, List<FilteringStruct> filtering, List<String> groupBy, List<OrderByStruct> orderBy, Long page, Long pageSize, String timeLine, List<String> fields, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling dailyReportsGet(Async)");
        }
        if (level == null) {
            throw new ApiException("Missing the required parameter 'level' when calling dailyReportsGet(Async)");
        }
        if (dateRange == null) {
            throw new ApiException("Missing the required parameter 'dateRange' when calling dailyReportsGet(Async)");
        }
        Call call = this.dailyReportsGetCall(accountId, level, dateRange, filtering, groupBy, orderBy, page, pageSize, timeLine, fields, progressListener, progressRequestListener);
        return call;
    }

    public DailyReportsGetResponse dailyReportsGet(Long accountId, String level, ReportDateRange dateRange, List<FilteringStruct> filtering, List<String> groupBy, List<OrderByStruct> orderBy, Long page, Long pageSize, String timeLine, List<String> fields) throws ApiException {
        ApiResponse<DailyReportsGetResponse> resp = this.dailyReportsGetWithHttpInfo(accountId, level, dateRange, filtering, groupBy, orderBy, page, pageSize, timeLine, fields);
        return resp.getData();
    }

    public ApiResponse<DailyReportsGetResponse> dailyReportsGetWithHttpInfo(Long accountId, String level, ReportDateRange dateRange, List<FilteringStruct> filtering, List<String> groupBy, List<OrderByStruct> orderBy, Long page, Long pageSize, String timeLine, List<String> fields) throws ApiException {
        Call call = this.dailyReportsGetValidateBeforeCall(accountId, level, dateRange, filtering, groupBy, orderBy, page, pageSize, timeLine, fields, null, null);
        Type localVarReturnType = new TypeToken<DailyReportsGetResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call dailyReportsGetAsync(Long accountId, String level, ReportDateRange dateRange, List<FilteringStruct> filtering, List<String> groupBy, List<OrderByStruct> orderBy, Long page, Long pageSize, String timeLine, List<String> fields, final ApiCallback<DailyReportsGetResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.dailyReportsGetValidateBeforeCall(accountId, level, dateRange, filtering, groupBy, orderBy, page, pageSize, timeLine, fields, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DailyReportsGetResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

