/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.tencent.ads.ApiCallback;
import com.tencent.ads.ApiClient;
import com.tencent.ads.ApiException;
import com.tencent.ads.ApiResponse;
import com.tencent.ads.Configuration;
import com.tencent.ads.Pair;
import com.tencent.ads.ProgressRequestBody;
import com.tencent.ads.ProgressResponseBody;
import com.tencent.ads.model.ProductCatalogsAddRequest;
import com.tencent.ads.model.ProductCatalogsAddResponse;
import com.tencent.ads.model.ProductCatalogsGetResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ProductCatalogsApi {
    private ApiClient apiClient;

    public ProductCatalogsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ProductCatalogsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call productCatalogsAddCall(ProductCatalogsAddRequest data, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ProductCatalogsAddRequest localVarPostBody = data;
        String localVarPath = "/product_catalogs/add";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "application/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call productCatalogsAddValidateBeforeCall(ProductCatalogsAddRequest data, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (data == null) {
            throw new ApiException("Missing the required parameter 'data' when calling productCatalogsAdd(Async)");
        }
        Call call = this.productCatalogsAddCall(data, progressListener, progressRequestListener);
        return call;
    }

    public ProductCatalogsAddResponse productCatalogsAdd(ProductCatalogsAddRequest data) throws ApiException {
        ApiResponse<ProductCatalogsAddResponse> resp = this.productCatalogsAddWithHttpInfo(data);
        return resp.getData();
    }

    public ApiResponse<ProductCatalogsAddResponse> productCatalogsAddWithHttpInfo(ProductCatalogsAddRequest data) throws ApiException {
        Call call = this.productCatalogsAddValidateBeforeCall(data, null, null);
        Type localVarReturnType = new TypeToken<ProductCatalogsAddResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call productCatalogsAddAsync(ProductCatalogsAddRequest data, final ApiCallback<ProductCatalogsAddResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.productCatalogsAddValidateBeforeCall(data, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ProductCatalogsAddResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call productCatalogsGetCall(Long accountId, Long catalogId, String catalogName, Long page, Long pageSize, List<String> fields, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/product_catalogs/get";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (accountId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("account_id", accountId));
        }
        if (catalogId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("catalog_id", catalogId));
        }
        if (catalogName != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("catalog_name", catalogName));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page_size", pageSize));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "fields", fields));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call productCatalogsGetValidateBeforeCall(Long accountId, Long catalogId, String catalogName, Long page, Long pageSize, List<String> fields, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling productCatalogsGet(Async)");
        }
        Call call = this.productCatalogsGetCall(accountId, catalogId, catalogName, page, pageSize, fields, progressListener, progressRequestListener);
        return call;
    }

    public ProductCatalogsGetResponse productCatalogsGet(Long accountId, Long catalogId, String catalogName, Long page, Long pageSize, List<String> fields) throws ApiException {
        ApiResponse<ProductCatalogsGetResponse> resp = this.productCatalogsGetWithHttpInfo(accountId, catalogId, catalogName, page, pageSize, fields);
        return resp.getData();
    }

    public ApiResponse<ProductCatalogsGetResponse> productCatalogsGetWithHttpInfo(Long accountId, Long catalogId, String catalogName, Long page, Long pageSize, List<String> fields) throws ApiException {
        Call call = this.productCatalogsGetValidateBeforeCall(accountId, catalogId, catalogName, page, pageSize, fields, null, null);
        Type localVarReturnType = new TypeToken<ProductCatalogsGetResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call productCatalogsGetAsync(Long accountId, Long catalogId, String catalogName, Long page, Long pageSize, List<String> fields, final ApiCallback<ProductCatalogsGetResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.productCatalogsGetValidateBeforeCall(accountId, catalogId, catalogName, page, pageSize, fields, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ProductCatalogsGetResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

