/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.examples.BasicOperations.Account;

import com.tencent.ads.ApiContextConfig;
import com.tencent.ads.TencentAds;
import com.tencent.ads.exception.TencentAdsResponseException;
import com.tencent.ads.exception.TencentAdsSDKException;
import com.tencent.ads.model.AccountTypeMap;
import com.tencent.ads.model.FundTransferAddRequest;
import com.tencent.ads.model.FundTransferAddResponseData;

public class AddFundTransfer {
    public String ACCESS_TOKEN = "YOUR ACCESS TOKEN";
    public TencentAds tencentAds;
    public Long amount = null;
    public FundTransferAddRequest data = new FundTransferAddRequest();
    public Long accountId = null;
    public AccountTypeMap fundType = AccountTypeMap.GIFT;
    public String transferType = "AGENCY_TO_ADVERTISER";

    public void init() {
        this.tencentAds = TencentAds.getInstance();
        this.tencentAds.init(new ApiContextConfig().accessToken(this.ACCESS_TOKEN).isDebug(true));
        this.tencentAds.useSandbox();
        this.buildParams();
    }

    public void buildParams() {
        this.data.setAmount(this.amount);
        this.data.setAccountId(this.accountId);
        this.data.setFundType(this.fundType);
        this.data.setTransferType(this.transferType);
    }

    public FundTransferAddResponseData addFundTransfer() throws Exception {
        FundTransferAddResponseData response = this.tencentAds.fundTransfer().fundTransferAdd(this.data);
        return response;
    }

    public static void main(String[] args) {
        try {
            AddFundTransfer addFundTransfer = new AddFundTransfer();
            addFundTransfer.init();
            FundTransferAddResponseData fundTransferAddResponseData = addFundTransfer.addFundTransfer();
        }
        catch (TencentAdsResponseException e) {
            e.printStackTrace();
        }
        catch (TencentAdsSDKException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

