/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.client.autoconfigure;

import com.tongtech.client.autoconfigure.ListenerContainerConfiguration;
import com.tongtech.client.consumer.common.ConsumeModel;
import com.tongtech.client.consumer.common.PullFromWhere;
import com.tongtech.client.consumer.common.PullType;
import com.tongtech.client.core.HTPTemplate;
import com.tongtech.client.exception.HTPException;
import com.tongtech.client.htp.consumer.HTPPullConsumer;
import com.tongtech.client.htp.producer.HtpProducer;
import com.tongtech.client.properties.HTPProperties;
import com.tongtech.client.utils.Validators;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;

@Configuration
@EnableConfigurationProperties(value={HTPProperties.class})
@ConditionalOnProperty(prefix="htp", value={"name-srv-url"}, matchIfMissing=true)
@Import(value={ListenerContainerConfiguration.class})
public class HTPAutoConfiguration
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(HTPAutoConfiguration.class);
    public static final String HTP_TEMPLATE_DEFAULT_GLOBAL_NAME = "htpTemplate";
    public static final String HTP_PRODUCER_BEAN_NAME = "defaultHTPProducer";
    public static final String HTP_CONSUMER_BEAN_NAME = "defaultHTPPullConsumer";
    public static final String HTP_ADMIN = "defaultHTPAdmin";
    @Autowired
    private Environment environment;
    private ApplicationContext applicationContext;

    @PostConstruct
    public void checkProperties() {
        String nameServer = (String)this.environment.getProperty("htp.name-srv-url", String.class);
        if (nameServer == null) {
            log.warn("The necessary spring property 'htp.name-srv-url' is not defined, all htp beans creation are skipped!");
            return;
        }
        String namespace = (String)this.environment.getProperty("htp.namespace", String.class);
        String consumerGroup = (String)this.environment.getProperty("htp.consumer.group", String.class);
        String consumerTopic = (String)this.environment.getProperty("htp.consumer.MsgTopic", String.class);
        boolean autoCommit = this.environment.getProperty("htp.consumer.auto-commit", Boolean.class) == null ? true : (Boolean)this.environment.getProperty("htp.consumer.auto-commit", Boolean.class);
        int retryTimesWhenSendFailed = this.environment.getProperty("htp.producer.retry-times-when-send-failed", Integer.class) == null ? 3 : (Integer)this.environment.getProperty("htp.producer.retry-times-when-send-failed", Integer.class);
        ConsumeModel consumeModel = this.environment.getProperty("htp.consumer.consumeModel", ConsumeModel.class) == null ? ConsumeModel.CLUSTERING : (ConsumeModel)this.environment.getProperty("htp.consumer.consumeModel", ConsumeModel.class);
        PullFromWhere pullFromWhere = this.environment.getProperty("htp.consumer.pullFromWhere", PullFromWhere.class) == null ? PullFromWhere.LocalOffset : (PullFromWhere)this.environment.getProperty("htp.consumer.pullFromWhere", PullFromWhere.class);
        com.tongtech.client.annotation.PullType pullType = this.environment.getProperty("htp.consumer.pullType", com.tongtech.client.annotation.PullType.class) == null ? com.tongtech.client.annotation.PullType.PullContinue : (com.tongtech.client.annotation.PullType)((Object)this.environment.getProperty("htp.consumer.pullType", com.tongtech.client.annotation.PullType.class));
        log.info("htp.nameSrvUrl = {}", (Object)nameServer);
        log.info("htp.namespace = {}", (Object)namespace);
        log.info("htp.producer.retryTimesWhenSendFailed = {}", (Object)retryTimesWhenSendFailed);
        log.info("htp.consumer.group = {}", (Object)consumerGroup);
        log.info("htp.consumer.MsgTopic = {}", (Object)consumerTopic);
        log.info("htp.consumer.autoCommit = {}", (Object)autoCommit);
        log.info("htp.consumer.consumeModel = {}", (Object)consumeModel);
        log.info("htp.consumer.pullFromWhere = {}", (Object)pullFromWhere);
        log.info("htp.consumer.pullType = {}", (Object)pullType);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void checkProperties(HTPProperties htpProperties) {
        Assert.hasText((String)htpProperties.getNameSrvUrl(), (String)"[htp.name-srv-url] must not be null");
        Assert.hasText((String)htpProperties.getNamespace(), (String)"[htp.namespace] must not be null");
        Assert.hasText((String)htpProperties.getConsumer().getGroup(), (String)"[htp.consumer.group] must not be null");
        Assert.hasText((String)htpProperties.getConsumer().getMsgTopic(), (String)"[htp.consumer.MsgTopic] must not be null");
    }

    @Bean(value={"defaultHTPProducer"})
    @ConditionalOnMissingBean(value={HtpProducer.class})
    @ConditionalOnProperty(prefix="htp", value={"name-srv-url", "namespace"})
    public HtpProducer defaultHtpProducer(HTPProperties htpProperties) throws HTPException {
        this.checkProperties(htpProperties);
        HtpProducer producer = new HtpProducer(htpProperties.getNameSrvUrl());
        if (!Validators.isEmpty((String)htpProperties.getProducer().getProducerClientId())) {
            producer.setClientId(htpProperties.getProducer().getProducerClientId());
        }
        producer.setNamespace(htpProperties.getNamespace());
        producer.setRetryTimesWhenSendFailed(htpProperties.getProducer().getRetryTimesWhenSendFailed());
        if (!Validators.isEmpty((String)htpProperties.getUserName())) {
            producer.setUsername(htpProperties.getUserName());
        }
        if (!Validators.isEmpty((String)htpProperties.getPassword())) {
            producer.setPassword(htpProperties.getPassword());
        }
        return producer;
    }

    @Bean(value={"defaultHTPPullConsumer"})
    @ConditionalOnMissingBean(value={HTPPullConsumer.class})
    @ConditionalOnProperty(prefix="htp", value={"name-srv-url", "namespace", "consumer.group", "consumer.MsgTopic"})
    public HTPPullConsumer defaultHtpPullConsumer(HTPProperties htpProperties) throws HTPException {
        this.checkProperties(htpProperties);
        HTPPullConsumer consumer = new HTPPullConsumer(htpProperties.getNameSrvUrl());
        if (!Validators.isEmpty((String)htpProperties.getConsumer().getConsumerClientId())) {
            consumer.setClientId(htpProperties.getConsumer().getConsumerClientId());
        }
        consumer.setConsumerGroup(htpProperties.getConsumer().getGroup());
        consumer.subscribe(htpProperties.getConsumer().getMsgTopic());
        consumer.setNamespace(htpProperties.getNamespace());
        if (!htpProperties.getConsumer().isAutoCommit()) {
            consumer.setClientAcknowledge();
        }
        if (ConsumeModel.BROADCASTING == htpProperties.getConsumer().getConsumeModel()) {
            consumer.setBroadcastEnabled();
            consumer.setPullFromWhere(htpProperties.getConsumer().getPullFromWhere());
        } else {
            consumer.setPullType(PullType.valueOf((String)htpProperties.getConsumer().getPullType().name()));
        }
        consumer.setRebalanceStrategy(htpProperties.getConsumer().getRebalanceStrategy());
        if (!Validators.isEmpty((String)htpProperties.getUserName())) {
            consumer.setUsername(htpProperties.getUserName());
        }
        if (!Validators.isEmpty((String)htpProperties.getPassword())) {
            consumer.setPassword(htpProperties.getPassword());
        }
        return consumer;
    }

    @Bean(destroyMethod="destroy")
    @Conditional(value={ProducerOrConsumerPropertyCondition.class})
    @ConditionalOnMissingBean(name={"htpTemplate"})
    public HTPTemplate getHtpTemplate() {
        HTPTemplate htpTemplate = new HTPTemplate();
        if (this.applicationContext.containsBean(HTP_PRODUCER_BEAN_NAME)) {
            htpTemplate.setProducer((HtpProducer)this.applicationContext.getBean(HTP_PRODUCER_BEAN_NAME));
        }
        if (this.applicationContext.containsBean(HTP_CONSUMER_BEAN_NAME)) {
            htpTemplate.setConsumer((HTPPullConsumer)this.applicationContext.getBean(HTP_CONSUMER_BEAN_NAME));
        }
        return htpTemplate;
    }

    static class ProducerOrConsumerPropertyCondition
    extends AnyNestedCondition {
        public ProducerOrConsumerPropertyCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnBean(value={HTPPullConsumer.class})
        static class DefaultHtpPullConsumerExistsCondition {
            DefaultHtpPullConsumerExistsCondition() {
            }
        }

        @ConditionalOnBean(value={HtpProducer.class})
        static class DefaultHtpProducerExistsCondition {
            DefaultHtpProducerExistsCondition() {
            }
        }
    }
}

