/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.client.autoconfigure;

import com.tongtech.client.annotation.HTPMessageListener;
import com.tongtech.client.annotation.TLQMessageListener;
import com.tongtech.client.core.ValidatorUtils;
import com.tongtech.client.properties.HTPProperties;
import com.tongtech.client.properties.TLQProperties;
import com.tongtech.client.support.HTPListenerConcurrently;
import com.tongtech.client.support.HTPListenerContainer;
import com.tongtech.client.support.HTPListenerOrderly;
import com.tongtech.client.support.TLQListenerConcurrently;
import com.tongtech.client.support.TLQListenerContainer;
import com.tongtech.client.support.TLQListenerOrderly;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.scope.ScopedProxyUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.beans.factory.support.BeanDefinitionValidationException;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties(value={HTPProperties.class, TLQProperties.class})
public class ListenerContainerConfiguration
implements ApplicationContextAware,
SmartInitializingSingleton {
    private static final Logger log = LoggerFactory.getLogger(ListenerContainerConfiguration.class);
    private ConfigurableApplicationContext applicationContext;
    private AtomicLong counter = new AtomicLong(0L);
    private AtomicLong htpCounter = new AtomicLong(0L);
    private StandardEnvironment environment;
    private TLQProperties tlqProperties;
    private HTPProperties htpProperties;

    public ListenerContainerConfiguration(StandardEnvironment environment, TLQProperties tlqProperties, HTPProperties htpProperties) {
        this.environment = environment;
        this.tlqProperties = tlqProperties;
        this.htpProperties = htpProperties;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = (ConfigurableApplicationContext)applicationContext;
    }

    public void afterSingletonsInstantiated() {
        Map<String, Object> beans = this.applicationContext.getBeansWithAnnotation(TLQMessageListener.class).entrySet().stream().filter(entry -> !ScopedProxyUtils.isScopedTarget((String)((String)entry.getKey()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        beans.forEach(this::registerContainer);
        Map<String, Object> htpBeans = this.applicationContext.getBeansWithAnnotation(HTPMessageListener.class).entrySet().stream().filter(entry -> !ScopedProxyUtils.isScopedTarget((String)((String)entry.getKey()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        htpBeans.forEach(this::registerHtpContainer);
    }

    private void registerContainer(String beanName, Object bean) {
        Class clazz = AopProxyUtils.ultimateTargetClass((Object)bean);
        TLQMessageListener annotation = clazz.getAnnotation(TLQMessageListener.class);
        this.validate(annotation);
        String containerBeanName = String.format("%s_%s", TLQListenerContainer.class.getName(), this.counter.incrementAndGet());
        GenericApplicationContext genericApplicationContext = (GenericApplicationContext)this.applicationContext;
        genericApplicationContext.registerBean(containerBeanName, TLQListenerContainer.class, () -> this.createMqListenerContainer(containerBeanName, bean, annotation), new BeanDefinitionCustomizer[0]);
        this.start(beanName, containerBeanName, genericApplicationContext);
    }

    private void registerHtpContainer(String beanName, Object bean) {
        Class clazz = AopProxyUtils.ultimateTargetClass((Object)bean);
        HTPMessageListener annotation = clazz.getAnnotation(HTPMessageListener.class);
        this.validateHtp(annotation);
        String containerBeanName = String.format("%s_%s", HTPListenerContainer.class.getName(), this.htpCounter.incrementAndGet());
        GenericApplicationContext genericApplicationContext = (GenericApplicationContext)this.applicationContext;
        genericApplicationContext.registerBean(containerBeanName, HTPListenerContainer.class, () -> this.createHtpListenerContainer(containerBeanName, bean, annotation), new BeanDefinitionCustomizer[0]);
        this.startHtp(beanName, containerBeanName, genericApplicationContext);
    }

    private void start(String beanName, String containerBeanName, GenericApplicationContext genericApplicationContext) {
        TLQListenerContainer container = (TLQListenerContainer)genericApplicationContext.getBean(containerBeanName, TLQListenerContainer.class);
        if (!container.isRunning()) {
            try {
                container.start();
            }
            catch (Exception e) {
                log.error("Started container failed. {}", (Object)container, (Object)e);
                throw new RuntimeException(e);
            }
        }
        log.info("Register the listener to container, listenerBeanName:{}, containerBeanName:{}", (Object)beanName, (Object)containerBeanName);
    }

    private void startHtp(String beanName, String containerBeanName, GenericApplicationContext genericApplicationContext) {
        HTPListenerContainer container = (HTPListenerContainer)genericApplicationContext.getBean(containerBeanName, HTPListenerContainer.class);
        if (!container.isRunning()) {
            try {
                container.start();
            }
            catch (Exception e) {
                log.error("Started container failed. {}", (Object)container, (Object)e);
                throw new RuntimeException(e);
            }
        }
        log.info("Register the listener to container, listenerBeanName:{}, containerBeanName:{}", (Object)beanName, (Object)containerBeanName);
    }

    private TLQListenerContainer createMqListenerContainer(String name, Object bean, TLQMessageListener annotation) {
        TLQListenerContainer container = new TLQListenerContainer();
        container.setTLQMessageListener(annotation);
        String nameServer = this.environment.resolvePlaceholders(annotation.nameServer());
        nameServer = StringUtils.isEmpty((Object)nameServer) ? this.tlqProperties.getNameSrvUrl() : nameServer;
        container.setNameServer(nameServer);
        String brokeServer = this.environment.resolvePlaceholders(annotation.brokeServer());
        brokeServer = StringUtils.isEmpty((Object)brokeServer) ? this.tlqProperties.getBrokeUrl() : brokeServer;
        container.setBrokeServer(brokeServer);
        container.setDomain(this.environment.resolvePlaceholders(annotation.domain()));
        container.setTopicOrQueue(this.environment.resolvePlaceholders(annotation.topicOrQueue()));
        container.setConsumerGroup(this.environment.resolvePlaceholders(annotation.consumerGroup()));
        if (TLQListenerOrderly.class.isAssignableFrom(bean.getClass())) {
            container.setTlqListenerOrderly((TLQListenerOrderly)bean);
        }
        if (TLQListenerConcurrently.class.isAssignableFrom(bean.getClass())) {
            container.setTlqListenerConcurrently((TLQListenerConcurrently)bean);
        }
        container.setName(name);
        container.setUserName(this.environment.resolvePlaceholders(annotation.userName()));
        container.setPassWord(this.environment.resolvePlaceholders(annotation.passWord()));
        container.setAutoCommit(annotation.autoCommit());
        return container;
    }

    private HTPListenerContainer createHtpListenerContainer(String name, Object bean, HTPMessageListener annotation) {
        HTPListenerContainer container = new HTPListenerContainer();
        container.setHTPMessageListener(annotation);
        String nameServer = this.environment.resolvePlaceholders(annotation.nameServer());
        nameServer = StringUtils.isEmpty((Object)nameServer) ? this.htpProperties.getNameSrvUrl() : nameServer;
        container.setNameServer(nameServer);
        container.setNamespace(this.environment.resolvePlaceholders(annotation.namespace()));
        container.setTopic(this.environment.resolvePlaceholders(annotation.topic()));
        container.setConsumerGroup(this.environment.resolvePlaceholders(annotation.consumerGroup()));
        if (HTPListenerOrderly.class.isAssignableFrom(bean.getClass())) {
            container.setHtpListenerOrderly((HTPListenerOrderly)bean);
        }
        if (HTPListenerConcurrently.class.isAssignableFrom(bean.getClass())) {
            container.setHtpListenerConcurrently((HTPListenerConcurrently)bean);
        }
        container.setName(name);
        container.setUserName(this.environment.resolvePlaceholders(annotation.userName()));
        container.setPassWord(this.environment.resolvePlaceholders(annotation.passWord()));
        container.setAutoCommit(annotation.autoCommit());
        return container;
    }

    private void validate(TLQMessageListener annotation) {
        if (ValidatorUtils.isEmpty(annotation.domain())) {
            throw new BeanDefinitionValidationException("Bad annotation definition in @TLQMessageListener, domain does not null !");
        }
        if (ValidatorUtils.isEmpty(annotation.topicOrQueue())) {
            throw new BeanDefinitionValidationException("Bad annotation definition in @TLQMessageListener, topicOrQueue does not null !");
        }
    }

    private void validateHtp(HTPMessageListener annotation) {
        if (ValidatorUtils.isEmpty(annotation.namespace())) {
            throw new BeanDefinitionValidationException("Bad annotation definition in @HTPMessageListener, namespace does not null !");
        }
        if (ValidatorUtils.isEmpty(annotation.topic())) {
            throw new BeanDefinitionValidationException("Bad annotation definition in @HTPMessageListener, topic does not null !");
        }
        if (annotation.pullInterval() < 0 || annotation.pullInterval() > 65535) {
            throw new BeanDefinitionValidationException("Bad annotation definition in @HTPMessageListener, the value of pullInterval ranges from 0 to 65535 !");
        }
        if (annotation.pullBatchSize() < 1 || annotation.pullBatchSize() > 2000) {
            throw new BeanDefinitionValidationException("Bad annotation definition in @HTPMessageListener, the value of pullBatchSize ranges from 1 to 2000 !");
        }
        if (annotation.maxCachedMessageCount() < 1 || annotation.maxCachedMessageCount() > 65535) {
            throw new BeanDefinitionValidationException("Bad annotation definition in @HTPMessageListener, the value of maxCachedMessageCount ranges from 1 to 65535 !");
        }
        if (annotation.maxCachedBufferSize() < 1 || annotation.maxCachedBufferSize() > 1024) {
            throw new BeanDefinitionValidationException("Bad annotation definition in @HTPMessageListener, the value of maxCachedBufferSize ranges from 1 to 1024 MiB !");
        }
        if (annotation.updateSubscriptionInterval() < 1000) {
            throw new BeanDefinitionValidationException("Bad annotation definition in @HTPMessageListener, the value of updateSubscriptionInterval is greater than 1000 !");
        }
        if (annotation.waitInterval() < 5000L || annotation.waitInterval() > 300000L) {
            throw new BeanDefinitionValidationException("Bad annotation definition in @HTPMessageListener, the value of waitInterval ranges from 5000 to 300000 !");
        }
    }
}

