/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.client.autoconfigure;

import com.tongtech.client.admin.TLQManager;
import com.tongtech.client.autoconfigure.ListenerContainerConfiguration;
import com.tongtech.client.common.ModeType;
import com.tongtech.client.consumer.common.SubscribeType;
import com.tongtech.client.consumer.impl.TLQPullConsumer;
import com.tongtech.client.core.TLQTemplate;
import com.tongtech.client.core.ValidatorUtils;
import com.tongtech.client.exception.TLQClientException;
import com.tongtech.client.producer.TLQProducer;
import com.tongtech.client.properties.TLQProperties;
import com.tongtech.client.request.TLQClient;
import com.tongtech.client.request.TLQServer;
import com.tongtech.client.utils.Validators;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;

@Configuration
@EnableConfigurationProperties(value={TLQProperties.class})
@ConditionalOnClass(value={TLQManager.class})
@ConditionalOnProperty(prefix="tlq", value={"name-srv-url"}, matchIfMissing=true)
@Import(value={ListenerContainerConfiguration.class})
public class TLQAutoConfiguration
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(TLQAutoConfiguration.class);
    public static final String TLQ_TEMPLATE_DEFAULT_GLOBAL_NAME = "tlqTemplate";
    public static final String PRODUCER_BEAN_NAME = "defaultTLQProducer";
    public static final String CONSUMER_BEAN_NAME = "defaultPullConsumer";
    public static final String TLQ_MANAGER = "TLQManager";
    public static final String TLQ_CLIENT = "TLQClient";
    public static final String TLQ_SERVER = "TLQServer";
    @Autowired
    private Environment environment;
    private ApplicationContext applicationContext;

    @PostConstruct
    public void checkProperties() {
        String nameServer = (String)this.environment.getProperty("tlq.name-srv-url", String.class);
        if (nameServer == null) {
            log.warn("The necessary spring property 'tlq.name-srv-url' is not defined, all tlq beans creation are skipped!");
            return;
        }
        String domain = (String)this.environment.getProperty("tlq.domain", String.class);
        String modeType = (String)this.environment.getProperty("tlq.mode-type", String.class);
        int userProxy = this.environment.getProperty("tlq.user-proxy", Integer.class) == null ? 0 : (Integer)this.environment.getProperty("tlq.user-proxy", Integer.class);
        String consumerGroup = (String)this.environment.getProperty("tlq.consumer.group", String.class);
        String consumerTopic = (String)this.environment.getProperty("tlq.consumer.MsgQueueOrTopic", String.class);
        boolean autoCommit = this.environment.getProperty("tlq.consumer.auto-commit", Boolean.class) == null ? true : (Boolean)this.environment.getProperty("tlq.consumer.auto-commit", Boolean.class);
        int subscribeType = this.environment.getProperty("tlq.consumer.subscribe-type", Integer.class) == null ? 0 : (Integer)this.environment.getProperty("tlq.consumer.subscribe-type", Integer.class);
        int retryTimesWhenSendFailed = this.environment.getProperty("tlq.producer.retry-times-when-send-failed", Integer.class) == null ? 3 : (Integer)this.environment.getProperty("tlq.producer.retry-times-when-send-failed", Integer.class);
        log.info("tlq.nameSrvUrl = {}", (Object)nameServer);
        log.info("tlq.domain = {}", (Object)domain);
        log.info("tlq.modeType = {}", (Object)modeType);
        log.info("tlq.userProxy = {}", (Object)userProxy);
        log.info("tlq.consumer.group = {}", (Object)consumerGroup);
        log.info("tlq.consumer.MsgQueueOrTopic = {}", (Object)consumerTopic);
        log.info("tlq.consumer.autoCommit = {}", (Object)autoCommit);
        log.info("tlq.consumer.subscribeType = {}", (Object)subscribeType);
        log.info("tlq.producer.retryTimesWhenSendFailed = {}", (Object)retryTimesWhenSendFailed);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void checkProperties(TLQProperties tlqProperties) {
        Assert.hasText((String)tlqProperties.getNameSrvUrl(), (String)"[tlq.name-srv-url] must not be null");
        Assert.hasText((String)tlqProperties.getDomain(), (String)"[tlq.domain] must not be null");
        Assert.hasText((String)tlqProperties.getConsumer().getGroup(), (String)"[tlq.consumer.group] must not be null");
        Assert.hasText((String)tlqProperties.getConsumer().getMsgQueueOrTopic(), (String)"[tlq.consumer.MsgQueueOrTopic] must not be null");
    }

    @Bean(value={"defaultTLQProducer"})
    @ConditionalOnMissingBean(value={TLQProducer.class})
    @ConditionalOnProperty(prefix="tlq", value={"name-srv-url", "domain"})
    public TLQProducer defaultTLQProducer(TLQProperties tlqProperties) throws TLQClientException {
        this.checkProperties(tlqProperties);
        TLQProducer producer = new TLQProducer();
        if (ModeType.QUEUE.name().equals(tlqProperties.getModeType())) {
            producer.setModeType(ModeType.QUEUE);
        }
        producer.setNamesrvAddr(tlqProperties.getNameSrvUrl());
        if (!ValidatorUtils.isEmpty(tlqProperties.getProducer().getProducerClientId())) {
            producer.setClientId(tlqProperties.getProducer().getProducerClientId());
        }
        producer.setDomain(tlqProperties.getDomain());
        producer.setUserProxy(tlqProperties.getUserProxy());
        producer.setRetryTimesWhenSendFailed(tlqProperties.getProducer().getRetryTimesWhenSendFailed());
        if (!Validators.isEmpty((String)tlqProperties.getUserName())) {
            producer.setUsername(tlqProperties.getUserName());
        }
        if (!Validators.isEmpty((String)tlqProperties.getPassword())) {
            producer.setPassword(tlqProperties.getPassword());
        }
        return producer;
    }

    @Bean(value={"TLQManager"})
    @ConditionalOnMissingBean(value={TLQManager.class})
    @ConditionalOnProperty(prefix="tlq", value={"name-srv-url", "manager.domain", "manager.topic"})
    public TLQManager getTLQManager(TLQProperties tlqProperties) throws TLQClientException {
        Assert.hasText((String)tlqProperties.getNameSrvUrl(), (String)"[tlq.name-srv-url] must not be null");
        TLQManager admin = new TLQManager();
        admin.setNamesrvAddr(tlqProperties.getNameSrvUrl());
        if (!Validators.isEmpty((String)tlqProperties.getUserName())) {
            admin.setUsername(tlqProperties.getUserName());
        }
        if (!Validators.isEmpty((String)tlqProperties.getPassword())) {
            admin.setPassword(tlqProperties.getPassword());
        }
        return admin;
    }

    @Bean(value={"defaultPullConsumer"})
    @ConditionalOnMissingBean(value={TLQPullConsumer.class})
    @ConditionalOnProperty(prefix="tlq", value={"name-srv-url", "domain", "consumer.group", "consumer.MsgQueueOrTopic"})
    public TLQPullConsumer defaultTLQPullConsumer(TLQProperties tlqProperties) throws TLQClientException {
        this.checkProperties(tlqProperties);
        TLQPullConsumer consumer = new TLQPullConsumer(tlqProperties.getConsumer().getGroup());
        consumer.setNamesrvAddr(tlqProperties.getNameSrvUrl());
        consumer.subscribe(tlqProperties.getConsumer().getMsgQueueOrTopic());
        consumer.setDomain(tlqProperties.getDomain());
        if (!ValidatorUtils.isEmpty(tlqProperties.getConsumer().getConsumerClientId())) {
            consumer.setClientId(tlqProperties.getConsumer().getConsumerClientId());
        }
        if (ModeType.QUEUE.name().equals(tlqProperties.getModeType())) {
            consumer.setModeType(ModeType.QUEUE);
        }
        consumer.setAutoCommit(tlqProperties.getConsumer().isAutoCommit());
        if (tlqProperties.getConsumer().getSubscribeType() == 0) {
            consumer.setSubscribeType(SubscribeType.TLQ_SUB_DURABLE);
        } else {
            consumer.setSubscribeType(SubscribeType.TLQ_SUB_NON_DURABLE);
        }
        if (!Validators.isEmpty((String)tlqProperties.getUserName())) {
            consumer.setUsername(tlqProperties.getUserName());
        }
        if (!Validators.isEmpty((String)tlqProperties.getPassword())) {
            consumer.setPassword(tlqProperties.getPassword());
        }
        return consumer;
    }

    @Bean(value={"TLQServer"})
    @ConditionalOnMissingBean(value={TLQServer.class})
    @ConditionalOnProperty(prefix="tlq", value={"broke-url", "srvname"})
    public TLQServer getTLQServe(TLQProperties tlqProperties) throws TLQClientException {
        Assert.hasText((String)tlqProperties.getBrokeUrl(), (String)"[tlq.broke-url] must not be null");
        TLQServer tlqServer = new TLQServer();
        tlqServer.setBrokerAddr(tlqProperties.getBrokeUrl());
        tlqServer.setSvcname(tlqProperties.getSrvName());
        return tlqServer;
    }

    @Bean(value={"TLQClient"})
    @ConditionalOnMissingBean(value={TLQClient.class})
    @ConditionalOnProperty(prefix="tlq", value={"broke-url"})
    public TLQClient getTLQClient(TLQProperties tlqProperties) throws TLQClientException {
        Assert.hasText((String)tlqProperties.getBrokeUrl(), (String)"[tlq.broker-address] must not be null");
        TLQClient tlqClient = new TLQClient();
        tlqClient.setBrokerAddr(tlqProperties.getBrokeUrl());
        return tlqClient;
    }

    @Bean(destroyMethod="destroy")
    @Conditional(value={ProducerOrConsumerPropertyCondition.class})
    @ConditionalOnMissingBean(name={"tlqTemplate"})
    public TLQTemplate getTlqTemplate() {
        TLQTemplate tlqTemplate = new TLQTemplate();
        if (this.applicationContext.containsBean(PRODUCER_BEAN_NAME)) {
            tlqTemplate.setProducer((TLQProducer)this.applicationContext.getBean(PRODUCER_BEAN_NAME));
        }
        if (this.applicationContext.containsBean(CONSUMER_BEAN_NAME)) {
            tlqTemplate.setConsumer((TLQPullConsumer)this.applicationContext.getBean(CONSUMER_BEAN_NAME));
        }
        if (this.applicationContext.containsBean(TLQ_MANAGER)) {
            tlqTemplate.setManager((TLQManager)this.applicationContext.getBean(TLQ_MANAGER));
        }
        return tlqTemplate;
    }

    static class ProducerOrConsumerPropertyCondition
    extends AnyNestedCondition {
        public ProducerOrConsumerPropertyCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnBean(value={TLQManager.class})
        static class DefaultTLQManagerExistsCondition {
            DefaultTLQManagerExistsCondition() {
            }
        }

        @ConditionalOnBean(value={TLQPullConsumer.class})
        static class DefaultTLQPullConsumerExistsCondition {
            DefaultTLQPullConsumerExistsCondition() {
            }
        }

        @ConditionalOnBean(value={TLQProducer.class})
        static class DefaultTLQProducerExistsCondition {
            DefaultTLQProducerExistsCondition() {
            }
        }
    }
}

