/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.client.core;

import com.tongtech.client.consumer.PullCallback;
import com.tongtech.client.consumer.PullResult;
import com.tongtech.client.exception.HTPException;
import com.tongtech.client.htp.consumer.HTPPullConsumer;
import com.tongtech.client.htp.producer.HtpProducer;
import com.tongtech.client.message.Message;
import com.tongtech.client.producer.SendCallback;
import com.tongtech.client.producer.SendResult;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

@Resource
public class HTPTemplate
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(HTPTemplate.class);
    private HtpProducer producer;
    private HTPPullConsumer consumer;
    private String charset = "UTF-8";

    public HtpProducer getProducer() {
        return this.producer;
    }

    public void setProducer(HtpProducer producer) {
        this.producer = producer;
    }

    public HTPPullConsumer getConsumer() {
        return this.consumer;
    }

    public void setConsumer(HTPPullConsumer consumer) {
        this.consumer = consumer;
    }

    public SendResult syncSend(Message message) throws HTPException {
        return this.syncSend(message, this.producer.getSendMsgTimeout());
    }

    public SendResult syncSend(Message message, long timeout) throws HTPException {
        if (Objects.isNull(message)) {
            throw new IllegalArgumentException("`message` cannot be null");
        }
        return this.producer.send(message, timeout);
    }

    public void asyncSend(Message message, SendCallback sendCallback) throws HTPException {
        this.asyncSend(message, sendCallback, this.producer.getSendMsgTimeout());
    }

    public void asyncSend(Message message, SendCallback sendCallback, long timeout) throws HTPException {
        if (Objects.isNull(message)) {
            throw new IllegalArgumentException("message cannot be null");
        }
        this.producer.send(message, sendCallback, timeout);
    }

    public PullResult syncPullMessage(int maxNums) throws HTPException {
        return this.syncPullMessage(maxNums, this.consumer.getPullTimeoutMs());
    }

    public PullResult syncPullMessage(int maxNums, long timeout) throws HTPException {
        return this.consumer.pull(maxNums, timeout);
    }

    public void asyncPullMessage(int maxNums, PullCallback pullCallback) throws HTPException {
        this.asyncPullMessage(maxNums, pullCallback, this.consumer.getPullTimeoutMs());
    }

    public void asyncPullMessage(int maxNums, PullCallback pullCallback, long timeout) throws HTPException {
        this.consumer.pull(maxNums, timeout, pullCallback);
    }

    public void acknowledge(PullResult pullResult) throws HTPException {
        this.consumer.acknowledge(pullResult);
    }

    public void acknowledge(Message message) throws HTPException {
        this.consumer.acknowledge(message);
    }

    public void destroy() {
        if (Objects.nonNull(this.producer)) {
            try {
                this.producer.shutdown();
            }
            catch (Exception e) {
                log.error("Shutdown producer exception: ", (Throwable)e);
                throw e;
            }
        }
        if (Objects.nonNull(this.consumer)) {
            try {
                this.consumer.shutdown();
            }
            catch (Exception e) {
                log.error("Shutdown consumer exception: ", (Throwable)e);
                throw e;
            }
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (Objects.nonNull(this.producer)) {
            try {
                this.producer.start();
            }
            catch (HTPException e) {
                log.error("Start producer exception: ", (Throwable)e);
                throw e;
            }
        }
        if (Objects.nonNull(this.consumer)) {
            try {
                this.consumer.start();
            }
            catch (Exception e) {
                log.error("Start consumer exception: ", (Throwable)e);
                throw e;
            }
        }
    }
}

