/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.client.core;

import com.tongtech.client.admin.TLQManager;
import com.tongtech.client.admin.common.ClientMsgInfo;
import com.tongtech.client.common.TopicType;
import com.tongtech.client.consumer.PullCallback;
import com.tongtech.client.consumer.PullResult;
import com.tongtech.client.consumer.common.ConsumerAck;
import com.tongtech.client.consumer.common.PullType;
import com.tongtech.client.consumer.impl.TLQPullConsumer;
import com.tongtech.client.exception.TLQBrokerException;
import com.tongtech.client.exception.TLQClientException;
import com.tongtech.client.message.Message;
import com.tongtech.client.producer.SendBatchCallback;
import com.tongtech.client.producer.SendBatchResult;
import com.tongtech.client.producer.SendCallback;
import com.tongtech.client.producer.SendResult;
import com.tongtech.client.producer.TLQProducer;
import com.tongtech.client.producer.TopicBrokerInfo;
import com.tongtech.client.remoting.exception.RemotingException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

@Resource
public class TLQTemplate
implements InitializingBean,
DisposableBean {
    private TLQProducer producer;
    private TLQPullConsumer consumer;
    private TLQManager manager;
    private String charset = "UTF-8";

    public TLQManager getManager() {
        return this.manager;
    }

    public void setManager(TLQManager manager) {
        this.manager = manager;
    }

    public TLQProducer getProducer() {
        return this.producer;
    }

    public void setProducer(TLQProducer producer) {
        this.producer = producer;
    }

    public TLQPullConsumer getConsumer() {
        return this.consumer;
    }

    public void setConsumer(TLQPullConsumer consumer) {
        this.consumer = consumer;
    }

    public SendResult syncSend(Message message) throws InterruptedException, RemotingException, TLQBrokerException, TLQClientException {
        return this.syncSend(message, this.producer.getSendMsgTimeout());
    }

    public SendResult syncSend(Message message, long timeout) throws InterruptedException, RemotingException, TLQBrokerException, TLQClientException {
        if (Objects.isNull(message)) {
            throw new IllegalArgumentException("`message` cannot be null");
        }
        return this.producer.send(message, timeout);
    }

    public void asyncSend(Message message, SendCallback sendCallback) throws TLQClientException, RemotingException, InterruptedException {
        this.asyncSend(message, sendCallback, this.producer.getSendMsgTimeout());
    }

    public void asyncSend(Message message, SendCallback sendCallback, long timeout) throws TLQClientException, RemotingException, InterruptedException {
        if (Objects.isNull(message)) {
            throw new IllegalArgumentException("message cannot be null");
        }
        this.producer.send(message, sendCallback, timeout);
    }

    public SendBatchResult syncSendBatch(Collection<Message> messages) throws TLQClientException, RemotingException, TLQBrokerException, InterruptedException {
        return this.syncSendBatch(messages, this.producer.getSendBatchMsgTimeout());
    }

    public SendBatchResult syncSendBatch(Collection<Message> messages, long timeout) throws TLQClientException, RemotingException, TLQBrokerException, InterruptedException {
        return this.producer.sendBatch(messages, timeout);
    }

    public void asyncSendBatch(Collection<Message> messages, SendBatchCallback sendCallback) throws TLQClientException, RemotingException, InterruptedException {
        this.asyncSendBatch(messages, sendCallback, this.producer.getSendBatchMsgTimeout());
    }

    public void asyncSendBatch(Collection<Message> messages, SendBatchCallback sendCallback, long timeout) throws TLQClientException, RemotingException, InterruptedException {
        this.producer.sendBatch(messages, sendCallback, timeout);
    }

    public PullResult syncPullMessage(PullType pullType, long consumerOffset, int maxNums) throws TLQClientException, RemotingException, TLQBrokerException, InterruptedException {
        return this.syncPullMessage(pullType, consumerOffset, maxNums, this.consumer.getPullTimeoutMs());
    }

    public PullResult syncPullMessage(PullType pullType, long consumerOffset, int maxNums, long timeout) throws TLQClientException, RemotingException, TLQBrokerException, InterruptedException {
        return this.consumer.pullMessage(pullType, consumerOffset, maxNums, timeout);
    }

    public void asyncPullMessage(PullType pullType, long consumerOffset, int maxNums, PullCallback pullCallback) throws TLQClientException, RemotingException, TLQBrokerException, InterruptedException {
        this.asyncPullMessage(pullType, consumerOffset, maxNums, pullCallback, this.consumer.getPullTimeoutMs());
    }

    public void asyncPullMessage(PullType pullType, long consumerOffset, int maxNums, PullCallback pullCallback, long timeout) throws TLQClientException, RemotingException, TLQBrokerException, InterruptedException {
        this.consumer.pullMessage(pullType, consumerOffset, maxNums, pullCallback, timeout);
    }

    public void consumerCommitAck(ConsumerAck consumerAck, TopicBrokerInfo messageQueue) throws InterruptedException, TLQClientException {
        this.consumer.consumerCommitAck(consumerAck, messageQueue);
    }

    boolean createTopic(String topicName, TopicType topicType, String domainName) throws RemotingException, InterruptedException, TLQClientException {
        return this.manager.createTopic(topicName, topicType, domainName);
    }

    boolean deleteTopic(String topicName, String domainName) throws RemotingException, InterruptedException, TLQClientException {
        return this.manager.deleteTopic(topicName, domainName);
    }

    boolean createDomain(String domainName) throws RemotingException, InterruptedException, TLQClientException {
        return this.manager.createDomain(domainName);
    }

    boolean deleteDomain(String domainName) throws RemotingException, InterruptedException, TLQClientException {
        return this.manager.deleteDomain(domainName);
    }

    List<ClientMsgInfo> getConsumerInfoForTopic(String topicName, String domainName) throws RemotingException, InterruptedException, TLQClientException {
        return this.manager.getConsumerInfoForTopic(topicName, domainName);
    }

    boolean queryTopicExist(String topicName, String domainName) throws RemotingException, InterruptedException, TLQClientException {
        return this.manager.queryTopicExist(topicName, domainName);
    }

    int queryTopicCount(String domainName) throws RemotingException, InterruptedException, TLQClientException {
        return this.manager.queryTopicCount(domainName);
    }

    boolean queryDomainExist(String domainName) throws RemotingException, InterruptedException, TLQClientException {
        return this.manager.queryDomainExist(domainName);
    }

    int queryDomainUpdateTime(String domainName) throws RemotingException, InterruptedException, TLQClientException {
        return this.manager.queryDomainUpdateTime(domainName);
    }

    int queryDomainCount() throws RemotingException, InterruptedException, TLQClientException {
        return this.manager.queryDomainCount();
    }

    public void destroy() {
        if (Objects.nonNull(this.producer)) {
            this.producer.shutdown();
        }
        if (Objects.nonNull(this.consumer)) {
            this.consumer.shutdown();
        }
        if (Objects.nonNull(this.manager)) {
            this.manager.shutdown();
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (this.producer != null) {
            this.producer.start();
        }
        if (Objects.nonNull(this.consumer)) {
            try {
                this.consumer.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (Objects.nonNull(this.manager)) {
            try {
                this.manager.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

