/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.client.support;

import com.tongtech.client.annotation.ConsumeMode;
import com.tongtech.client.annotation.HTPMessageListener;
import com.tongtech.client.annotation.ModelType;
import com.tongtech.client.consumer.PullResult;
import com.tongtech.client.consumer.common.ConsumeModel;
import com.tongtech.client.consumer.common.PullFromWhere;
import com.tongtech.client.consumer.common.PullType;
import com.tongtech.client.consumer.common.RebalanceStrategy;
import com.tongtech.client.consumer.listener.ConsumeConcurrentlyContext;
import com.tongtech.client.consumer.listener.ConsumeConcurrentlyStatus;
import com.tongtech.client.consumer.listener.ConsumeOrderlyContext;
import com.tongtech.client.consumer.listener.ConsumeOrderlyStatus;
import com.tongtech.client.consumer.listener.MessageListener;
import com.tongtech.client.consumer.listener.MessageListenerConcurrently;
import com.tongtech.client.consumer.listener.MessageListenerOrderly;
import com.tongtech.client.core.HTPPushConsumerLifecycleListener;
import com.tongtech.client.core.ValidatorUtils;
import com.tongtech.client.exception.HTPException;
import com.tongtech.client.htp.consumer.HTPPushConsumer;
import com.tongtech.client.support.HTPListenerConcurrently;
import com.tongtech.client.support.HTPListenerOrderly;
import com.tongtech.client.support.HTPMQListenerContainer;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.Assert;

@Configuration
public class HTPListenerContainer
implements InitializingBean,
HTPMQListenerContainer,
SmartLifecycle,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(HTPListenerContainer.class);
    private ApplicationContext applicationContext;
    private String name;
    private String brokeServer;
    private String nameServer;
    private String consumerGroup;
    private String topic;
    private String namespace;
    private String cluster;
    private int pullBatchSize;
    private long nextOffset;
    private com.tongtech.client.annotation.PullType pullType;
    private RebalanceStrategy rebalanceStrategy;
    private PullFromWhere pullFromWhere;
    private ConsumeModel consumeModel;
    private String charset = "UTF-8";
    private HTPListenerOrderly htpListenerOrderly;
    private HTPListenerConcurrently htpListenerConcurrently;
    private HTPMessageListener htpMessageListener;
    private HTPPushConsumer htpPushConsumer;
    private volatile boolean running;
    private ConsumeMode consumeMode = ConsumeMode.ORDERLY;
    private ModelType modelType = ModelType.TOPIC;
    private String userName;
    private String passWord;
    private boolean autoCommit;
    private int pullInterval;
    private int suspendTime;
    private int maxReconsumeTimes;
    private String deadLetterTopic;
    private int maxCachedMessageCount;
    private int maxCachedBufferSize;
    private int concurrentlyMaxSpan;
    private int updateSubscriptionInterval;
    private boolean allowCreateTopicDelayed;
    private long waitInterval;

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    public String getNameServer() {
        return this.nameServer;
    }

    public void setNameServer(String nameServer) {
        this.nameServer = nameServer;
    }

    public String getBrokeServer() {
        return this.brokeServer;
    }

    public void setBrokeServer(String brokeServer) {
        this.brokeServer = brokeServer;
    }

    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    public void setConsumerGroup(String consumerGroup) {
        this.consumerGroup = consumerGroup;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public long getNextOffset() {
        return this.nextOffset;
    }

    public void setNextOffset(long nextOffset) {
        this.nextOffset = nextOffset;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public HTPMessageListener getHtpMessageListener() {
        return this.htpMessageListener;
    }

    public void setHtpMessageListener(HTPMessageListener htpMessageListener) {
        this.htpMessageListener = htpMessageListener;
    }

    public HTPPushConsumer getHtpPushConsumer() {
        return this.htpPushConsumer;
    }

    public void setHtpPushConsumer(HTPPushConsumer htpPushConsumer) {
        this.htpPushConsumer = htpPushConsumer;
    }

    public ConsumeMode getConsumeMode() {
        return this.consumeMode;
    }

    public void setConsumeMode(ConsumeMode consumeMode) {
        this.consumeMode = consumeMode;
    }

    public ModelType getModelType() {
        return this.modelType;
    }

    public void setModelType(ModelType modelType) {
        this.modelType = modelType;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public int getPullBatchSize() {
        return this.pullBatchSize;
    }

    public void setPullBatchSize(int pullBatchSize) {
        this.pullBatchSize = pullBatchSize;
    }

    public com.tongtech.client.annotation.PullType getPullType() {
        return this.pullType;
    }

    public void setPullType(com.tongtech.client.annotation.PullType pullType) {
        this.pullType = pullType;
    }

    public String getCluster() {
        return this.cluster;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public RebalanceStrategy getRebalanceStrategy() {
        return this.rebalanceStrategy;
    }

    public void setRebalanceStrategy(RebalanceStrategy rebalanceStrategy) {
        this.rebalanceStrategy = rebalanceStrategy;
    }

    public PullFromWhere getPullFromWhere() {
        return this.pullFromWhere;
    }

    public void setPullFromWhere(PullFromWhere pullFromWhere) {
        this.pullFromWhere = pullFromWhere;
    }

    public ConsumeModel getConsumeModel() {
        return this.consumeModel;
    }

    public void setConsumeModel(ConsumeModel consumeModel) {
        this.consumeModel = consumeModel;
    }

    public HTPListenerOrderly getHtpListenerOrderly() {
        return this.htpListenerOrderly;
    }

    public void setHtpListenerOrderly(HTPListenerOrderly htpListenerOrderly) {
        this.htpListenerOrderly = htpListenerOrderly;
    }

    public HTPListenerConcurrently getHtpListenerConcurrently() {
        return this.htpListenerConcurrently;
    }

    public void setHtpListenerConcurrently(HTPListenerConcurrently htpListenerConcurrently) {
        this.htpListenerConcurrently = htpListenerConcurrently;
    }

    public int getPullInterval() {
        return this.pullInterval;
    }

    public void setPullInterval(int pullInterval) {
        this.pullInterval = pullInterval;
    }

    public int getSuspendTime() {
        return this.suspendTime;
    }

    public void setSuspendTime(int suspendTime) {
        this.suspendTime = suspendTime;
    }

    public int getMaxReconsumeTimes() {
        return this.maxReconsumeTimes;
    }

    public void setMaxReconsumeTimes(int maxReconsumeTimes) {
        this.maxReconsumeTimes = maxReconsumeTimes;
    }

    public String getDeadLetterTopic() {
        return this.deadLetterTopic;
    }

    public void setDeadLetterTopic(String deadLetterTopic) {
        this.deadLetterTopic = deadLetterTopic;
    }

    public int getMaxCachedMessageCount() {
        return this.maxCachedMessageCount;
    }

    public void setMaxCachedMessageCount(int maxCachedMessageCount) {
        this.maxCachedMessageCount = maxCachedMessageCount;
    }

    public int getMaxCachedBufferSize() {
        return this.maxCachedBufferSize;
    }

    public void setMaxCachedBufferSize(int maxCachedBufferSize) {
        this.maxCachedBufferSize = maxCachedBufferSize;
    }

    public int getConcurrentlyMaxSpan() {
        return this.concurrentlyMaxSpan;
    }

    public void setConcurrentlyMaxSpan(int concurrentlyMaxSpan) {
        this.concurrentlyMaxSpan = concurrentlyMaxSpan;
    }

    public int getUpdateSubscriptionInterval() {
        return this.updateSubscriptionInterval;
    }

    public void setUpdateSubscriptionInterval(int updateSubscriptionInterval) {
        this.updateSubscriptionInterval = updateSubscriptionInterval;
    }

    public boolean isAllowCreateTopicDelayed() {
        return this.allowCreateTopicDelayed;
    }

    public void setAllowCreateTopicDelayed(boolean allowCreateTopicDelayed) {
        this.allowCreateTopicDelayed = allowCreateTopicDelayed;
    }

    public long getWaitInterval() {
        return this.waitInterval;
    }

    public void setWaitInterval(long waitInterval) {
        this.waitInterval = waitInterval;
    }

    public HTPMessageListener getHTPMessageListener() {
        return this.htpMessageListener;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassWord() {
        return this.passWord;
    }

    public void setPassWord(String passWord) {
        this.passWord = passWord;
    }

    public void setHTPMessageListener(HTPMessageListener anno) {
        this.htpMessageListener = anno;
        this.consumerGroup = anno.consumerGroup();
        this.topic = anno.topic();
        this.namespace = anno.namespace();
        this.cluster = anno.cluster();
        this.pullBatchSize = anno.pullBatchSize();
        this.pullType = anno.pullType();
        this.consumeMode = anno.consumerMode();
        this.nameServer = anno.nameServer();
        this.userName = anno.userName();
        this.passWord = anno.passWord();
        this.autoCommit = anno.autoCommit();
        this.rebalanceStrategy = anno.rebalanceStrategy();
        this.pullFromWhere = anno.pullFromWhere();
        this.consumeModel = anno.consumeModel();
        this.pullInterval = anno.pullInterval();
        this.suspendTime = anno.suspendTime();
        this.maxReconsumeTimes = anno.maxReconsumeTimes();
        this.deadLetterTopic = anno.deadLetterTopic();
        this.maxCachedMessageCount = anno.maxCachedMessageCount();
        this.maxCachedBufferSize = anno.maxCachedBufferSize();
        this.concurrentlyMaxSpan = anno.concurrentlyMaxSpan();
        this.updateSubscriptionInterval = anno.updateSubscriptionInterval();
        this.allowCreateTopicDelayed = anno.allowCreateTopicDelayed();
        this.waitInterval = anno.waitInterval();
    }

    public void destroy() {
        this.setRunning(false);
        if (Objects.nonNull(this.htpPushConsumer)) {
            this.htpPushConsumer.shutdown();
        }
        log.info("htp listener container destroyed, {}", (Object)this);
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public int getPhase() {
        return Integer.MAX_VALUE;
    }

    public void start() {
        if (this.isRunning()) {
            throw new IllegalStateException("container already running. " + this.toString());
        }
        try {
            if (Objects.nonNull(this.htpPushConsumer)) {
                this.htpPushConsumer.start();
            }
        }
        catch (HTPException e) {
            e.printStackTrace();
            throw new IllegalStateException("Failed to start push consumer", e);
        }
        this.setRunning(true);
        log.info("running htp listener container: {}", (Object)this);
    }

    public void stop() {
        if (this.isRunning()) {
            if (Objects.nonNull(this.htpPushConsumer)) {
                this.htpPushConsumer.shutdown();
            }
            this.setRunning(false);
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    private void setRunning(boolean running) {
        this.running = running;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.htpMessageListener != null) {
            this.initHTPPushConsumer();
        }
    }

    public String toString() {
        return "HTPListenerContainer{nameServer='" + this.nameServer + '\'' + ", consumerGroup='" + this.consumerGroup + '\'' + ", topic='" + this.topic + '\'' + ", namespace='" + this.namespace + '\'' + ", cluster='" + this.cluster + '\'' + ", pullBatchSize=" + this.pullBatchSize + ", nextOffset=" + this.nextOffset + ", pullType=" + (Object)((Object)this.pullType) + ", rebalanceStrategy=" + this.rebalanceStrategy + ", pullFromWhere=" + this.pullFromWhere + ", consumeModel=" + this.consumeModel + ", consumeMode=" + (Object)((Object)this.consumeMode) + ", modelType=" + (Object)((Object)this.modelType) + ", userName='" + this.userName + '\'' + ", passWord='" + this.passWord + '\'' + ", autoCommit=" + this.autoCommit + ", pullInterval=" + this.pullInterval + ", suspendTime=" + this.suspendTime + ", maxReconsumeTimes=" + this.maxReconsumeTimes + ", deadLetterTopic='" + this.deadLetterTopic + '\'' + ", maxCachedMessageCount=" + this.maxCachedMessageCount + ", maxCachedBufferSize=" + this.maxCachedBufferSize + ", concurrentlyMaxSpan=" + this.concurrentlyMaxSpan + ", updateSubscriptionInterval=" + this.updateSubscriptionInterval + ", allowCreateTopicDelayed=" + this.allowCreateTopicDelayed + ", waitInterval=" + this.waitInterval + '}';
    }

    private ConsumeConcurrentlyStatus handleMessageConcurrently(PullResult pullResult, ConsumeConcurrentlyContext context) {
        if (this.htpListenerConcurrently != null) {
            return this.htpListenerConcurrently.onMessage(pullResult, context);
        }
        return ConsumeConcurrentlyStatus.RECONSUME_LATER;
    }

    private ConsumeOrderlyStatus handleMessageOrderly(PullResult pullResult, ConsumeOrderlyContext context) {
        if (this.htpListenerOrderly != null) {
            return this.htpListenerOrderly.onMessage(pullResult, context);
        }
        return ConsumeOrderlyStatus.RECONSUME_LATER;
    }

    private void initHTPPushConsumer() throws HTPException {
        if (this.htpListenerOrderly == null && this.htpListenerConcurrently == null) {
            throw new IllegalArgumentException("Property 'HTPListener' is required");
        }
        Assert.notNull((Object)this.consumerGroup, (String)"Property 'consumerGroup' is required");
        Assert.notNull((Object)this.nameServer, (String)"Property 'nameServer' is required");
        Assert.notNull((Object)this.topic, (String)"Property 'topic' is required");
        this.htpPushConsumer = new HTPPushConsumer(this.nameServer);
        this.htpPushConsumer.setCluster(this.cluster);
        this.htpPushConsumer.setConsumerGroup(this.consumerGroup);
        this.htpPushConsumer.setNamespace(this.namespace);
        this.htpPushConsumer.subscribe(this.topic);
        if (ConsumeModel.BROADCASTING == this.consumeModel) {
            this.htpPushConsumer.setBroadcastEnabled();
            this.pullType = com.tongtech.client.annotation.PullType.PullOffset;
        } else {
            this.htpPushConsumer.setPullType(PullType.valueOf((String)this.pullType.name()));
        }
        this.htpPushConsumer.setPullBatchSize(this.pullBatchSize);
        if (!ValidatorUtils.isEmpty(this.userName)) {
            this.htpPushConsumer.setUsername(this.userName);
        }
        if (!ValidatorUtils.isEmpty(this.passWord)) {
            this.htpPushConsumer.setPassword(this.passWord);
        }
        this.htpPushConsumer.setPullInterval((long)this.pullInterval);
        this.htpPushConsumer.setMaxReconsumeTimes(this.maxReconsumeTimes);
        this.htpPushConsumer.setRebalanceStrategy(this.rebalanceStrategy);
        this.htpPushConsumer.setPullFromWhere(this.pullFromWhere);
        this.htpPushConsumer.setMaxCachedMessageCount(this.maxCachedMessageCount);
        this.htpPushConsumer.setMaxCachedBufferSize(this.maxCachedBufferSize);
        this.htpPushConsumer.setConcurrentlyMaxSpan(this.concurrentlyMaxSpan);
        this.htpPushConsumer.setUpdateSubscriptionInterval(this.updateSubscriptionInterval);
        this.htpPushConsumer.setAllowCreateTopicDelayed(this.allowCreateTopicDelayed);
        this.htpPushConsumer.setWaitInterval(this.waitInterval);
        this.htpPushConsumer.setSuspendTime((long)this.suspendTime);
        if (!ValidatorUtils.isEmpty(this.deadLetterTopic)) {
            this.htpPushConsumer.setDeadLetterTopic(this.deadLetterTopic);
        }
        if (!this.autoCommit) {
            this.htpPushConsumer.setClientAcknowledge();
        }
        if (this.htpListenerConcurrently != null) {
            this.htpPushConsumer.registerMessageListener((MessageListener)new DefaultMessageListenerConcurrently());
            if (this.htpListenerConcurrently instanceof HTPPushConsumerLifecycleListener) {
                ((HTPPushConsumerLifecycleListener)((Object)this.htpListenerConcurrently)).prepareStart(this.htpPushConsumer);
            }
            this.consumeMode = ConsumeMode.CONCURRENTLY;
        } else if (this.htpListenerOrderly != null) {
            this.htpPushConsumer.registerMessageListener((MessageListener)new DefaultMessageListenerOrderly());
            if (this.htpListenerOrderly instanceof HTPPushConsumerLifecycleListener) {
                ((HTPPushConsumerLifecycleListener)((Object)this.htpListenerOrderly)).prepareStart(this.htpPushConsumer);
            }
            this.consumeMode = ConsumeMode.ORDERLY;
        }
    }

    public class DefaultMessageListenerOrderly
    implements MessageListenerOrderly {
        public ConsumeOrderlyStatus consumeMessage(PullResult pullResult, ConsumeOrderlyContext context) {
            return HTPListenerContainer.this.handleMessageOrderly(pullResult, context);
        }
    }

    public class DefaultMessageListenerConcurrently
    implements MessageListenerConcurrently {
        public ConsumeConcurrentlyStatus consumeMessage(PullResult pullResult, ConsumeConcurrentlyContext context) {
            return HTPListenerContainer.this.handleMessageConcurrently(pullResult, context);
        }
    }
}

