/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.client.support;

import com.tongtech.client.annotation.ConsumeMode;
import com.tongtech.client.annotation.ModelType;
import com.tongtech.client.annotation.TLQMessageListener;
import com.tongtech.client.common.ModeType;
import com.tongtech.client.consumer.PullResult;
import com.tongtech.client.consumer.common.ConsumeModel;
import com.tongtech.client.consumer.common.PullType;
import com.tongtech.client.consumer.impl.TLQPushConsumer;
import com.tongtech.client.consumer.listener.ConsumeConcurrentlyContext;
import com.tongtech.client.consumer.listener.ConsumeConcurrentlyStatus;
import com.tongtech.client.consumer.listener.ConsumeOrderlyContext;
import com.tongtech.client.consumer.listener.ConsumeOrderlyStatus;
import com.tongtech.client.consumer.listener.MessageListener;
import com.tongtech.client.consumer.listener.MessageListenerConcurrently;
import com.tongtech.client.consumer.listener.MessageListenerOrderly;
import com.tongtech.client.exception.HTPException;
import com.tongtech.client.exception.TLQClientException;
import com.tongtech.client.support.TLQListenerConcurrently;
import com.tongtech.client.support.TLQListenerOrderly;
import com.tongtech.client.support.TLQMQListenerContainer;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.Assert;

@Configuration
public class TLQListenerContainer
implements InitializingBean,
TLQMQListenerContainer,
SmartLifecycle,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(TLQListenerContainer.class);
    private ApplicationContext applicationContext;
    private String name;
    private String brokeServer;
    private String nameServer;
    private String consumerGroup;
    private String topicOrQueue;
    private String domain;
    private String cluster;
    private int pullBatchSize;
    private long nextOffset;
    private com.tongtech.client.annotation.PullType pullType;
    private String charset = "UTF-8";
    private TLQListenerOrderly tlqListenerOrderly;
    private TLQListenerConcurrently tlqListenerConcurrently;
    private TLQMessageListener tlqMessageListener;
    private TLQPushConsumer pushConsumer;
    private volatile boolean running;
    private ConsumeMode consumeMode = ConsumeMode.ORDERLY;
    private ModelType modelType = ModelType.TOPIC;
    private String userName;
    private String passWord;
    private boolean autoCommit;

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public TLQListenerOrderly getTlqListenerOrderly() {
        return this.tlqListenerOrderly;
    }

    public void setTlqListenerOrderly(TLQListenerOrderly tlqListenerOrderly) {
        this.tlqListenerOrderly = tlqListenerOrderly;
    }

    public TLQListenerConcurrently getTlqListenerConcurrently() {
        return this.tlqListenerConcurrently;
    }

    public void setTlqListenerConcurrently(TLQListenerConcurrently tlqListenerConcurrently) {
        this.tlqListenerConcurrently = tlqListenerConcurrently;
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    public String getNameServer() {
        return this.nameServer;
    }

    public void setNameServer(String nameServer) {
        this.nameServer = nameServer;
    }

    public String getBrokeServer() {
        return this.brokeServer;
    }

    public void setBrokeServer(String brokeServer) {
        this.brokeServer = brokeServer;
    }

    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    public void setConsumerGroup(String consumerGroup) {
        this.consumerGroup = consumerGroup;
    }

    public String getTopicOrQueue() {
        return this.topicOrQueue;
    }

    public void setTopicOrQueue(String topicOrQueue) {
        this.topicOrQueue = topicOrQueue;
    }

    public long getNextOffset() {
        return this.nextOffset;
    }

    public void setNextOffset(long nextOffset) {
        this.nextOffset = nextOffset;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public TLQMessageListener getTlqMessageListener() {
        return this.tlqMessageListener;
    }

    public void setTlqMessageListener(TLQMessageListener tlqMessageListener) {
        this.tlqMessageListener = tlqMessageListener;
    }

    public TLQPushConsumer getPushConsumer() {
        return this.pushConsumer;
    }

    public void setPushConsumer(TLQPushConsumer pushConsumer) {
        this.pushConsumer = pushConsumer;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public TLQMessageListener getTLQMessageListener() {
        return this.tlqMessageListener;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassWord() {
        return this.passWord;
    }

    public void setPassWord(String passWord) {
        this.passWord = passWord;
    }

    public void setTLQMessageListener(TLQMessageListener anno) {
        this.tlqMessageListener = anno;
        this.consumerGroup = anno.consumerGroup();
        this.topicOrQueue = anno.topicOrQueue();
        this.domain = anno.domain();
        this.pullBatchSize = anno.pullBatchSize();
        this.nextOffset = anno.nextOffset();
        this.pullType = anno.pullType();
        this.modelType = anno.modelType();
        this.consumeMode = anno.consumerMode();
        this.nameServer = anno.nameServer();
        this.userName = anno.userName();
        this.passWord = anno.passWord();
        this.autoCommit = anno.autoCommit();
    }

    public void destroy() {
        this.setRunning(false);
        if (Objects.nonNull(this.pushConsumer)) {
            this.pushConsumer.shutdown();
        }
        log.info("tlq listener container destroyed, {}", (Object)this.toString());
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public int getPhase() {
        return Integer.MAX_VALUE;
    }

    public void start() {
        if (this.isRunning()) {
            throw new IllegalStateException("container already running. " + this.toString());
        }
        try {
            if (Objects.nonNull(this.pushConsumer)) {
                this.pushConsumer.start();
            }
        }
        catch (HTPException | InterruptedException e) {
            e.printStackTrace();
            throw new IllegalStateException("Failed to start tlq push consumer", e);
        }
        this.setRunning(true);
        log.info("running tlq listener container: {}", (Object)this.toString());
    }

    public void stop() {
        if (this.isRunning()) {
            if (Objects.nonNull(this.pushConsumer)) {
                this.pushConsumer.shutdown();
            }
            this.setRunning(false);
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    private void setRunning(boolean running) {
        this.running = running;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.tlqMessageListener != null) {
            this.initTLQPushConsumer();
        }
    }

    public String toString() {
        return "TLQListenerContainer{nameServer='" + this.nameServer + '\'' + ", consumerGroup='" + this.consumerGroup + '\'' + ", topicOrQueue='" + this.topicOrQueue + '\'' + ", domain='" + this.domain + '\'' + ", pullBatchSize=" + this.pullBatchSize + ", nextOffset=" + this.nextOffset + ", pullType=" + (Object)((Object)this.pullType) + ", running=" + this.running + ", consumeMode=" + (Object)((Object)this.consumeMode) + ", modelType=" + (Object)((Object)this.modelType) + ", userName='" + this.userName + '\'' + ", passWord='" + this.passWord + '\'' + ", autoCommit=" + this.autoCommit + '}';
    }

    private ConsumeConcurrentlyStatus handleMessageConcurrently(PullResult pullResult) {
        if (this.tlqListenerConcurrently != null) {
            return this.tlqListenerConcurrently.onMessage(pullResult);
        }
        return ConsumeConcurrentlyStatus.RECONSUME_LATER;
    }

    private ConsumeOrderlyStatus handleMessageOrderly(PullResult pullResult) {
        if (this.tlqListenerOrderly != null) {
            return this.tlqListenerOrderly.onMessage(pullResult);
        }
        return ConsumeOrderlyStatus.RECONSUME_LATER;
    }

    private void initTLQPushConsumer() throws TLQClientException {
        if (this.tlqListenerOrderly == null && this.tlqListenerConcurrently == null) {
            throw new IllegalArgumentException("Property 'TLQListener' is required");
        }
        Assert.notNull((Object)this.consumerGroup, (String)"Property 'consumerGroup' is required");
        Assert.notNull((Object)this.nameServer, (String)"Property 'nameServer' is required");
        Assert.notNull((Object)this.topicOrQueue, (String)"Property 'topicOrQueue' is required");
        this.pushConsumer = new TLQPushConsumer(this.consumerGroup);
        this.pushConsumer.setNamesrvAddr(this.nameServer);
        this.pushConsumer.setDomain(this.domain);
        this.pushConsumer.subscribe(this.topicOrQueue);
        this.pushConsumer.setNextOffset(this.nextOffset);
        this.pushConsumer.setPullType(PullType.valueOf((String)this.pullType.name()));
        if (com.tongtech.client.annotation.PullType.PullOffset.equals((Object)this.pullType)) {
            this.pushConsumer.setConsumeModel(ConsumeModel.BROADCASTING);
        }
        this.pushConsumer.setPullBatchSize(this.pullBatchSize);
        this.pushConsumer.setUsername(this.userName);
        this.pushConsumer.setPassword(this.passWord);
        this.pushConsumer.setAutoCommit(this.autoCommit);
        switch (this.modelType) {
            case TOPIC: {
                this.pushConsumer.setModeType(ModeType.TOPIC);
                break;
            }
            case QUEUE: {
                this.pushConsumer.setModeType(ModeType.QUEUE);
                break;
            }
        }
        switch (this.consumeMode) {
            case CONCURRENTLY: {
                this.pushConsumer.registerMessageListener((MessageListener)new DefaultMessageListenerConcurrently());
                break;
            }
            default: {
                this.pushConsumer.registerMessageListener((MessageListener)new DefaultMessageListenerOrderly());
            }
        }
    }

    public class DefaultMessageListenerOrderly
    implements MessageListenerOrderly {
        public ConsumeOrderlyStatus consumeMessage(PullResult pullResult, ConsumeOrderlyContext context) {
            return TLQListenerContainer.this.handleMessageOrderly(pullResult);
        }
    }

    public class DefaultMessageListenerConcurrently
    implements MessageListenerConcurrently {
        public ConsumeConcurrentlyStatus consumeMessage(PullResult pullResult, ConsumeConcurrentlyContext context) {
            TLQListenerContainer.this.handleMessageConcurrently(pullResult);
            return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
        }
    }
}

