/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.springboot.v1.x.data.jdbc;

import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.boot.bind.RelaxedDataBinder;
import org.springframework.boot.jdbc.DatabaseDriver;
import org.springframework.util.ClassUtils;

public class HulkDataSourceBuilder<T extends DataSource> {
    private static final String[] DATA_SOURCE_TYPE_NAMES = new String[]{"com.tongweb.hulk.HulkDataSource", "org.apache.tomcat.jdbc.pool.DataSource", "org.apache.commons.dbcp.BasicDataSource", "org.apache.commons.dbcp2.BasicDataSource"};
    private Class<? extends DataSource> type;
    private ClassLoader classLoader;
    private Map<String, String> properties = new HashMap<String, String>();

    public static HulkDataSourceBuilder create() {
        return new HulkDataSourceBuilder(null);
    }

    public static HulkDataSourceBuilder create(ClassLoader classLoader) {
        return new HulkDataSourceBuilder(classLoader);
    }

    public HulkDataSourceBuilder(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public DataSource build() {
        Class<DataSource> type = this.getType();
        DataSource result = (DataSource)BeanUtils.instantiate(type);
        this.maybeGetDriverClassName();
        this.bind(result);
        return result;
    }

    private void maybeGetDriverClassName() {
        if (!this.properties.containsKey("driverClassName") && this.properties.containsKey("url")) {
            String url = this.properties.get("url");
            String driverClass = DatabaseDriver.fromJdbcUrl((String)url).getDriverClassName();
            this.properties.put("driverClassName", driverClass);
        }
    }

    private void bind(DataSource result) {
        MutablePropertyValues properties = new MutablePropertyValues(this.properties);
        new RelaxedDataBinder((Object)result).withAlias("url", new String[]{"jdbcUrl"}).withAlias("username", new String[]{"user"}).bind((PropertyValues)properties);
    }

    public HulkDataSourceBuilder type(Class<? extends DataSource> type) {
        this.type = type;
        return this;
    }

    public HulkDataSourceBuilder url(String url) {
        this.properties.put("url", url);
        return this;
    }

    public HulkDataSourceBuilder driverClassName(String driverClassName) {
        this.properties.put("driverClassName", driverClassName);
        return this;
    }

    public HulkDataSourceBuilder username(String username) {
        this.properties.put("username", username);
        return this;
    }

    public HulkDataSourceBuilder password(String password) {
        this.properties.put("password", password);
        return this;
    }

    public Class<? extends DataSource> findType() {
        if (this.type != null) {
            return this.type;
        }
        for (String name : DATA_SOURCE_TYPE_NAMES) {
            try {
                return ClassUtils.forName((String)name, (ClassLoader)this.classLoader);
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    private Class<? extends DataSource> getType() {
        Class<DataSource> type = this.findType();
        if (type != null) {
            return type;
        }
        throw new IllegalStateException("No supported DataSource type found");
    }
}

