/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.springboot.v1.x.data.jdbc;

import com.tongweb.hulk.HulkDataSource;
import com.tongweb.springboot.v1.x.data.jdbc.HulkDataSourceBuilder;
import com.tongweb.springboot.v1.x.data.jdbc.HulkDataSourceJmxConfiguration;
import com.tongweb.springboot.v1.x.data.jdbc.HulkDataSourceProperties;
import javax.sql.DataSource;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.jmx.export.MBeanExporter;
import org.springframework.util.StringUtils;

public class TongWebJdbcConfiguration {
    @Bean
    @Primary
    @ConfigurationProperties(value="server.tongweb.datasource")
    public DataSourceProperties dataSourceProperties() {
        return new DataSourceProperties();
    }

    @Bean
    @ConditionalOnProperty(name={"server.tongweb.datasource.type"}, havingValue="com.tongweb.hulk.HulkDataSource")
    @ConfigurationProperties(prefix="server.tongweb.datasource.hulk")
    public HulkDataSourceProperties hulkDataSourceProperties() {
        return new HulkDataSourceProperties();
    }

    @Bean
    @ConditionalOnProperty(name={"server.tongweb.datasource.type"}, havingValue="com.tongweb.hulk.HulkDataSource")
    public HulkDataSource dataSource(DataSourceProperties properties, HulkDataSourceProperties hulkDataSourceProperties) {
        HulkDataSource dataSource = (HulkDataSource)TongWebJdbcConfiguration.createDataSource(properties, HulkDataSource.class);
        this.customHulkConfig(dataSource, hulkDataSourceProperties);
        return dataSource;
    }

    @Bean
    @ConditionalOnProperty(name={"server.tongweb.datasource.type"}, havingValue="com.tongweb.hulk.HulkDataSource")
    public HulkDataSourceJmxConfiguration hulkDataSourceJmxConfiguration(HulkDataSource dataSource, ObjectProvider<MBeanExporter> mBeanExporter) {
        return new HulkDataSourceJmxConfiguration(dataSource, mBeanExporter);
    }

    protected static <T> T createDataSource(DataSourceProperties properties, Class<? extends DataSource> type) {
        return (T)HulkDataSourceBuilder.create(properties.getClassLoader()).driverClassName(properties.determineDriverClassName()).url(properties.determineUrl()).username(properties.determineUsername()).password(properties.determinePassword()).build();
    }

    private void customHulkConfig(HulkDataSource dataSource, HulkDataSourceProperties properties) {
        dataSource.setCommitWhenClose(properties.isCommitWhenClose());
        dataSource.setPrintInitException(properties.isPrintInitException());
        dataSource.setIdle_Timeout(properties.isIdleTimeoutBoolean());
        dataSource.setLogLeak(properties.isLogLeak());
        dataSource.setRemoveAbandoned(properties.isRemoveAbandoned());
        dataSource.setTrackStatement(properties.isTrackStatement());
        dataSource.setCheckConnectionInterval(properties.getCheckConnectionInterval());
        if (!StringUtils.isEmpty((Object)properties.getValidationFileName())) {
            dataSource.setValidationFileName(properties.getValidationFileName());
        }
        if (!StringUtils.isEmpty((Object)properties.getValidationClassName())) {
            dataSource.setValidatorClassName(properties.getValidationClassName());
        }
        dataSource.setTestOnInit(properties.isTestOnInit());
        dataSource.setTestOnBorrow(properties.isTestOnBorrow());
        dataSource.setTestOnReturn(properties.isTestOnReturn());
        dataSource.setTestWhileIdle(properties.isTestWhileIdle());
        dataSource.setTestOnConnect(properties.isTestOnConnect());
        dataSource.setMaxLifetime(properties.getMaxLifetime());
        dataSource.setIdleTimeout(properties.getIdleTimeout());
        dataSource.setConnectionTimeout(properties.getConnectionTimeout());
        dataSource.setValidationTimeout(properties.getValidationTimeout());
        dataSource.setValidationInterval(properties.getValidationInterval());
        if (properties.getMinIdle() >= 0) {
            dataSource.setMinimumIdle(properties.getMinIdle());
        }
        if (properties.getMaxPoolSize() > 1) {
            dataSource.setMaximumPoolSize(properties.getMaxPoolSize());
        }
        if (StringUtils.isEmpty((Object)properties.getRemoveAbandonedTime())) {
            properties.setRemoveAbandonedTime(0L);
        }
        dataSource.setLeakDetectionThreshold(properties.getRemoveAbandonedTime() * 1000L);
        dataSource.setConnectionInitSql(properties.getConnectionInitSql());
        dataSource.setConnectionTestQuery(properties.getConnectionTestQuery());
        dataSource.setStatementQueryTimeout(properties.getStatementQueryTimeout());
        if (!StringUtils.isEmpty((Object)properties.getDataSourceJndiName())) {
            dataSource.setDataSourceJNDI(properties.getDataSourceJndiName());
        }
        if (!StringUtils.isEmpty((Object)properties.getDriverClassName())) {
            dataSource.setDriverClassName(properties.getDriverClassName());
        }
        if (!StringUtils.isEmpty((Object)properties.getJdbcUrl())) {
            dataSource.setJdbcUrl(properties.getJdbcUrl());
        }
        if (!StringUtils.isEmpty((Object)properties.getPassword())) {
            dataSource.setPassword(properties.getPassword());
        }
        if (!StringUtils.isEmpty((Object)properties.getPoolName())) {
            dataSource.setPoolName(properties.getPoolName());
        }
        if (!StringUtils.isEmpty((Object)properties.getUsername())) {
            dataSource.setUsername(properties.getUsername());
        }
        dataSource.setAutoCommit(properties.isAutoCommit());
        dataSource.setLeakCheck(properties.isLeakCheck());
        dataSource.setRegisterMbeans(properties.isRegisterMbeans());
        dataSource.setSqlFileter(properties.isSlowSqlEnabled());
        if (properties.isSlowSqlEnabled() && properties.getSlowSqlFilterTime() >= 0L) {
            dataSource.setSqlFileterTime(properties.getSlowSqlFilterTime());
        }
    }
}

