/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.dependencies;

import com.tongweb.juli.logging.Log;
import com.tongweb.juli.logging.LogFactory;
import com.tongweb.util.ActionLogMsg;
import com.tongweb.web.util.res.StringManager;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
public class WebSocketMissWaringConfiguration {
    private static final Log log = LogFactory.getLog(WebSocketMissWaringConfiguration.class);
    private static final StringManager sm = StringManager.getManager((String)"com.tongweb.dependencies");
    private static AtomicBoolean isWaringFlag = new AtomicBoolean(false);

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(name={"org.springframework.web.socket.WebSocketHandler", "com.tongweb.container.startup.ServletContainer"})
    @ConditionalOnMissingClass(value={"com.tongweb.web.websocket.WsWebSocketContainer"})
    protected static class WebSocketHandlerMissingClasspathConfiguration {
        public WebSocketHandlerMissingClasspathConfiguration() {
            if (!isWaringFlag.getAndSet(true)) {
                log.warn((Object)ActionLogMsg.infoMissing(sm.getString("tongweb.websocket.miss.message"), sm.getString("tongweb.websocket.miss.consider")));
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(name={"javax.websocket.server.ServerEndpoint", "com.tongweb.container.startup.ServletContainer"})
    @ConditionalOnMissingClass(value={"com.tongweb.web.websocket.WsWebSocketContainer"})
    protected static class WebSocketMissingFromClasspathConfiguration {
        public WebSocketMissingFromClasspathConfiguration() {
            if (!isWaringFlag.getAndSet(true)) {
                log.warn((Object)ActionLogMsg.infoMissing(sm.getString("tongweb.websocket.miss.message"), sm.getString("tongweb.websocket.miss.consider")));
            }
        }
    }
}

