/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.NameResolver;
import com.unboundid.util.Debug;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadLocalRandom;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class CachingNameResolver
extends NameResolver {
    private static final int DEFAULT_TIMEOUT_MILLIS = 3600000;
    private final AtomicReference<ObjectPair<Long, InetAddress>> localHostAddress;
    private final AtomicReference<ObjectPair<Long, InetAddress>> loopbackAddress;
    private final Map<InetAddress, ObjectPair<Long, String>> addressToNameMap;
    private final Map<String, ObjectPair<Long, InetAddress[]>> nameToAddressMap;
    private final long timeoutMillis;

    public CachingNameResolver() {
        this(3600000);
    }

    public CachingNameResolver(int timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
        this.localHostAddress = new AtomicReference();
        this.loopbackAddress = new AtomicReference();
        this.addressToNameMap = new ConcurrentHashMap<InetAddress, ObjectPair<Long, String>>(20);
        this.nameToAddressMap = new ConcurrentHashMap<String, ObjectPair<Long, InetAddress[]>>(20);
    }

    public int getTimeoutMillis() {
        return (int)this.timeoutMillis;
    }

    @Override
    public InetAddress getByName(String host) throws UnknownHostException, SecurityException {
        InetAddress[] addresses = this.getAllByNameInternal(host);
        if (addresses.length == 1) {
            return addresses[0];
        }
        return addresses[ThreadLocalRandom.get().nextInt(addresses.length)];
    }

    @Override
    public InetAddress[] getAllByName(String host) throws UnknownHostException, SecurityException {
        InetAddress[] addresses = this.getAllByNameInternal(host);
        return Arrays.copyOf(addresses, addresses.length);
    }

    public InetAddress[] getAllByNameInternal(String host) throws UnknownHostException, SecurityException {
        String lowerHost = host == null ? "" : StaticUtils.toLowerCase(host);
        ObjectPair<Long, InetAddress[]> cachedRecord = this.nameToAddressMap.get(lowerHost);
        if (cachedRecord == null) {
            return this.lookUpAndCache(host, lowerHost);
        }
        if (System.currentTimeMillis() <= cachedRecord.getFirst()) {
            return cachedRecord.getSecond();
        }
        try {
            return this.lookUpAndCache(host, lowerHost);
        }
        catch (Exception e) {
            Debug.debugException(e);
            return cachedRecord.getSecond();
        }
    }

    private InetAddress[] lookUpAndCache(String host, String lowerHost) throws UnknownHostException, SecurityException {
        InetAddress[] addresses = InetAddress.getAllByName(host);
        long cacheRecordExpirationTime = System.currentTimeMillis() + this.timeoutMillis;
        ObjectPair<Long, InetAddress[]> cacheRecord = new ObjectPair<Long, InetAddress[]>(cacheRecordExpirationTime, addresses);
        this.nameToAddressMap.put(lowerHost, cacheRecord);
        return addresses;
    }

    @Override
    public String getHostName(InetAddress inetAddress) {
        String stringRepresentation = String.valueOf(inetAddress);
        int lastSlashPos = stringRepresentation.lastIndexOf(47);
        if (lastSlashPos > 0) {
            return stringRepresentation.substring(0, lastSlashPos);
        }
        return this.getCanonicalHostName(inetAddress);
    }

    @Override
    public String getCanonicalHostName(InetAddress inetAddress) {
        ObjectPair<Long, String> cachedRecord = this.addressToNameMap.get(inetAddress);
        if (cachedRecord == null) {
            return this.lookUpAndCache(inetAddress, null);
        }
        if (System.currentTimeMillis() <= cachedRecord.getFirst()) {
            return cachedRecord.getSecond();
        }
        return this.lookUpAndCache(inetAddress, cachedRecord.getSecond());
    }

    private String lookUpAndCache(InetAddress inetAddress, String cachedName) {
        String canonicalHostName = inetAddress.getCanonicalHostName();
        if (canonicalHostName.equals(inetAddress.getHostAddress())) {
            if (cachedName == null) {
                return canonicalHostName;
            }
            return cachedName;
        }
        long cacheRecordExpirationTime = System.currentTimeMillis() + this.timeoutMillis;
        ObjectPair<Long, String> cacheRecord = new ObjectPair<Long, String>(cacheRecordExpirationTime, canonicalHostName);
        this.addressToNameMap.put(inetAddress, cacheRecord);
        return canonicalHostName;
    }

    @Override
    public InetAddress getLocalHost() throws UnknownHostException, SecurityException {
        ObjectPair<Long, InetAddress> cachedAddress = this.localHostAddress.get();
        if (cachedAddress == null) {
            InetAddress localHost = InetAddress.getLocalHost();
            long expirationTime = System.currentTimeMillis() + this.timeoutMillis;
            this.localHostAddress.set(new ObjectPair<Long, InetAddress>(expirationTime, localHost));
            return localHost;
        }
        long cachedRecordExpirationTime = cachedAddress.getFirst();
        if (System.currentTimeMillis() <= cachedRecordExpirationTime) {
            return cachedAddress.getSecond();
        }
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            long expirationTime = System.currentTimeMillis() + this.timeoutMillis;
            this.localHostAddress.set(new ObjectPair<Long, InetAddress>(expirationTime, localHost));
            return localHost;
        }
        catch (Exception e) {
            Debug.debugException(e);
            return cachedAddress.getSecond();
        }
    }

    @Override
    public InetAddress getLoopbackAddress() {
        ObjectPair<Long, InetAddress> cachedAddress = this.loopbackAddress.get();
        if (cachedAddress == null) {
            InetAddress address = InetAddress.getLoopbackAddress();
            long expirationTime = System.currentTimeMillis() + this.timeoutMillis;
            this.loopbackAddress.set(new ObjectPair<Long, InetAddress>(expirationTime, address));
            return address;
        }
        long cachedRecordExpirationTime = cachedAddress.getFirst();
        if (System.currentTimeMillis() <= cachedRecordExpirationTime) {
            return cachedAddress.getSecond();
        }
        try {
            InetAddress address = InetAddress.getLoopbackAddress();
            long expirationTime = System.currentTimeMillis() + this.timeoutMillis;
            this.loopbackAddress.set(new ObjectPair<Long, InetAddress>(expirationTime, address));
            return address;
        }
        catch (Exception e) {
            Debug.debugException(e);
            return cachedAddress.getSecond();
        }
    }

    public void clearCache() {
        this.localHostAddress.set(null);
        this.loopbackAddress.set(null);
        this.addressToNameMap.clear();
        this.nameToAddressMap.clear();
    }

    Map<InetAddress, ObjectPair<Long, String>> getAddressToNameMap() {
        return this.addressToNameMap;
    }

    Map<String, ObjectPair<Long, InetAddress[]>> getNameToAddressMap() {
        return this.nameToAddressMap;
    }

    AtomicReference<ObjectPair<Long, InetAddress>> getLocalHostAddressReference() {
        return this.localHostAddress;
    }

    AtomicReference<ObjectPair<Long, InetAddress>> getLoopbackAddressReference() {
        return this.loopbackAddress;
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("CachingNameResolver(timeoutMillis=");
        buffer.append(this.timeoutMillis);
        buffer.append(')');
    }
}

