/*
 * Decompiled with CFR 0.152.
 */
package com.unfbx.chatgpt;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.ContentType;
import cn.hutool.http.Header;
import cn.hutool.json.JSONUtil;
import com.unfbx.chatgpt.OpenAiApi;
import com.unfbx.chatgpt.entity.billing.CreditGrantsResponse;
import com.unfbx.chatgpt.entity.chat.ChatCompletion;
import com.unfbx.chatgpt.entity.chat.ChatCompletionResponse;
import com.unfbx.chatgpt.entity.chat.Message;
import com.unfbx.chatgpt.entity.common.DeleteResponse;
import com.unfbx.chatgpt.entity.common.OpenAiResponse;
import com.unfbx.chatgpt.entity.completions.Completion;
import com.unfbx.chatgpt.entity.completions.CompletionResponse;
import com.unfbx.chatgpt.entity.edits.Edit;
import com.unfbx.chatgpt.entity.edits.EditResponse;
import com.unfbx.chatgpt.entity.embeddings.Embedding;
import com.unfbx.chatgpt.entity.embeddings.EmbeddingResponse;
import com.unfbx.chatgpt.entity.engines.Engine;
import com.unfbx.chatgpt.entity.files.File;
import com.unfbx.chatgpt.entity.files.UploadFileResponse;
import com.unfbx.chatgpt.entity.fineTune.Event;
import com.unfbx.chatgpt.entity.fineTune.FineTune;
import com.unfbx.chatgpt.entity.fineTune.FineTuneResponse;
import com.unfbx.chatgpt.entity.images.Image;
import com.unfbx.chatgpt.entity.images.ImageEdit;
import com.unfbx.chatgpt.entity.images.ImageResponse;
import com.unfbx.chatgpt.entity.images.ImageVariations;
import com.unfbx.chatgpt.entity.images.Item;
import com.unfbx.chatgpt.entity.models.Model;
import com.unfbx.chatgpt.entity.models.ModelResponse;
import com.unfbx.chatgpt.entity.moderations.Moderation;
import com.unfbx.chatgpt.entity.moderations.ModerationResponse;
import com.unfbx.chatgpt.entity.whisper.Whisper;
import com.unfbx.chatgpt.entity.whisper.WhisperResponse;
import com.unfbx.chatgpt.exception.BaseException;
import com.unfbx.chatgpt.exception.CommonError;
import io.reactivex.Single;
import java.net.Proxy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class OpenAiClient {
    private static final Logger log = LoggerFactory.getLogger(OpenAiClient.class);
    @NotNull
    private String apiKey;
    private String apiHost = "https://api.openai.com/";
    private OpenAiApi openAiApi;
    private OkHttpClient okHttpClient;
    private long connectTimeout;
    private long writeTimeout;
    private long readTimeout;
    private Proxy proxy;
    private List<Interceptor> interceptor;

    public OpenAiClient(String apiKey, long connectTimeout, long writeTimeout, long readTimeout, Proxy proxy, Interceptor ... interceptor) {
        this.apiKey = apiKey;
        this.okHttpClient = this.okHttpClient(connectTimeout, writeTimeout, readTimeout, proxy, interceptor);
        this.openAiApi = (OpenAiApi)new Retrofit.Builder().baseUrl(this.apiHost).client(this.okHttpClient).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create()).build().create(OpenAiApi.class);
    }

    public OpenAiClient(String apiKey) {
        this.apiKey = apiKey;
        this.okHttpClient = this.okHttpClient(30L, 30L, 30L, null, null);
        this.openAiApi = (OpenAiApi)new Retrofit.Builder().baseUrl(this.apiHost).client(this.okHttpClient).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create()).build().create(OpenAiApi.class);
    }

    public OpenAiClient(String apiKey, Proxy proxy) {
        this.apiKey = apiKey;
        this.okHttpClient = this.okHttpClient(30L, 30L, 30L, proxy, null);
        this.openAiApi = (OpenAiApi)new Retrofit.Builder().baseUrl(this.apiHost).client(this.okHttpClient).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create()).build().create(OpenAiApi.class);
    }

    public OpenAiClient(String apiKey, long connectTimeout, long writeTimeout, long readTimeout, Proxy proxy) {
        this.apiKey = apiKey;
        this.okHttpClient = this.okHttpClient(connectTimeout, writeTimeout, readTimeout, proxy, null);
        this.openAiApi = (OpenAiApi)new Retrofit.Builder().baseUrl(this.apiHost).client(this.okHttpClient).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create()).build().create(OpenAiApi.class);
    }

    public OpenAiClient(String apiKey, Proxy proxy, Interceptor ... interceptor) {
        this.apiKey = apiKey;
        this.okHttpClient = this.okHttpClient(30L, 30L, 30L, proxy, interceptor);
        this.openAiApi = (OpenAiApi)new Retrofit.Builder().baseUrl(this.apiHost).client(this.okHttpClient).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create()).build().create(OpenAiApi.class);
    }

    public static Builder builder() {
        return new Builder();
    }

    private OpenAiClient(Builder builder) {
        if (StrUtil.isBlank((CharSequence)builder.apiKey)) {
            throw new BaseException(CommonError.API_KEYS_NOT_NUL);
        }
        this.apiKey = builder.apiKey;
        if (StrUtil.isBlank((CharSequence)builder.apiHost)) {
            builder.apiHost = "https://api.openai.com/";
        }
        this.apiHost = builder.apiHost;
        if (Objects.isNull(builder.connectTimeout)) {
            builder.connectTimeout(30L);
        }
        this.connectTimeout = builder.connectTimeout;
        if (Objects.isNull(builder.writeTimeout)) {
            builder.writeTimeout(30L);
        }
        this.writeTimeout = builder.writeTimeout;
        if (Objects.isNull(builder.readTimeout)) {
            builder.readTimeout(30L);
        }
        this.readTimeout = builder.readTimeout;
        this.proxy = builder.proxy;
        this.interceptor = builder.interceptor;
        Interceptor[] interceptorArray = null;
        if (Objects.nonNull(this.interceptor) && this.interceptor.size() > 0) {
            interceptorArray = (Interceptor[])this.interceptor.stream().toArray(Interceptor[]::new);
        }
        this.okHttpClient = this.okHttpClient(this.connectTimeout, this.writeTimeout, this.readTimeout, this.proxy, interceptorArray);
        this.openAiApi = (OpenAiApi)new Retrofit.Builder().baseUrl(this.apiHost).client(this.okHttpClient).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create()).build().create(OpenAiApi.class);
    }

    private OkHttpClient okHttpClient(long connectTimeout, long writeTimeout, long readTimeout, Proxy proxy, Interceptor ... interceptor) {
        OkHttpClient.Builder client = new OkHttpClient.Builder();
        client.addInterceptor(chain -> {
            Request original = chain.request();
            Request request = original.newBuilder().header(Header.AUTHORIZATION.getValue(), "Bearer " + this.apiKey).header(Header.CONTENT_TYPE.getValue(), ContentType.JSON.getValue()).method(original.method(), original.body()).build();
            return chain.proceed(request);
        }).addInterceptor(chain -> {
            Request original = chain.request();
            Response response = chain.proceed(original);
            if (!response.isSuccessful()) {
                if (response.code() == CommonError.OPENAI_AUTHENTICATION_ERROR.code() || response.code() == CommonError.OPENAI_LIMIT_ERROR.code() || response.code() == CommonError.OPENAI_SERVER_ERROR.code()) {
                    OpenAiResponse openAiResponse = (OpenAiResponse)JSONUtil.toBean((String)response.body().string(), OpenAiResponse.class);
                    log.error(openAiResponse.getError().getMessage());
                    throw new BaseException(openAiResponse.getError().getMessage());
                }
                String errorMsg = response.body().string();
                log.error("\u8bf7\u6c42\u5f02\u5e38\uff1a{}", (Object)errorMsg);
                OpenAiResponse openAiResponse = (OpenAiResponse)JSONUtil.toBean((String)errorMsg, OpenAiResponse.class);
                if (Objects.nonNull(openAiResponse.getError())) {
                    log.error(openAiResponse.getError().getMessage());
                    throw new BaseException(openAiResponse.getError().getMessage());
                }
                throw new BaseException(CommonError.RETRY_ERROR);
            }
            return response;
        });
        if (Objects.nonNull(interceptor) && interceptor.length > 0) {
            Arrays.stream(interceptor).forEach(e -> client.addInterceptor(e));
        }
        client.connectTimeout(connectTimeout, TimeUnit.SECONDS);
        client.writeTimeout(writeTimeout, TimeUnit.SECONDS);
        client.readTimeout(readTimeout, TimeUnit.SECONDS);
        if (Objects.nonNull(proxy)) {
            client.proxy(proxy);
        }
        OkHttpClient httpClient = client.build();
        return httpClient;
    }

    public List<Model> models() {
        Single<ModelResponse> models = this.openAiApi.models();
        List<Model> modelList = ((ModelResponse)models.blockingGet()).getData();
        return modelList;
    }

    public Model model(String id) {
        if (Objects.isNull(id) || "".equals(id)) {
            throw new BaseException(CommonError.PARAM_ERROR);
        }
        Single<Model> model = this.openAiApi.model(id);
        return (Model)model.blockingGet();
    }

    public CompletionResponse completions(Completion completion) {
        Single<CompletionResponse> completions = this.openAiApi.completions(completion);
        return (CompletionResponse)completions.blockingGet();
    }

    public CompletionResponse completions(String question) {
        Completion q = Completion.builder().prompt(question).build();
        Single<CompletionResponse> completions = this.openAiApi.completions(q);
        return (CompletionResponse)completions.blockingGet();
    }

    public EditResponse edit(Edit edit) {
        Single<EditResponse> edits = this.openAiApi.edits(edit);
        return (EditResponse)edits.blockingGet();
    }

    public ImageResponse genImages(String prompt) {
        Image image = Image.builder().prompt(prompt).build();
        return this.genImages(image);
    }

    public ImageResponse genImages(Image image) {
        Single<ImageResponse> edits = this.openAiApi.genImages(image);
        return (ImageResponse)edits.blockingGet();
    }

    public List<Item> editImages(java.io.File image, String prompt) {
        ImageEdit imageEdit = ImageEdit.builder().prompt(prompt).build();
        return this.editImages(image, null, imageEdit);
    }

    public List<Item> editImages(java.io.File image, ImageEdit imageEdit) {
        return this.editImages(image, null, imageEdit);
    }

    public List<Item> editImages(java.io.File image, java.io.File mask, ImageEdit imageEdit) {
        this.checkImage(image);
        this.checkImageFormat(image);
        this.checkImageSize(image);
        if (Objects.nonNull(mask)) {
            this.checkImageFormat(image);
            this.checkImageSize(image);
        }
        RequestBody imageBody = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (java.io.File)image);
        MultipartBody.Part imageMultipartBody = MultipartBody.Part.createFormData((String)"image", (String)image.getName(), (RequestBody)imageBody);
        MultipartBody.Part maskMultipartBody = null;
        if (Objects.nonNull(mask)) {
            RequestBody maskBody = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (java.io.File)mask);
            maskMultipartBody = MultipartBody.Part.createFormData((String)"mask", (String)image.getName(), (RequestBody)maskBody);
        }
        HashMap<String, RequestBody> requestBodyMap = new HashMap<String, RequestBody>();
        requestBodyMap.put("prompt", RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)imageEdit.getPrompt()));
        requestBodyMap.put("n", RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)imageEdit.getN().toString()));
        requestBodyMap.put("size", RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)imageEdit.getSize()));
        requestBodyMap.put("response_format", RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)imageEdit.getResponseFormat()));
        if (!Objects.isNull(imageEdit.getUser()) && !"".equals(imageEdit.getUser())) {
            requestBodyMap.put("user", RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)imageEdit.getUser()));
        }
        Single<ImageResponse> imageResponse = this.openAiApi.editImages(imageMultipartBody, maskMultipartBody, requestBodyMap);
        return ((ImageResponse)imageResponse.blockingGet()).getData();
    }

    public ImageResponse variationsImages(java.io.File image, ImageVariations imageVariations) {
        this.checkImage(image);
        this.checkImageFormat(image);
        this.checkImageSize(image);
        RequestBody imageBody = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (java.io.File)image);
        MultipartBody.Part multipartBody = MultipartBody.Part.createFormData((String)"image", (String)image.getName(), (RequestBody)imageBody);
        HashMap<String, RequestBody> requestBodyMap = new HashMap<String, RequestBody>();
        requestBodyMap.put("n", RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)imageVariations.getN().toString()));
        requestBodyMap.put("size", RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)imageVariations.getSize()));
        requestBodyMap.put("response_format", RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)imageVariations.getResponseFormat()));
        if (!Objects.isNull(imageVariations.getUser()) && !"".equals(imageVariations.getUser())) {
            requestBodyMap.put("user", RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)imageVariations.getUser()));
        }
        Single<ImageResponse> variationsImages = this.openAiApi.variationsImages(multipartBody, requestBodyMap);
        return (ImageResponse)variationsImages.blockingGet();
    }

    public ImageResponse variationsImages(java.io.File image) {
        this.checkImage(image);
        this.checkImageFormat(image);
        this.checkImageSize(image);
        ImageVariations imageVariations = ImageVariations.builder().build();
        return this.variationsImages(image, imageVariations);
    }

    private void checkImage(java.io.File image) {
        if (Objects.isNull(image)) {
            log.error("image\u4e0d\u80fd\u4e3a\u7a7a");
            throw new BaseException(CommonError.PARAM_ERROR);
        }
    }

    private void checkImageFormat(java.io.File image) {
        if (!image.getName().endsWith("png") && !image.getName().endsWith("PNG")) {
            log.error("image\u683c\u5f0f\u9519\u8bef");
            throw new BaseException(CommonError.PARAM_ERROR);
        }
    }

    private void checkImageSize(java.io.File image) {
        if (image.length() > 0x400000L) {
            log.error("image\u6700\u5927\u652f\u63014MB");
            throw new BaseException(CommonError.PARAM_ERROR);
        }
    }

    public EmbeddingResponse embeddings(String input) {
        Embedding embedding = Embedding.builder().input(input).build();
        return this.embeddings(embedding);
    }

    public EmbeddingResponse embeddings(Embedding embedding) {
        Single<EmbeddingResponse> embeddings = this.openAiApi.embeddings(embedding);
        return (EmbeddingResponse)embeddings.blockingGet();
    }

    public List<File> files() {
        Single<OpenAiResponse<File>> files = this.openAiApi.files();
        return ((OpenAiResponse)files.blockingGet()).getData();
    }

    public DeleteResponse deleteFile(String fileId) {
        Single<DeleteResponse> deleteFile = this.openAiApi.deleteFile(fileId);
        return (DeleteResponse)deleteFile.blockingGet();
    }

    public UploadFileResponse uploadFile(String purpose, java.io.File file) {
        RequestBody fileBody = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (java.io.File)file);
        MultipartBody.Part multipartBody = MultipartBody.Part.createFormData((String)"file", (String)file.getName(), (RequestBody)fileBody);
        RequestBody purposeBody = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)purpose);
        Single<UploadFileResponse> uploadFileResponse = this.openAiApi.uploadFile(multipartBody, purposeBody);
        return (UploadFileResponse)uploadFileResponse.blockingGet();
    }

    public UploadFileResponse uploadFile(java.io.File file) {
        return this.uploadFile("fine-tune", file);
    }

    public File retrieveFile(String fileId) {
        Single<File> fileContent = this.openAiApi.retrieveFile(fileId);
        return (File)fileContent.blockingGet();
    }

    public ModerationResponse moderations(String input) {
        Moderation moderation = Moderation.builder().input(input).build();
        return this.moderations(moderation);
    }

    public ModerationResponse moderations(Moderation moderation) {
        Single<ModerationResponse> moderations = this.openAiApi.moderations(moderation);
        return (ModerationResponse)moderations.blockingGet();
    }

    public FineTuneResponse fineTune(FineTune fineTune) {
        Single<FineTuneResponse> fineTuneResponse = this.openAiApi.fineTune(fineTune);
        return (FineTuneResponse)fineTuneResponse.blockingGet();
    }

    public FineTuneResponse fineTune(String trainingFileId) {
        FineTune fineTune = FineTune.builder().trainingFile(trainingFileId).build();
        return this.fineTune(fineTune);
    }

    public List<FineTuneResponse> fineTunes() {
        Single<OpenAiResponse<FineTuneResponse>> fineTunes = this.openAiApi.fineTunes();
        return ((OpenAiResponse)fineTunes.blockingGet()).getData();
    }

    public FineTuneResponse retrieveFineTune(String fineTuneId) {
        Single<FineTuneResponse> fineTune = this.openAiApi.retrieveFineTune(fineTuneId);
        return (FineTuneResponse)fineTune.blockingGet();
    }

    public FineTuneResponse cancelFineTune(String fineTuneId) {
        Single<FineTuneResponse> fineTune = this.openAiApi.cancelFineTune(fineTuneId);
        return (FineTuneResponse)fineTune.blockingGet();
    }

    public List<Event> fineTuneEvents(String fineTuneId) {
        Single<OpenAiResponse<Event>> events = this.openAiApi.fineTuneEvents(fineTuneId);
        return ((OpenAiResponse)events.blockingGet()).getData();
    }

    public DeleteResponse deleteFineTuneModel(String model) {
        Single<DeleteResponse> delete = this.openAiApi.deleteFineTuneModel(model);
        return (DeleteResponse)delete.blockingGet();
    }

    @Deprecated
    public List<Engine> engines() {
        Single<OpenAiResponse<Engine>> engines = this.openAiApi.engines();
        return ((OpenAiResponse)engines.blockingGet()).getData();
    }

    @Deprecated
    public Engine engine(String engineId) {
        Single<Engine> engine = this.openAiApi.engine(engineId);
        return (Engine)engine.blockingGet();
    }

    public ChatCompletionResponse chatCompletion(ChatCompletion chatCompletion) {
        Single<ChatCompletionResponse> chatCompletionResponse = this.openAiApi.chatCompletion(chatCompletion);
        return (ChatCompletionResponse)chatCompletionResponse.blockingGet();
    }

    public ChatCompletionResponse chatCompletion(List<Message> messages) {
        ChatCompletion chatCompletion = ChatCompletion.builder().messages(messages).build();
        return this.chatCompletion(chatCompletion);
    }

    public WhisperResponse speechToTextTranscriptions(java.io.File file, Whisper.Model model) {
        this.checkSpeechFileSize(file);
        RequestBody fileBody = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (java.io.File)file);
        MultipartBody.Part multipartBody = MultipartBody.Part.createFormData((String)"file", (String)file.getName(), (RequestBody)fileBody);
        RequestBody modelBody = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)model.getName());
        Single<WhisperResponse> whisperResponse = this.openAiApi.speechToTextTranscriptions(multipartBody, modelBody);
        return (WhisperResponse)whisperResponse.blockingGet();
    }

    public WhisperResponse speechToTextTranscriptions(java.io.File file) {
        return this.speechToTextTranscriptions(file, Whisper.Model.WHISPER_1);
    }

    public WhisperResponse speechToTextTranslations(java.io.File file, Whisper.Model model) {
        this.checkSpeechFileSize(file);
        RequestBody fileBody = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (java.io.File)file);
        MultipartBody.Part multipartBody = MultipartBody.Part.createFormData((String)"file", (String)file.getName(), (RequestBody)fileBody);
        RequestBody modelBody = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)model.getName());
        Single<WhisperResponse> whisperResponse = this.openAiApi.speechToTextTranslations(multipartBody, modelBody);
        return (WhisperResponse)whisperResponse.blockingGet();
    }

    public WhisperResponse speechToTextTranslations(java.io.File file) {
        return this.speechToTextTranslations(file, Whisper.Model.WHISPER_1);
    }

    private void checkSpeechFileSize(java.io.File file) {
        if (file.length() > 30822400L) {
            log.warn("2023-03-02\u5b98\u65b9\u6587\u6863\u63d0\u793a\uff1a\u6587\u4ef6\u4e0d\u80fd\u8d85\u51fa25MB");
        }
    }

    public CreditGrantsResponse creditGrants() {
        Single<CreditGrantsResponse> creditGrants = this.openAiApi.creditGrants();
        return (CreditGrantsResponse)creditGrants.blockingGet();
    }

    @NotNull
    public String getApiKey() {
        String string = this.apiKey;
        if (string == null) {
            OpenAiClient.$$$reportNull$$$0(0);
        }
        return string;
    }

    public String getApiHost() {
        return this.apiHost;
    }

    public OpenAiApi getOpenAiApi() {
        return this.openAiApi;
    }

    public OkHttpClient getOkHttpClient() {
        return this.okHttpClient;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public long getWriteTimeout() {
        return this.writeTimeout;
    }

    public long getReadTimeout() {
        return this.readTimeout;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public List<Interceptor> getInterceptor() {
        return this.interceptor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/unfbx/chatgpt/OpenAiClient", "getApiKey"));
    }

    public static final class Builder {
        @NotNull
        private String apiKey;
        private String apiHost;
        private Long connectTimeout;
        private Long writeTimeout;
        private Long readTimeout;
        private Proxy proxy;
        private List<Interceptor> interceptor;

        public Builder apiHost(String val) {
            this.apiHost = val;
            return this;
        }

        public Builder apiKey(@NotNull String val) {
            if (val == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.apiKey = val;
            return this;
        }

        public Builder connectTimeout(long val) {
            this.connectTimeout = val;
            return this;
        }

        public Builder writeTimeout(long val) {
            this.writeTimeout = val;
            return this;
        }

        public Builder readTimeout(long val) {
            this.readTimeout = val;
            return this;
        }

        public Builder proxy(Proxy val) {
            this.proxy = val;
            return this;
        }

        public Builder interceptor(List<Interceptor> val) {
            this.interceptor = val;
            return this;
        }

        public OpenAiClient build() {
            return new OpenAiClient(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "val", "com/unfbx/chatgpt/OpenAiClient$Builder", "apiKey"));
        }
    }
}

