/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.function.SerializableComparator;
import com.vaadin.flow.function.SerializablePredicate;
import java.util.Optional;

public final class DataViewUtils {
    private static final String COMPONENT_IN_MEMORY_FILTER_KEY = "component-in-memory-filter-key";
    private static final String COMPONENT_IN_MEMORY_SORTING_KEY = "component-in-memory-sorting-key";

    private DataViewUtils() {
    }

    public static <T> Optional<SerializablePredicate<T>> getComponentFilter(Component component) {
        return Optional.ofNullable((SerializablePredicate)ComponentUtil.getData((Component)component, (String)COMPONENT_IN_MEMORY_FILTER_KEY));
    }

    public static <T> Optional<SerializableComparator<T>> getComponentSortComparator(Component component) {
        return Optional.ofNullable((SerializableComparator)ComponentUtil.getData((Component)component, (String)COMPONENT_IN_MEMORY_SORTING_KEY));
    }

    public static <T> void setComponentFilter(Component component, SerializablePredicate<T> filter) {
        ComponentUtil.setData((Component)component, (String)COMPONENT_IN_MEMORY_FILTER_KEY, filter);
    }

    public static <T> void setComponentSortComparator(Component component, SerializableComparator<T> sortComparator) {
        ComponentUtil.setData((Component)component, (String)COMPONENT_IN_MEMORY_SORTING_KEY, sortComparator);
    }

    public static void removeComponentFilterAndSortComparator(Component component) {
        DataViewUtils.setComponentFilter(component, null);
        DataViewUtils.setComponentSortComparator(component, null);
    }

    public static Query getQuery(Component component) {
        return DataViewUtils.getQuery(component, true);
    }

    public static Query getQuery(Component component, boolean withSorting) {
        Optional<SerializablePredicate<Object>> filter = DataViewUtils.getComponentFilter(component);
        Optional<Object> sorting = withSorting ? DataViewUtils.getComponentSortComparator(component) : Optional.empty();
        return new Query(0, Integer.MAX_VALUE, null, sorting.orElse(null), filter.orElse(null));
    }
}

