/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider.hierarchy;

import com.vaadin.flow.data.provider.hierarchy.HierarchicalDataProvider;
import com.vaadin.flow.data.provider.hierarchy.TreeData;
import com.vaadin.flow.data.provider.hierarchy.TreeDataProvider;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Stream;

public interface HasHierarchicalDataProvider<T>
extends Serializable {
    public HierarchicalDataProvider<T, SerializablePredicate<T>> getDataProvider();

    default public void setTreeData(TreeData<T> treeData) {
        this.setDataProvider(new TreeDataProvider<T>(treeData));
    }

    default public TreeData<T> getTreeData() {
        if (this.getDataProvider() instanceof TreeDataProvider) {
            return ((TreeDataProvider)this.getDataProvider()).getTreeData();
        }
        throw new IllegalStateException("Data provider is not an instance of TreeDataProvider");
    }

    default public void setItems(Collection<T> rootItems, ValueProvider<T, Collection<T>> childItemProvider) {
        Objects.requireNonNull(rootItems, "Given root items may not be null");
        Objects.requireNonNull(childItemProvider, "Given child item provider may not be null");
        this.setDataProvider(new TreeDataProvider(new TreeData<T>().addItems(rootItems, childItemProvider)));
    }

    default public void setItems(Stream<T> rootItems, ValueProvider<T, Stream<T>> childItemProvider) {
        Objects.requireNonNull(rootItems, "Given root items may not be null");
        Objects.requireNonNull(childItemProvider, "Given child item provider may not be null");
        this.setDataProvider(new TreeDataProvider(new TreeData<T>().addItems(rootItems, childItemProvider)));
    }

    public void setDataProvider(HierarchicalDataProvider<T, ?> var1);
}

