/*
 * Decompiled with CFR 0.152.
 */
package com.vackosar.gitflowincrementalbuild.control.jgit;

import com.jcraft.jsch.Identity;
import com.jcraft.jsch.IdentityRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.agentproxy.AgentProxyException;
import com.jcraft.jsch.agentproxy.Connector;
import com.jcraft.jsch.agentproxy.ConnectorFactory;
import com.jcraft.jsch.agentproxy.RemoteIdentityRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.util.FS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentProxyAwareJschConfigSessionFactory
extends JschConfigSessionFactory {
    private Logger logger = LoggerFactory.getLogger(AgentProxyAwareJschConfigSessionFactory.class);

    protected void configure(OpenSshConfig.Host hc, Session session) {
    }

    protected Session createSession(OpenSshConfig.Host hc, String user, String host, int port, FS fs) throws JSchException {
        JSch jSch = this.getJSch(hc, fs);
        Collection<Identity> allUnencryptedIdentities = this.getIdentitiesFromAgentProxy();
        Vector identities = jSch.getIdentityRepository().getIdentities();
        identities.stream().filter(id -> !id.isEncrypted()).forEach(allUnencryptedIdentities::add);
        Session session = jSch.getSession(user, host, port);
        session.setIdentityRepository((IdentityRepository)new ReadOnlyIdentityRepository(allUnencryptedIdentities));
        return session;
    }

    private Collection<Identity> getIdentitiesFromAgentProxy() {
        Connector con = null;
        try {
            con = ConnectorFactory.getDefault().createConnector();
        }
        catch (AgentProxyException e) {
            this.logger.warn("AgentProxy setup failed, cannot read identities from agent", (Throwable)e);
        }
        return con != null ? new RemoteIdentityRepository(con).getIdentities() : new ArrayList<Identity>();
    }

    private static class ReadOnlyIdentityRepository
    implements IdentityRepository {
        private final Collection<Identity> allUnencryptedIdentities;

        private ReadOnlyIdentityRepository(Collection<Identity> allUnencryptedIdentities) {
            this.allUnencryptedIdentities = allUnencryptedIdentities;
        }

        public void removeAll() {
        }

        public boolean remove(byte[] blob) {
            return false;
        }

        public int getStatus() {
            return 2;
        }

        public String getName() {
            return this.getClass().getName();
        }

        public Vector<Identity> getIdentities() {
            return new Vector<Identity>(this.allUnencryptedIdentities);
        }

        public boolean add(byte[] identity) {
            return false;
        }
    }
}

