/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dsi.dataengine.filters;

import com.vertica.dsi.dataengine.filters.IFilter;
import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.vertica.dsi.exceptions.IncorrectTypeException;

public class SmallIntFilter
implements IFilter {
    private MetadataSourceColumnTag m_columnTag;
    private Integer m_value = null;

    public SmallIntFilter(MetadataSourceColumnTag columnTag, String value) {
        this.m_columnTag = columnTag;
        if (null != value) {
            this.m_value = Integer.valueOf(value.toString());
        }
    }

    @Override
    public boolean filter(DataWrapper data) {
        if (null == this.m_value) {
            return true;
        }
        try {
            if (MetadataSourceColumnTag.SCOPE == this.m_columnTag) {
                if (data.isNull()) {
                    return true;
                }
                return this.m_value <= data.getSmallInt();
            }
            return this.m_value.equals(data.getSmallInt());
        }
        catch (IncorrectTypeException incorrectTypeException) {
            assert (false);
            return false;
        }
    }

    @Override
    public MetadataSourceColumnTag getColumnTag() {
        return this.m_columnTag;
    }
}

