/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dsi.utilities;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class CalendarSetter {
    public static Date getDate(Date date, Calendar cal) {
        if (null == date) {
            return null;
        }
        long convertedMillis = 0L;
        if (null == cal) {
            cal = Calendar.getInstance();
            convertedMillis = date.getTime();
        } else {
            convertedMillis = CalendarSetter.convertTimeMillis(date.getTime(), cal, Calendar.getInstance());
        }
        cal.clear();
        cal.setTimeInMillis(convertedMillis);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return new Date(cal.getTimeInMillis());
    }

    public static Time getTime(Time time, Calendar cal) {
        if (null == time) {
            return null;
        }
        if (null == cal) {
            cal = Calendar.getInstance();
        }
        return CalendarSetter.getTime(time, cal, Calendar.getInstance());
    }

    public static Time getTime(Time time, Calendar to, Calendar from) {
        if (null == time) {
            return null;
        }
        if (null == to || null == from) {
            throw new NullPointerException("Calendar cannot be null.");
        }
        long millis = time.getTime();
        long convertedMillis = 0L;
        to.clear();
        from.clear();
        convertedMillis = to.equals(from) ? time.getTime() : CalendarSetter.convertTimeMillis(millis, to, from);
        to.clear();
        to.setTimeInMillis(convertedMillis);
        to.set(1, 1970);
        to.set(2, 0);
        to.set(5, 1);
        return new Time(to.getTimeInMillis());
    }

    public static Timestamp getTimestamp(Timestamp timestamp, Calendar cal) {
        if (null == timestamp) {
            return null;
        }
        if (null == cal) {
            cal = Calendar.getInstance();
        }
        return CalendarSetter.getTimestamp(timestamp, cal, Calendar.getInstance());
    }

    public static Timestamp getTimestamp(Timestamp timestamp, Calendar to, Calendar from) {
        if (null == timestamp) {
            return null;
        }
        if (null == to || null == from) {
            throw new NullPointerException("Calendar cannot be null.");
        }
        to.clear();
        from.clear();
        if (to.equals(from)) {
            return timestamp;
        }
        Timestamp tz = new Timestamp(CalendarSetter.convertTimeMillis(timestamp.getTime(), to, from));
        tz.setNanos(timestamp.getNanos());
        return tz;
    }

    private static long convertTimeMillis(long timeMillis, Calendar to, Calendar from) {
        from.setTimeInMillis(timeMillis);
        to.set(from.get(1), from.get(2), from.get(5), from.get(11), from.get(12), from.get(13));
        to.set(14, from.get(14));
        to.set(0, from.get(0));
        return to.getTimeInMillis();
    }
}

