/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.hybrid;

import com.vertica.dsi.core.interfaces.IConnection;
import com.vertica.dsi.core.interfaces.IStatement;
import com.vertica.jdbc.common.JDBCObjectFactory;
import com.vertica.jdbc.common.SCallableStatement;
import com.vertica.jdbc.common.SConnection;
import com.vertica.jdbc.common.SConnectionHandle;
import com.vertica.jdbc.common.SDatabaseMetaData;
import com.vertica.jdbc.common.SPooledConnection;
import com.vertica.jdbc.common.SPreparedStatement;
import com.vertica.jdbc.common.SStatement;
import com.vertica.jdbc.jdbc4.S4CallableStatement;
import com.vertica.jdbc.jdbc4.S4Connection;
import com.vertica.jdbc.jdbc4.S4ConnectionHandle;
import com.vertica.jdbc.jdbc4.S4DatabaseMetaData;
import com.vertica.jdbc.jdbc4.S4PooledConnection;
import com.vertica.jdbc.jdbc4.S4PreparedStatement;
import com.vertica.jdbc.jdbc4.S4Statement;
import com.vertica.jdbc.jdbc41.S41CallableStatement;
import com.vertica.jdbc.jdbc41.S41Connection;
import com.vertica.jdbc.jdbc41.S41ConnectionHandle;
import com.vertica.jdbc.jdbc41.S41DatabaseMetaData;
import com.vertica.jdbc.jdbc41.S41PooledConnection;
import com.vertica.jdbc.jdbc41.S41PreparedStatement;
import com.vertica.jdbc.jdbc41.S41Statement;
import com.vertica.jdbc.jdbc42.S42CallableStatement;
import com.vertica.jdbc.jdbc42.S42Connection;
import com.vertica.jdbc.jdbc42.S42ConnectionHandle;
import com.vertica.jdbc.jdbc42.S42DatabaseMetaData;
import com.vertica.jdbc.jdbc42.S42PooledConnection;
import com.vertica.jdbc.jdbc42.S42PreparedStatement;
import com.vertica.jdbc.jdbc42.S42Statement;
import com.vertica.support.ILogger;
import com.vertica.utilities.JDBCVersion;
import java.sql.SQLException;
import javax.sql.PooledConnection;

public class HybridJDBCObjectFactory
extends JDBCObjectFactory {
    private JDBCVersion m_jdbcVersion;

    protected HybridJDBCObjectFactory(JDBCVersion jdbcVersion) {
        this.m_jdbcVersion = jdbcVersion;
    }

    @Override
    protected SCallableStatement createCallableStatement(String sql, IStatement dsiStatement, SConnection parentConnection, int concurrency) throws SQLException {
        if (JDBCVersion.JDBC4 == this.m_jdbcVersion) {
            return new S4CallableStatement(sql, dsiStatement, parentConnection, concurrency);
        }
        if (JDBCVersion.JDBC41 == this.m_jdbcVersion) {
            return new S41CallableStatement(sql, dsiStatement, parentConnection, concurrency);
        }
        return new S42CallableStatement(sql, dsiStatement, parentConnection, concurrency);
    }

    @Override
    protected SConnection createConnection(IConnection dsiConnection, String url) throws SQLException {
        if (JDBCVersion.JDBC4 == this.m_jdbcVersion) {
            return new S4Connection(dsiConnection, url);
        }
        if (JDBCVersion.JDBC41 == this.m_jdbcVersion) {
            return new S41Connection(dsiConnection, url);
        }
        return new S42Connection(dsiConnection, url);
    }

    @Override
    protected SConnectionHandle createConnectionHandle(SConnection connection, SPooledConnection pooledConnection) throws SQLException {
        if (JDBCVersion.JDBC4 == this.m_jdbcVersion) {
            return new S4ConnectionHandle(connection, pooledConnection);
        }
        if (JDBCVersion.JDBC41 == this.m_jdbcVersion) {
            return new S41ConnectionHandle(connection, pooledConnection);
        }
        return new S42ConnectionHandle(connection, pooledConnection);
    }

    @Override
    protected SDatabaseMetaData createDatabaseMetaData(SConnection conn, ILogger logger) throws SQLException {
        if (JDBCVersion.JDBC4 == this.m_jdbcVersion) {
            return new S4DatabaseMetaData(conn, logger);
        }
        if (JDBCVersion.JDBC41 == this.m_jdbcVersion) {
            return new S41DatabaseMetaData(conn, logger);
        }
        return new S42DatabaseMetaData(conn, logger);
    }

    @Override
    protected PooledConnection createPooledConnection(SConnection connection) throws SQLException {
        if (JDBCVersion.JDBC4 == this.m_jdbcVersion) {
            return new S4PooledConnection(connection);
        }
        if (JDBCVersion.JDBC41 == this.m_jdbcVersion) {
            return new S41PooledConnection(connection);
        }
        return new S42PooledConnection(connection);
    }

    @Override
    protected SPreparedStatement createPreparedStatement(String sql, IStatement dsiStatement, SConnection parentConnection, int concurrency) throws SQLException {
        if (JDBCVersion.JDBC4 == this.m_jdbcVersion) {
            return new S4PreparedStatement(sql, dsiStatement, parentConnection, concurrency);
        }
        if (JDBCVersion.JDBC41 == this.m_jdbcVersion) {
            return new S41PreparedStatement(sql, dsiStatement, parentConnection, concurrency);
        }
        return new S42PreparedStatement(sql, dsiStatement, parentConnection, concurrency);
    }

    @Override
    protected SStatement createStatement(IStatement dsiStatement, SConnection parentConnection, int concurrency) throws SQLException {
        if (JDBCVersion.JDBC4 == this.m_jdbcVersion) {
            return new S4Statement(dsiStatement, parentConnection, concurrency);
        }
        if (JDBCVersion.JDBC41 == this.m_jdbcVersion) {
            return new S41Statement(dsiStatement, parentConnection, concurrency);
        }
        return new S42Statement(dsiStatement, parentConnection, concurrency);
    }
}

