/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.support;

import java.util.ArrayList;

public enum LogLevel {
    OFF,
    FATAL,
    ERROR,
    WARNING,
    INFO,
    DEBUG,
    TRACE;

    private static ArrayList<String> m_names;

    public static LogLevel getLogLevel(int level) {
        switch (level) {
            case 1: {
                return FATAL;
            }
            case 2: {
                return ERROR;
            }
            case 3: {
                return WARNING;
            }
            case 4: {
                return INFO;
            }
            case 5: {
                return DEBUG;
            }
            case 6: {
                return TRACE;
            }
        }
        return OFF;
    }

    public static LogLevel getLogLevel(String level) {
        LogLevel returnLevel = OFF;
        if (null == level || level.equals("")) {
            return returnLevel;
        }
        if (level.equalsIgnoreCase("OFF")) {
            returnLevel = OFF;
        }
        if (level.equalsIgnoreCase("FATAL")) {
            returnLevel = FATAL;
        } else if (level.equalsIgnoreCase("ERROR")) {
            returnLevel = ERROR;
        } else if (level.equalsIgnoreCase("WARNING")) {
            returnLevel = WARNING;
        } else if (level.equalsIgnoreCase("INFO")) {
            returnLevel = INFO;
        } else if (level.equalsIgnoreCase("DEBUG")) {
            returnLevel = DEBUG;
        } else if (level.equalsIgnoreCase("TRACE")) {
            returnLevel = TRACE;
        } else {
            try {
                returnLevel = LogLevel.getLogLevel(Integer.parseInt(level));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return returnLevel;
    }

    static {
        m_names = new ArrayList();
        m_names.add("OFF");
        m_names.add("FATAL");
        m_names.add("ERROR");
        m_names.add("WARNING");
        m_names.add("INFO");
        m_names.add("DEBUG");
        m_names.add("TRACE");
    }
}

