/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.support.security;

import com.vertica.support.ILogger;
import com.vertica.support.LogUtilities;
import com.vertica.support.security.ISecurityContext;
import com.vertica.support.security.SimbaCredentials;
import com.vertica.support.security.SimbaSecurityContext;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import sun.security.jgss.GSSUtil;

class SimbaLocalCredentials
extends SimbaCredentials {
    private final boolean m_inbound;
    private final GSSManager m_manager;
    private final ILogger m_logger;
    private GSSCredential m_credential;
    private Subject m_subject;

    SimbaLocalCredentials(ILogger logger, GSSManager gssManager, boolean inbound) {
        this.m_inbound = inbound;
        this.m_manager = gssManager;
        this.m_logger = logger;
        LogUtilities.logFunctionEntrance(this.m_logger, logger, gssManager);
    }

    @Override
    GSSCredential getCredentialHandle() throws GSSException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (null == this.m_credential) {
            this.DelayAcquireCredentials();
        }
        return this.m_credential;
    }

    @Override
    public ISecurityContext getSecurityContext(String in_spn) throws GSSException {
        LogUtilities.logFunctionEntrance(this.m_logger, in_spn);
        return new SimbaSecurityContext(this, this.m_logger, in_spn, this.m_manager);
    }

    @Override
    public String getName() throws GSSException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (null == this.m_credential) {
            this.DelayAcquireCredentials();
        }
        return ((Object)this.m_credential.getName()).toString();
    }

    @Override
    public Object executeAs(PrivilegedAction action) throws Exception {
        if (null == this.m_subject) {
            this.m_subject = GSSUtil.getSubject(this.m_credential.getName(), this.m_credential);
        }
        return Subject.doAsPrivileged(this.m_subject, action, null);
    }

    private void DelayAcquireCredentials() throws GSSException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            this.m_credential = this.m_manager.createCredential(this.m_inbound ? 2 : 1);
        }
        catch (GSSException e) {
            LogUtilities.logError(e, this.m_logger);
            throw e;
        }
        catch (RuntimeException r) {
            LogUtilities.logError(r, this.m_logger);
            throw r;
        }
    }
}

