/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.ark.runtime.model.responses.tool.mcp;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.volcengine.ark.runtime.model.responses.tool.mcp.MCPToolFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonSerialize(using=MCPAllowedToolsSerializer.class)
@JsonDeserialize(using=MCPAllowedToolsDeserializer.class)
public class MCPAllowedTools {
    private List<String> allowedTools;
    private MCPToolFilter filter;

    public List<String> getAllowedTools() {
        return this.allowedTools;
    }

    public void setAllowedTools(List<String> allowedTools) {
        this.allowedTools = allowedTools;
    }

    public MCPToolFilter getFilter() {
        return this.filter;
    }

    public void setFilter(MCPToolFilter filter) {
        this.filter = filter;
    }

    public String toString() {
        return "MCPAllowedTools{allowedTools=" + this.allowedTools + ", toolFilter=" + this.filter + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> allowedTools;
        private MCPToolFilter toolFilter;

        private Builder() {
        }

        public static Builder aMCPAllowedTools() {
            return new Builder();
        }

        public Builder allowedTools(List<String> allowedTools) {
            this.allowedTools = allowedTools;
            return this;
        }

        public Builder toolFilter(MCPToolFilter toolFilter) {
            this.toolFilter = toolFilter;
            return this;
        }

        public MCPAllowedTools build() {
            MCPAllowedTools mCPAllowedTools = new MCPAllowedTools();
            mCPAllowedTools.setAllowedTools(this.allowedTools);
            mCPAllowedTools.setFilter(this.toolFilter);
            return mCPAllowedTools;
        }
    }

    static class MCPAllowedToolsDeserializer
    extends JsonDeserializer<MCPAllowedTools> {
        MCPAllowedToolsDeserializer() {
        }

        public MCPAllowedTools deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            if (node.isArray()) {
                List<Object> allowedTools = Arrays.asList((Object[])p.getCodec().treeToValue((TreeNode)node, String[].class));
                return MCPAllowedTools.builder().allowedTools(allowedTools).build();
            }
            if (node.isObject()) {
                MCPToolFilter toolFilter = (MCPToolFilter)p.getCodec().treeToValue((TreeNode)node, MCPToolFilter.class);
                return MCPAllowedTools.builder().toolFilter(toolFilter).build();
            }
            throw new IOException("Unexpected JSON type for MCPAllowedTools");
        }
    }

    static class MCPAllowedToolsSerializer
    extends JsonSerializer<MCPAllowedTools> {
        MCPAllowedToolsSerializer() {
        }

        public void serialize(MCPAllowedTools value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            if (value.allowedTools != null) {
                gen.writeArray(value.allowedTools.toArray(new String[0]), 0, value.allowedTools.size());
            } else if (value.filter != null) {
                gen.writeObject((Object)value.filter);
            } else {
                gen.writeNull();
            }
        }
    }
}

