/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.ark.runtime.utils;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.Mac;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class KeyAgreementUtil {
    private static final String HKDF_ALGORITHM = "HmacSHA256";

    public static SessionData generateEciesKeyPair(PublicKey publicKey) throws GeneralSecurityException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("EC", "BC");
        ECParameterSpec ecSpec = ((ECPublicKey)publicKey).getParams();
        keyPairGenerator.initialize(ecSpec);
        KeyPair ephemeralKeyPair = keyPairGenerator.generateKeyPair();
        PrivateKey peerPrivateKey = ephemeralKeyPair.getPrivate();
        KeyAgreement keyAgreement = KeyAgreement.getInstance("ECDH", "BC");
        keyAgreement.init(peerPrivateKey);
        keyAgreement.doPhase(publicKey, true);
        byte[] dh = keyAgreement.generateSecret();
        int length = 44;
        byte[] buf = KeyAgreementUtil.hkdf(dh, null, null, length);
        byte[] cryptoKey = Arrays.copyOfRange(buf, 0, 32);
        byte[] cryptoNonce = Arrays.copyOfRange(buf, 32, length);
        ECPublicKey ephemeralPublicKey = (ECPublicKey)ephemeralKeyPair.getPublic();
        byte[] token = KeyAgreementUtil.marshalEcPublicKey(ephemeralPublicKey);
        String sessionToken = Base64.getEncoder().encodeToString(token);
        return new SessionData(cryptoKey, cryptoNonce, sessionToken);
    }

    public static byte[] hkdf(byte[] sharedSecret, byte[] salt, byte[] info, int length) throws GeneralSecurityException {
        int copyLen;
        Mac hmacExtract = Mac.getInstance(HKDF_ALGORITHM);
        if (salt == null) {
            salt = new byte[32];
        }
        SecretKeySpec saltKey = new SecretKeySpec(salt, HKDF_ALGORITHM);
        hmacExtract.init(saltKey);
        byte[] prk = hmacExtract.doFinal(sharedSecret);
        Mac hmacExpand = Mac.getInstance(HKDF_ALGORITHM);
        SecretKeySpec prkKey = new SecretKeySpec(prk, HKDF_ALGORITHM);
        hmacExpand.init(prkKey);
        byte[] result = new byte[length];
        byte[] t = new byte[]{};
        for (int pos = 0; pos < length; pos += copyLen) {
            hmacExpand.update(t);
            hmacExpand.update(info);
            hmacExpand.update((byte)(pos / 32 + 1));
            t = hmacExpand.doFinal();
            copyLen = Math.min(t.length, length - pos);
            System.arraycopy(t, 0, result, pos, copyLen);
        }
        return result;
    }

    public static byte[] marshalEcPublicKey(ECPublicKey publicKey) {
        try {
            ECPoint point = publicKey.getW();
            BigInteger x = point.getAffineX();
            BigInteger y = point.getAffineY();
            byte[] xBytes = KeyAgreementUtil.toUnsignedBigEndian(x, 32);
            byte[] yBytes = KeyAgreementUtil.toUnsignedBigEndian(y, 32);
            byte[] result = new byte[65];
            result[0] = 4;
            System.arraycopy(xBytes, 0, result, 1, 32);
            System.arraycopy(yBytes, 0, result, 33, 32);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to marshal EC public key", e);
        }
    }

    public static byte[] toUnsignedBigEndian(BigInteger value, int length) {
        byte[] bytes = value.toByteArray();
        byte[] result = new byte[length];
        if (bytes.length > length) {
            System.arraycopy(bytes, bytes.length - length, result, 0, length);
        } else if (bytes.length < length) {
            System.arraycopy(bytes, 0, result, length - bytes.length, bytes.length);
        } else {
            System.arraycopy(bytes, 0, result, 0, length);
        }
        return result;
    }

    public static boolean decryptValidate(String ciphertext) {
        try {
            byte[] cipherBytes = ciphertext.getBytes(StandardCharsets.UTF_8);
            byte[] cipherB64Bytes = Base64.getDecoder().decode(ciphertext);
            double left = (double)cipherBytes.length / 4.0;
            double middle = (double)cipherB64Bytes.length / 3.0;
            double right = (double)cipherBytes.length / 4.0 - 1.0;
            return left >= middle && middle >= right;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String decryptStringWithKey(byte[] key, byte[] nonce, String encryptedContent) {
        try {
            String content;
            try {
                content = KeyAgreementUtil.aesGcmDecryptBase64String(key, nonce, encryptedContent);
            }
            catch (Exception e) {
                content = "";
            }
            if (content.isEmpty() || !KeyAgreementUtil.decryptValidate(encryptedContent)) {
                content = KeyAgreementUtil.aesGcmDecryptBase64List(key, nonce, encryptedContent);
            }
            return content;
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String encryptStringWithKey(byte[] key, byte[] nonce, String plaintext) {
        try {
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            GCMParameterSpec parameterSpec = new GCMParameterSpec(128, nonce);
            SecretKeySpec secretKeySpec = new SecretKeySpec(key, "AES");
            cipher.init(1, (Key)secretKeySpec, parameterSpec);
            byte[] encryptedData = cipher.doFinal(plaintext.getBytes(StandardCharsets.UTF_8));
            String result = Base64.getEncoder().encodeToString(encryptedData);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to encrypt data", e);
        }
    }

    public static String aesGcmDecryptBase64String(byte[] key, byte[] nonce, String ciphertext) {
        try {
            String cleaned = ciphertext.replaceAll("\\s", "");
            StringBuilder cleanedBuilder = new StringBuilder(cleaned);
            while (cleanedBuilder.length() % 4 != 0) {
                cleanedBuilder.append("=");
            }
            cleaned = cleanedBuilder.toString();
            byte[] cipherBytes = Base64.getDecoder().decode(cleaned);
            return KeyAgreementUtil.aesGcmDecrypt(key, nonce, cipherBytes);
        }
        catch (Exception e) {
            throw new RuntimeException("Base64\u5b57\u7b26\u4e32\u89e3\u5bc6\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    public static String aesGcmDecrypt(byte[] key, byte[] iv, byte[] cipherBytes) throws GeneralSecurityException {
        try {
            Cipher decryptor = Cipher.getInstance("AES/GCM/NoPadding", "BC");
            GCMParameterSpec spec = new GCMParameterSpec(128, iv);
            decryptor.init(2, (Key)new SecretKeySpec(key, "AES"), spec);
            byte[] decrypted = decryptor.doFinal(cipherBytes);
            return new String(decrypted, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new GeneralSecurityException("AES-GCM\u89e3\u5bc6\u5931\u8d25", e);
        }
    }

    public static String aesGcmDecryptBase64List(byte[] key, byte[] nonce, String ciphertext) {
        ArrayList<String> result = new ArrayList<String>();
        List<String> base64Array = KeyAgreementUtil.extractBase64Blocks(ciphertext);
        for (String b64 : base64Array) {
            try {
                String decrypted = KeyAgreementUtil.aesGcmDecryptBase64String(key, nonce, b64);
                result.add(decrypted);
            }
            catch (Exception e) {
                String cornerCaseResult = KeyAgreementUtil.decryptCornerCase(key, nonce, b64);
                result.add(cornerCaseResult);
            }
        }
        return String.join((CharSequence)"", result);
    }

    public static List<String> extractBase64Blocks(String ciphertext) {
        ArrayList<String> blocks = new ArrayList<String>();
        String base64Pattern = "(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{4})";
        Pattern pattern = Pattern.compile(base64Pattern);
        Matcher matcher = pattern.matcher(ciphertext);
        while (matcher.find()) {
            String block = matcher.group();
            if (block.isEmpty()) continue;
            blocks.add(block);
        }
        return blocks;
    }

    private static String decryptCornerCase(byte[] key, byte[] nonce, String data) {
        for (int i = 20; i < data.length(); i += 4) {
            try {
                String decrypted = KeyAgreementUtil.aesGcmDecryptBase64String(key, nonce, data.substring(0, i + 4));
                if (i + 4 == data.length()) {
                    return decrypted;
                }
                return decrypted + KeyAgreementUtil.decryptCornerCase(key, nonce, data.substring(i + 4));
            }
            catch (Exception e) {
                continue;
            }
        }
        return "";
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public static class SessionData {
        private final byte[] cryptoKey;
        private final byte[] cryptoNonce;
        private final String sessionToken;

        public SessionData(byte[] cryptoKey, byte[] cryptoNonce, String sessionToken) {
            this.cryptoKey = cryptoKey;
            this.cryptoNonce = cryptoNonce;
            this.sessionToken = sessionToken;
        }

        public byte[] getCryptoKey() {
            return this.cryptoKey;
        }

        public byte[] getCryptoNonce() {
            return this.cryptoNonce;
        }

        public String getSessionToken() {
            return this.sessionToken;
        }
    }
}

