/*
 * Decompiled with CFR 0.152.
 */
package com.xfvape.uid;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.springframework.util.Assert;

public class BitsAllocator {
    public static final int TOTAL_BITS = 64;
    private int signBits = 1;
    private final int timestampBits;
    private final int workerIdBits;
    private final int sequenceBits;
    private final long maxDeltaSeconds;
    private final long maxWorkerId;
    private final long maxSequence;
    private final int timestampShift;
    private final int workerIdShift;

    public BitsAllocator(int timestampBits, int workerIdBits, int sequenceBits) {
        int allocateTotalBits = this.signBits + timestampBits + workerIdBits + sequenceBits;
        Assert.isTrue((allocateTotalBits == 64 ? 1 : 0) != 0, (String)"allocate not enough 64 bits");
        this.timestampBits = timestampBits;
        this.workerIdBits = workerIdBits;
        this.sequenceBits = sequenceBits;
        this.maxDeltaSeconds = -1L << timestampBits ^ 0xFFFFFFFFFFFFFFFFL;
        this.maxWorkerId = -1L << workerIdBits ^ 0xFFFFFFFFFFFFFFFFL;
        this.maxSequence = -1L << sequenceBits ^ 0xFFFFFFFFFFFFFFFFL;
        this.timestampShift = workerIdBits + sequenceBits;
        this.workerIdShift = sequenceBits;
    }

    public long allocate(long deltaSeconds, long workerId, long sequence) {
        return deltaSeconds << this.timestampShift | workerId << this.workerIdShift | sequence;
    }

    public int getSignBits() {
        return this.signBits;
    }

    public int getTimestampBits() {
        return this.timestampBits;
    }

    public int getWorkerIdBits() {
        return this.workerIdBits;
    }

    public int getSequenceBits() {
        return this.sequenceBits;
    }

    public long getMaxDeltaSeconds() {
        return this.maxDeltaSeconds;
    }

    public long getMaxWorkerId() {
        return this.maxWorkerId;
    }

    public long getMaxSequence() {
        return this.maxSequence;
    }

    public int getTimestampShift() {
        return this.timestampShift;
    }

    public int getWorkerIdShift() {
        return this.workerIdShift;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

