/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.db.ds.c3p0;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import com.xiaoleilu.hutool.db.DbRuntimeException;
import com.xiaoleilu.hutool.db.DbUtil;
import com.xiaoleilu.hutool.db.ds.DSFactory;
import com.xiaoleilu.hutool.setting.Setting;
import com.xiaoleilu.hutool.util.CollectionUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;

public class C3p0DSFactory
extends DSFactory {
    public static final String DS_NAME = "C3P0";
    private Map<String, ComboPooledDataSource> dsMap = new ConcurrentHashMap<String, ComboPooledDataSource>();

    public C3p0DSFactory() {
        this(null);
    }

    public C3p0DSFactory(Setting setting) {
        super(DS_NAME, ComboPooledDataSource.class, setting);
    }

    @Override
    public synchronized DataSource getDataSource(String group) {
        ComboPooledDataSource existedDataSource;
        if (group == null) {
            group = "";
        }
        if ((existedDataSource = this.dsMap.get(group)) != null) {
            return existedDataSource;
        }
        ComboPooledDataSource ds = this.createDataSource(group);
        this.dsMap.put(group, ds);
        return ds;
    }

    @Override
    public void close(String group) {
        ComboPooledDataSource ds;
        if (group == null) {
            group = "";
        }
        if ((ds = this.dsMap.get(group)) != null) {
            ds.close();
            this.dsMap.remove(group);
        }
    }

    @Override
    public void destroy() {
        if (CollectionUtil.isNotEmpty(this.dsMap)) {
            Collection<ComboPooledDataSource> values = this.dsMap.values();
            for (ComboPooledDataSource ds : values) {
                ds.close();
            }
            this.dsMap.clear();
        }
    }

    private ComboPooledDataSource createDataSource(String group) {
        Setting config = this.setting.getSetting(group);
        if (CollectionUtil.isEmpty(config)) {
            throw new DbRuntimeException("No C3P0 config for group: [{}]", group);
        }
        ComboPooledDataSource ds = new ComboPooledDataSource();
        ds.setJdbcUrl(this.getAndRemoveProperty(config, "url", "jdbcUrl"));
        ds.setUser(this.getAndRemoveProperty(config, "username", "user"));
        ds.setPassword(this.getAndRemoveProperty(config, "password", "pass"));
        String driver = this.getAndRemoveProperty(config, "driver", "driverClassName");
        try {
            if (StrUtil.isNotBlank(driver)) {
                ds.setDriverClass(driver);
            } else {
                ds.setDriverClass(DbUtil.identifyDriver(ds.getJdbcUrl()));
            }
        }
        catch (Exception e) {
            throw new DbRuntimeException(e);
        }
        config.toBean(ds);
        return ds;
    }

    private String getAndRemoveProperty(Setting setting, String key1, String key2) {
        String value = (String)setting.remove(key1);
        if (StrUtil.isBlank(value)) {
            value = (String)setting.remove(key2);
        }
        return value;
    }
}

