/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.log;

import com.xiaoleilu.hutool.log.Log;
import com.xiaoleilu.hutool.log.dialect.commons.ApacheCommonsLogFactory;
import com.xiaoleilu.hutool.log.dialect.console.ConsoleLogFactory;
import com.xiaoleilu.hutool.log.dialect.jdk.JdkLogFactory;
import com.xiaoleilu.hutool.log.dialect.log4j.Log4jLogFactory;
import com.xiaoleilu.hutool.log.dialect.log4j2.Log4j2LogFactory;
import com.xiaoleilu.hutool.log.dialect.slf4j.Slf4jLogFactory;
import com.xiaoleilu.hutool.log.dialect.tinylog.TinyLogFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class LogFactory {
    private String logFramworkName;
    private Map<Object, Log> logCache;
    private static volatile LogFactory currentLogFactory;
    private static final Object lock;

    public LogFactory(String logFramworkName) {
        this.logFramworkName = logFramworkName;
        this.logCache = new ConcurrentHashMap<Object, Log>();
    }

    public Log getLog(String name) {
        Log log = this.logCache.get(name);
        if (null == log) {
            log = this.createLog(name);
            this.logCache.put(name, log);
        }
        return log;
    }

    public Log getLog(Class<?> clazz) {
        Log log = this.logCache.get(clazz);
        if (null == log) {
            log = this.createLog(clazz);
            this.logCache.put(clazz, log);
        }
        return log;
    }

    public abstract Log createLog(String var1);

    public abstract Log createLog(Class<?> var1);

    protected void checkLogExist(Object logClassName) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogFactory getCurrentLogFactory() {
        if (null == currentLogFactory) {
            Object object = lock;
            synchronized (object) {
                if (null == currentLogFactory) {
                    currentLogFactory = LogFactory.detectLogFactory();
                }
            }
        }
        return currentLogFactory;
    }

    public static LogFactory setCurrentLogFactory(Class<? extends LogFactory> logFactoryClass) {
        try {
            return LogFactory.setCurrentLogFactory(logFactoryClass.newInstance());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can not instance LogFactory class!", e);
        }
    }

    public static LogFactory setCurrentLogFactory(LogFactory logFactory) {
        logFactory.getLog(LogFactory.class).debug("Custom Use [{}] Logger.", logFactory.logFramworkName);
        currentLogFactory = logFactory;
        return currentLogFactory;
    }

    public static Log get(String name) {
        return LogFactory.getCurrentLogFactory().getLog(name);
    }

    public static Log get(Class<?> clazz) {
        return LogFactory.getCurrentLogFactory().getLog(clazz);
    }

    public static Log get() {
        return LogFactory.get(new Exception().getStackTrace()[1].getClassName());
    }

    protected static Log indirectGet() {
        return LogFactory.get(new Exception().getStackTrace()[2].getClassName());
    }

    private static LogFactory detectLogFactory() {
        LogFactory logFactory;
        try {
            logFactory = new Slf4jLogFactory(true);
            logFactory.getLog(LogFactory.class).debug("Use [{}] Logger As Default.", logFactory.logFramworkName);
        }
        catch (NoClassDefFoundError e) {
            try {
                logFactory = new Log4jLogFactory();
                logFactory.getLog(LogFactory.class).debug("Use [{}] Logger As Default.", logFactory.logFramworkName);
            }
            catch (NoClassDefFoundError e2) {
                try {
                    logFactory = new Log4j2LogFactory();
                    logFactory.getLog(LogFactory.class).debug("Use [{}] Logger As Default.", logFactory.logFramworkName);
                }
                catch (NoClassDefFoundError e3) {
                    try {
                        logFactory = new ApacheCommonsLogFactory();
                        logFactory.getLog(LogFactory.class).debug("Use [{}] Logger As Default.", logFactory.logFramworkName);
                    }
                    catch (NoClassDefFoundError e4) {
                        try {
                            logFactory = new TinyLogFactory();
                            logFactory.getLog(LogFactory.class).debug("Use [{}] Logger As Default.", logFactory.logFramworkName);
                        }
                        catch (NoClassDefFoundError e5) {
                            try {
                                logFactory = new JdkLogFactory();
                                logFactory.getLog(LogFactory.class).debug("Use [{}] Logger As Default.", logFactory.logFramworkName);
                            }
                            catch (NoClassDefFoundError e6) {
                                logFactory = new ConsoleLogFactory();
                                logFactory.getLog(LogFactory.class).debug("Use [{}] Logger As Default.", logFactory.logFramworkName);
                            }
                        }
                    }
                }
            }
        }
        return logFactory;
    }

    static {
        lock = new Object();
    }
}

