/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.util;

import com.xiaoleilu.hutool.lang.StrFormatter;
import com.xiaoleilu.hutool.util.ArrayUtil;
import com.xiaoleilu.hutool.util.CharsetUtil;
import com.xiaoleilu.hutool.util.NumberUtil;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class StrUtil {
    public static final char C_SPACE = ' ';
    public static final char C_TAB = '\t';
    public static final char C_DOT = '.';
    public static final char C_SLASH = '/';
    public static final char C_BACKSLASH = '\\';
    public static final char C_CR = '\r';
    public static final char C_LF = '\n';
    public static final char C_UNDERLINE = '_';
    public static final char C_COMMA = ',';
    public static final char C_DELIM_START = '{';
    public static final char C_DELIM_END = '}';
    public static final char C_BRACKET_START = '[';
    public static final char C_BRACKET_END = ']';
    public static final char C_COLON = ':';
    public static final String SPACE = " ";
    public static final String TAB = "\t";
    public static final String DOT = ".";
    public static final String DOUBLE_DOT = "..";
    public static final String SLASH = "/";
    public static final String BACKSLASH = "\\";
    public static final String EMPTY = "";
    public static final String CR = "\r";
    public static final String LF = "\n";
    public static final String CRLF = "\r\n";
    public static final String UNDERLINE = "_";
    public static final String COMMA = ",";
    public static final String DELIM_START = "{";
    public static final String DELIM_END = "}";
    public static final String BRACKET_START = "[";
    public static final String BRACKET_END = "]";
    public static final String COLON = ":";
    public static final String HTML_NBSP = "&nbsp;";
    public static final String HTML_AMP = "&amp";
    public static final String HTML_QUOTE = "&quot;";
    public static final String HTML_LT = "&lt;";
    public static final String HTML_GT = "&gt;";
    public static final String EMPTY_JSON = "{}";

    private StrUtil() {
    }

    public static boolean isBlank(CharSequence str) {
        int length;
        if (str == null || (length = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < length; ++i) {
            if (NumberUtil.isBlankChar(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(CharSequence str) {
        return false == StrUtil.isBlank(str);
    }

    public static boolean hasBlank(CharSequence ... strs) {
        if (ArrayUtil.isEmpty(strs)) {
            return true;
        }
        for (CharSequence str : strs) {
            if (!StrUtil.isBlank(str)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllBlank(CharSequence ... strs) {
        if (ArrayUtil.isEmpty(strs)) {
            return true;
        }
        for (CharSequence str : strs) {
            if (!StrUtil.isNotBlank(str)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence str) {
        return false == StrUtil.isEmpty(str);
    }

    public static String nullToEmpty(CharSequence str) {
        return StrUtil.nullToDefault(str, EMPTY);
    }

    public static String nullToDefault(CharSequence str, String defaultStr) {
        return str == null ? defaultStr : str.toString();
    }

    public static String emptyToNull(CharSequence str) {
        return StrUtil.isEmpty(str) ? null : str.toString();
    }

    public static boolean hasEmpty(CharSequence ... strs) {
        if (ArrayUtil.isEmpty(strs)) {
            return true;
        }
        for (CharSequence str : strs) {
            if (!StrUtil.isEmpty(str)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllEmpty(CharSequence ... strs) {
        if (ArrayUtil.isEmpty(strs)) {
            return true;
        }
        for (CharSequence str : strs) {
            if (!StrUtil.isNotEmpty(str)) continue;
            return false;
        }
        return true;
    }

    public static String trim(CharSequence str) {
        return null == str ? null : StrUtil.trim(str, 0);
    }

    public static void trim(String[] strs) {
        if (null == strs) {
            return;
        }
        for (int i = 0; i < strs.length; ++i) {
            String str = strs[i];
            if (null == str) continue;
            strs[i] = str.trim();
        }
    }

    public static String trimStart(CharSequence str) {
        return StrUtil.trim(str, -1);
    }

    public static String trimEnd(CharSequence str) {
        return StrUtil.trim(str, 1);
    }

    public static String trim(CharSequence str, int mode) {
        int start;
        if (str == null) {
            return null;
        }
        int length = str.length();
        int end = length;
        if (mode <= 0) {
            for (start = 0; start < end && NumberUtil.isBlankChar(str.charAt(start)); ++start) {
            }
        }
        if (mode >= 0) {
            while (start < end && NumberUtil.isBlankChar(str.charAt(end - 1))) {
                --end;
            }
        }
        if (start > 0 || end < length) {
            return str.toString().substring(start, end);
        }
        return str.toString();
    }

    public static boolean startWith(CharSequence str, CharSequence prefix, boolean isIgnoreCase) {
        if (isIgnoreCase) {
            return str.toString().toLowerCase().startsWith(prefix.toString().toLowerCase());
        }
        return str.toString().startsWith(prefix.toString());
    }

    public static boolean startWith(CharSequence str, CharSequence prefix) {
        return StrUtil.startWith(str, prefix, false);
    }

    public static boolean startWithIgnoreCase(String str, String prefix) {
        return StrUtil.startWith(str, prefix, true);
    }

    public static boolean startWithAny(CharSequence str, CharSequence ... prefixes) {
        if (StrUtil.isEmpty(str) || ArrayUtil.isEmpty(prefixes)) {
            return false;
        }
        for (CharSequence suffix : prefixes) {
            if (!StrUtil.startWith(str, suffix, false)) continue;
            return true;
        }
        return false;
    }

    public static boolean endWith(CharSequence str, CharSequence suffix, boolean isIgnoreCase) {
        if (StrUtil.isBlank(str) || StrUtil.isBlank(suffix)) {
            return false;
        }
        if (isIgnoreCase) {
            return str.toString().toLowerCase().endsWith(suffix.toString().toLowerCase());
        }
        return str.toString().endsWith(suffix.toString());
    }

    public static boolean endWith(CharSequence str, CharSequence suffix) {
        return StrUtil.endWith(str, suffix, false);
    }

    public static boolean endWithIgnoreCase(CharSequence str, String suffix) {
        return StrUtil.endWith(str, suffix, true);
    }

    public static boolean endWithAny(CharSequence str, CharSequence ... suffixes) {
        if (StrUtil.isEmpty(str) || ArrayUtil.isEmpty(suffixes)) {
            return false;
        }
        for (CharSequence suffix : suffixes) {
            if (!StrUtil.endWith(str, suffix, false)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsIgnoreCase(CharSequence str, CharSequence testStr) {
        if (null == str) {
            return null == testStr;
        }
        return str.toString().toLowerCase().contains(testStr.toString().toLowerCase());
    }

    public static String getGeneralField(CharSequence getOrSetMethodName) {
        String getOrSetMethodNameStr = getOrSetMethodName.toString();
        if (getOrSetMethodNameStr.startsWith("get") || getOrSetMethodNameStr.startsWith("set")) {
            return StrUtil.removePreAndLowerFirst(getOrSetMethodName, 3);
        }
        return null;
    }

    public static String genSetter(CharSequence fieldName) {
        return StrUtil.upperFirstAndAddPre(fieldName, "set");
    }

    public static String genGetter(String fieldName) {
        return StrUtil.upperFirstAndAddPre(fieldName, "get");
    }

    public static String removeAll(String str, CharSequence strToRemove) {
        return str.replace(strToRemove, EMPTY);
    }

    public static String removePreAndLowerFirst(CharSequence str, int preLength) {
        if (str == null) {
            return null;
        }
        if (str.length() > preLength) {
            char first = Character.toLowerCase(str.charAt(preLength));
            if (str.length() > preLength + 1) {
                return first + str.toString().substring(preLength + 1);
            }
            return String.valueOf(first);
        }
        return str.toString();
    }

    public static String removePreAndLowerFirst(CharSequence str, CharSequence prefix) {
        return StrUtil.lowerFirst(StrUtil.removePrefix(str, prefix));
    }

    public static String upperFirstAndAddPre(CharSequence str, String preString) {
        if (str == null || preString == null) {
            return null;
        }
        return preString + StrUtil.upperFirst(str);
    }

    public static String upperFirst(CharSequence str) {
        char firstChar;
        if (null == str) {
            return null;
        }
        if (str.length() > 0 && Character.isLowerCase(firstChar = str.charAt(0))) {
            return Character.toUpperCase(firstChar) + StrUtil.subSuf(str, 1);
        }
        return str.toString();
    }

    public static String lowerFirst(CharSequence str) {
        char firstChar;
        if (null == str) {
            return null;
        }
        if (str.length() > 0 && Character.isUpperCase(firstChar = str.charAt(0))) {
            return Character.toLowerCase(firstChar) + StrUtil.subSuf(str, 1);
        }
        return str.toString();
    }

    public static String removePrefix(CharSequence str, CharSequence prefix) {
        if (StrUtil.isEmpty(str) || StrUtil.isEmpty(prefix)) {
            return str.toString();
        }
        String str2 = str.toString();
        if (str2.startsWith(prefix.toString())) {
            return StrUtil.subSuf(str2, prefix.length());
        }
        return str2;
    }

    public static String removePrefixIgnoreCase(CharSequence str, String prefix) {
        if (StrUtil.isEmpty(str) || StrUtil.isEmpty(prefix)) {
            return str.toString();
        }
        String str2 = str.toString();
        if (str2.toLowerCase().startsWith(prefix.toLowerCase())) {
            return StrUtil.subSuf(str2, prefix.length());
        }
        return str2;
    }

    public static String removeSuffix(CharSequence str, CharSequence suffix) {
        if (StrUtil.isEmpty(str) || StrUtil.isEmpty(suffix)) {
            return str.toString();
        }
        String str2 = str.toString();
        if (str2.endsWith(suffix.toString())) {
            return StrUtil.subPre(str2, str2.length() - suffix.length());
        }
        return str2;
    }

    public static String removeSufAndLowerFirst(CharSequence str, CharSequence suffix) {
        return StrUtil.lowerFirst(StrUtil.removeSuffix(str, suffix));
    }

    public static String removeSuffixIgnoreCase(CharSequence str, CharSequence suffix) {
        if (StrUtil.isEmpty(str) || StrUtil.isEmpty(suffix)) {
            return str.toString();
        }
        String str2 = str.toString();
        if (str2.toLowerCase().endsWith(suffix.toString().toLowerCase())) {
            return StrUtil.subPre(str2, str2.length() - suffix.length());
        }
        return str2;
    }

    public static String addPrefixIfNot(CharSequence str, CharSequence prefix) {
        String prefix2;
        if (StrUtil.isEmpty(str) || StrUtil.isEmpty(prefix)) {
            return str.toString();
        }
        String str2 = str.toString();
        if (!str2.startsWith(prefix2 = prefix.toString())) {
            return prefix2 + str2;
        }
        return prefix2;
    }

    public static String addSuffixIfNot(CharSequence str, CharSequence suffix) {
        String suffix2;
        if (StrUtil.isEmpty(str) || StrUtil.isEmpty(suffix)) {
            return str.toString();
        }
        String str2 = str.toString();
        if (!str2.endsWith(suffix2 = suffix.toString())) {
            return str2 + suffix2;
        }
        return str2;
    }

    public static String cleanBlank(CharSequence str) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        StringBuilder sb = new StringBuilder(str.length());
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (NumberUtil.isBlankChar(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String[] splitToArray(CharSequence str, char separator) {
        List<String> result = StrUtil.split(str, separator);
        return result.toArray(new String[result.size()]);
    }

    public static List<String> split(CharSequence str, char separator) {
        return StrUtil.split(str, separator, 0);
    }

    public static String[] splitToArray(CharSequence str, char separator, int limit) {
        List<String> result = StrUtil.split(str, separator, limit);
        return result.toArray(new String[result.size()]);
    }

    public static List<String> split(CharSequence str, char separator, int limit) {
        if (str == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>(limit > 0 ? 16 : limit);
        if (limit == 1) {
            list.add(str.toString());
            return list;
        }
        boolean isNotEnd = true;
        int strLen = str.length();
        StringBuilder sb = new StringBuilder(strLen);
        for (int i = 0; i < strLen; ++i) {
            char c = str.charAt(i);
            if (isNotEnd && c == separator) {
                list.add(sb.toString());
                sb.delete(0, sb.length());
                if (limit <= 0 || list.size() != limit - 1) continue;
                isNotEnd = false;
                continue;
            }
            sb.append(c);
        }
        list.add(sb.toString());
        return list;
    }

    public static String[] split(CharSequence str, CharSequence delimiter) {
        int i;
        if (str == null) {
            return null;
        }
        String str2 = str.toString();
        if (str2.trim().length() == 0) {
            return new String[]{str2};
        }
        int dellen = delimiter.length();
        int maxparts = str.length() / dellen + 2;
        int[] positions = new int[maxparts];
        int j = 0;
        int count = 0;
        positions[0] = -dellen;
        String delimiter2 = delimiter.toString();
        while ((i = str2.indexOf(delimiter2, j)) != -1) {
            positions[++count] = i;
            j = i + dellen;
        }
        positions[++count] = str.length();
        String[] result = new String[count];
        for (i = 0; i < count; ++i) {
            result[i] = str2.substring(positions[i] + dellen, positions[i + 1]);
        }
        return result;
    }

    public static String[] split(CharSequence str, int len) {
        int partCount = str.length() / len;
        int lastPartCount = str.length() % len;
        int fixPart = 0;
        if (lastPartCount != 0) {
            fixPart = 1;
        }
        String str2 = str.toString();
        String[] strs = new String[partCount + fixPart];
        for (int i = 0; i < partCount + fixPart; ++i) {
            strs[i] = i == partCount + fixPart - 1 && lastPartCount != 0 ? str2.substring(i * len, i * len + lastPartCount) : str2.substring(i * len, i * len + len);
        }
        return strs;
    }

    public static String sub(CharSequence string, int fromIndex, int toIndex) {
        int len = string.length();
        if (fromIndex < 0) {
            if ((fromIndex = len + fromIndex) < 0) {
                fromIndex = 0;
            }
        } else if (fromIndex > len) {
            fromIndex = len;
        }
        if (toIndex < 0) {
            if ((toIndex = len + toIndex) < 0) {
                toIndex = len;
            }
        } else if (toIndex > len) {
            toIndex = len;
        }
        if (toIndex < fromIndex) {
            int tmp = fromIndex;
            fromIndex = toIndex;
            toIndex = tmp;
        }
        if (fromIndex == toIndex) {
            return EMPTY;
        }
        return string.toString().substring(fromIndex, toIndex);
    }

    public static String subPre(CharSequence string, int toIndex) {
        return StrUtil.sub(string, 0, toIndex);
    }

    public static String subSuf(CharSequence string, int fromIndex) {
        if (StrUtil.isEmpty(string)) {
            return null;
        }
        return StrUtil.sub(string, fromIndex, string.length());
    }

    public static boolean isSurround(CharSequence str, CharSequence prefix, CharSequence suffix) {
        if (StrUtil.isBlank(str)) {
            return false;
        }
        if (str.length() < prefix.length() + suffix.length()) {
            return false;
        }
        String str2 = str.toString();
        return str2.startsWith(prefix.toString()) && str2.endsWith(suffix.toString());
    }

    public static boolean isSurround(CharSequence str, char prefix, char suffix) {
        if (StrUtil.isBlank(str)) {
            return false;
        }
        if (str.length() < 2) {
            return false;
        }
        return str.charAt(0) == prefix && str.charAt(str.length() - 1) == suffix;
    }

    public static String repeat(char c, int count) {
        if (count <= 0) {
            return EMPTY;
        }
        char[] result = new char[count];
        for (int i = 0; i < count; ++i) {
            result[i] = c;
        }
        return new String(result);
    }

    public static String repeat(CharSequence str, int count) {
        int n;
        if (null == str) {
            return null;
        }
        if (count <= 0) {
            return EMPTY;
        }
        if (count == 1 || str.length() == 0) {
            return str.toString();
        }
        int len = str.length();
        long longSize = (long)len * (long)count;
        int size = (int)longSize;
        if ((long)size != longSize) {
            throw new ArrayIndexOutOfBoundsException("Required String length is too large: " + longSize);
        }
        char[] array = new char[size];
        str.toString().getChars(0, len, array, 0);
        for (n = len; n < size - n; n <<= 1) {
            System.arraycopy(array, 0, array, n, n);
        }
        System.arraycopy(array, 0, array, n, size - n);
        return new String(array);
    }

    public static boolean equals(CharSequence str1, CharSequence str2) {
        if (str1 == null) {
            return str2 == null;
        }
        return str1.equals(str2);
    }

    public static boolean equalsIgnoreCase(CharSequence str1, CharSequence str2) {
        if (str1 == null) {
            return str2 == null;
        }
        return str1.toString().equalsIgnoreCase(str2.toString());
    }

    public static String format(CharSequence template, Object ... params) {
        if (null == template) {
            return null;
        }
        if (ArrayUtil.isEmpty(params) || StrUtil.isBlank(template)) {
            return template.toString();
        }
        return StrFormatter.format(template.toString(), params);
    }

    public static String indexedFormat(CharSequence pattern, Object ... arguments) {
        return MessageFormat.format(pattern.toString(), arguments);
    }

    public static String format(CharSequence template, Map<?, ?> map) {
        if (null == template) {
            return null;
        }
        if (null == map || map.isEmpty()) {
            return template.toString();
        }
        String template2 = template.toString();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            template = template2.replace(DELIM_START + entry.getKey() + DELIM_END, StrUtil.utf8Str(entry.getValue()));
        }
        return template2;
    }

    public static byte[] utf8Bytes(CharSequence str) {
        return StrUtil.bytes(str, CharsetUtil.CHARSET_UTF_8);
    }

    public static byte[] bytes(CharSequence str) {
        return StrUtil.bytes(str, Charset.defaultCharset());
    }

    public static byte[] bytes(CharSequence str, String charset) {
        return StrUtil.bytes(str, StrUtil.isBlank(charset) ? Charset.defaultCharset() : Charset.forName(charset));
    }

    public static byte[] bytes(CharSequence str, Charset charset) {
        if (str == null) {
            return null;
        }
        if (null == charset) {
            return str.toString().getBytes();
        }
        return str.toString().getBytes(charset);
    }

    public static String utf8Str(Object obj) {
        return StrUtil.str(obj, CharsetUtil.CHARSET_UTF_8);
    }

    public static String str(Object obj, String charsetName) {
        return StrUtil.str(obj, Charset.forName(charsetName));
    }

    public static String str(Object obj, Charset charset) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof byte[]) {
            return StrUtil.str((byte[])obj, charset);
        }
        if (obj instanceof Byte[]) {
            return StrUtil.str((Byte[])obj, charset);
        }
        if (obj instanceof ByteBuffer) {
            return StrUtil.str((ByteBuffer)obj, charset);
        }
        if (ArrayUtil.isArray(obj)) {
            return ArrayUtil.toString(obj);
        }
        return obj.toString();
    }

    public static String str(byte[] bytes, String charset) {
        return StrUtil.str(bytes, StrUtil.isBlank(charset) ? Charset.defaultCharset() : Charset.forName(charset));
    }

    public static String str(byte[] data, Charset charset) {
        if (data == null) {
            return null;
        }
        if (null == charset) {
            return new String(data);
        }
        return new String(data, charset);
    }

    public static String str(Byte[] bytes, String charset) {
        return StrUtil.str(bytes, StrUtil.isBlank(charset) ? Charset.defaultCharset() : Charset.forName(charset));
    }

    public static String str(Byte[] data, Charset charset) {
        if (data == null) {
            return null;
        }
        byte[] bytes = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            Byte dataByte = data[i];
            bytes[i] = null == dataByte ? -1 : (int)dataByte.byteValue();
        }
        return StrUtil.str(bytes, charset);
    }

    public static String str(ByteBuffer data, String charset) {
        if (data == null) {
            return null;
        }
        return StrUtil.str(data, Charset.forName(charset));
    }

    public static String str(ByteBuffer data, Charset charset) {
        if (null == charset) {
            charset = Charset.defaultCharset();
        }
        return charset.decode(data).toString();
    }

    public static ByteBuffer byteBuffer(CharSequence str, String charset) {
        return ByteBuffer.wrap(StrUtil.bytes(str, charset));
    }

    public static String join(CharSequence conjunction, Object ... objs) {
        return ArrayUtil.join(objs, conjunction);
    }

    public static String toUnderlineCase(CharSequence camelCaseStr) {
        if (camelCaseStr == null) {
            return null;
        }
        int length = camelCaseStr.length();
        StringBuilder sb = new StringBuilder();
        boolean isPreUpperCase = false;
        for (int i = 0; i < length; ++i) {
            char c = camelCaseStr.charAt(i);
            boolean isNextUpperCase = true;
            if (i < length - 1) {
                isNextUpperCase = Character.isUpperCase(camelCaseStr.charAt(i + 1));
            }
            if (Character.isUpperCase(c)) {
                if (!(isPreUpperCase && isNextUpperCase || i <= 0)) {
                    sb.append(UNDERLINE);
                }
                isPreUpperCase = true;
            } else {
                isPreUpperCase = false;
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    public static String toCamelCase(CharSequence name) {
        if (null == name) {
            return null;
        }
        String name2 = name.toString();
        if (name2.contains(UNDERLINE)) {
            name2 = name2.toLowerCase();
            StringBuilder sb = new StringBuilder(name2.length());
            boolean upperCase = false;
            for (int i = 0; i < name2.length(); ++i) {
                char c = name2.charAt(i);
                if (c == '_') {
                    upperCase = true;
                    continue;
                }
                if (upperCase) {
                    sb.append(Character.toUpperCase(c));
                    upperCase = false;
                    continue;
                }
                sb.append(c);
            }
            return sb.toString();
        }
        return name2;
    }

    public static String wrap(CharSequence str, CharSequence prefix, CharSequence suffix) {
        return StrUtil.nullToEmpty(prefix).concat(StrUtil.nullToEmpty(str)).concat(StrUtil.nullToEmpty(suffix));
    }

    public static String wrapIfMissing(CharSequence str, CharSequence prefix, CharSequence suffix) {
        int len = 0;
        if (StrUtil.isNotEmpty(str)) {
            len += str.length();
        }
        if (StrUtil.isNotEmpty(prefix)) {
            len += str.length();
        }
        if (StrUtil.isNotEmpty(suffix)) {
            len += str.length();
        }
        StringBuilder sb = new StringBuilder(len);
        if (StrUtil.isNotEmpty(prefix) && !StrUtil.startWith(str, prefix)) {
            sb.append(prefix);
        }
        if (StrUtil.isNotEmpty(str)) {
            sb.append(str);
        }
        if (StrUtil.isNotEmpty(suffix) && !StrUtil.endWith(str, suffix)) {
            sb.append(suffix);
        }
        return sb.toString();
    }

    public static boolean isWrap(CharSequence str, String prefix, String suffix) {
        if (ArrayUtil.hasNull(str, prefix, suffix)) {
            return false;
        }
        String str2 = str.toString();
        return str2.startsWith(prefix) && str2.endsWith(suffix);
    }

    public static boolean isWrap(CharSequence str, String wrapper) {
        return StrUtil.isWrap(str, wrapper, wrapper);
    }

    public static boolean isWrap(CharSequence str, char wrapper) {
        return StrUtil.isWrap(str, wrapper, wrapper);
    }

    public static boolean isWrap(CharSequence str, char prefixChar, char suffixChar) {
        if (null == str) {
            return false;
        }
        return str.charAt(0) == prefixChar && str.charAt(str.length() - 1) == suffixChar;
    }

    public static String padPre(CharSequence str, int minLength, char padChar) {
        if (null == str) {
            str = EMPTY;
        } else if (str.length() >= minLength) {
            return str.toString();
        }
        return StrUtil.repeat(padChar, minLength - str.length()).concat(str.toString());
    }

    public static String padEnd(CharSequence str, int minLength, char padChar) {
        if (null == str) {
            str = EMPTY;
        } else if (str.length() >= minLength) {
            return str.toString();
        }
        return str.toString().concat(StrUtil.repeat(padChar, minLength - str.length()));
    }

    public static StringBuilder builder() {
        return new StringBuilder();
    }

    public static StringBuilder builder(int capacity) {
        return new StringBuilder(capacity);
    }

    public static StringBuilder builder(CharSequence ... strs) {
        StringBuilder sb = new StringBuilder();
        for (CharSequence str : strs) {
            sb.append(str);
        }
        return sb;
    }

    public static StringReader getReader(CharSequence str) {
        if (null == str) {
            return null;
        }
        return new StringReader(str.toString());
    }

    public static StringWriter getWriter() {
        return new StringWriter();
    }

    public static int count(CharSequence content, CharSequence strForSearch) {
        if (StrUtil.hasEmpty(content, strForSearch) || strForSearch.length() > content.length()) {
            return 0;
        }
        int count = 0;
        int idx = 0;
        String content2 = content.toString();
        String strForSearch2 = strForSearch.toString();
        while ((idx = content2.indexOf(strForSearch2, idx)) > -1) {
            ++count;
            idx += strForSearch.length();
        }
        return count;
    }

    public static int count(CharSequence content, char charForSearch) {
        int count = 0;
        if (StrUtil.isEmpty(content)) {
            return 0;
        }
        int contentLength = content.length();
        for (int i = 0; i < contentLength; ++i) {
            if (charForSearch != content.charAt(i)) continue;
            ++count;
        }
        return count;
    }

    public static String[] cut(CharSequence str, int partLength) {
        if (null == str) {
            return null;
        }
        int len = str.length();
        if (len < partLength) {
            return new String[]{str.toString()};
        }
        int part = NumberUtil.count(len, partLength);
        String[] array = new String[part];
        String str2 = str.toString();
        for (int i = 0; i < part; ++i) {
            array[i] = str2.substring(i * partLength, i == part - 1 ? len : partLength + i * partLength);
        }
        return array;
    }

    public static String brief(CharSequence str, int maxLength) {
        if (null == str) {
            return null;
        }
        if (str.length() + 3 <= maxLength) {
            return str.toString();
        }
        int w = maxLength / 2;
        int l = str.length();
        String str2 = str.toString();
        return StrUtil.format((CharSequence)"{}...{}", str2.substring(0, maxLength - w), str2.substring(l - w));
    }

    public static int compare(CharSequence str1, CharSequence str2, boolean nullIsLess) {
        if (str1 == str2) {
            return 0;
        }
        if (str1 == null) {
            return nullIsLess ? -1 : 1;
        }
        if (str2 == null) {
            return nullIsLess ? 1 : -1;
        }
        return str1.toString().compareTo(str2.toString());
    }

    public static int compareIgnoreCase(CharSequence str1, CharSequence str2, boolean nullIsLess) {
        if (str1 == str2) {
            return 0;
        }
        if (str1 == null) {
            return nullIsLess ? -1 : 1;
        }
        if (str2 == null) {
            return nullIsLess ? 1 : -1;
        }
        return str1.toString().compareToIgnoreCase(str2.toString());
    }

    public static int indexOf(CharSequence str, char searchChar) {
        return StrUtil.indexOf(str, searchChar, 0);
    }

    public static int indexOf(CharSequence str, char searchChar, int start) {
        if (str instanceof String) {
            return ((String)str).indexOf(searchChar, start);
        }
        return StrUtil.indexOf(str, searchChar, start, -1);
    }

    public static int indexOf(CharSequence str, char searchChar, int start, int end) {
        int len = str.length();
        if (start < 0 || start > len) {
            start = 0;
        }
        if (end > len || end < 0) {
            end = len;
        }
        for (int i = start; i < end; ++i) {
            if (str.charAt(i) != searchChar) continue;
            return i;
        }
        return -1;
    }

    public static String appendIfMissing(CharSequence str, CharSequence suffix, CharSequence ... suffixes) {
        return StrUtil.appendIfMissing(str, suffix, false, suffixes);
    }

    public static String appendIfMissingIgnoreCase(CharSequence str, CharSequence suffix, CharSequence ... suffixes) {
        return StrUtil.appendIfMissing(str, suffix, true, suffixes);
    }

    public static String appendIfMissing(CharSequence str, CharSequence suffix, boolean ignoreCase, CharSequence ... suffixes) {
        if (str == null || StrUtil.isEmpty(suffix) || StrUtil.endWith(str, suffix, ignoreCase)) {
            return str.toString();
        }
        if (suffixes != null && suffixes.length > 0) {
            for (CharSequence s : suffixes) {
                if (!StrUtil.endWith(str, s, ignoreCase)) continue;
                return str.toString();
            }
        }
        return str.toString().concat(suffix.toString());
    }

    public static String prependIfMissing(CharSequence str, CharSequence prefix, CharSequence ... prefixes) {
        return StrUtil.prependIfMissing(str, prefix, false, prefixes);
    }

    public static String prependIfMissingIgnoreCase(CharSequence str, CharSequence prefix, CharSequence ... prefixes) {
        return StrUtil.prependIfMissing(str, prefix, true, prefixes);
    }

    public static String prependIfMissing(CharSequence str, CharSequence prefix, boolean ignoreCase, CharSequence ... prefixes) {
        if (str == null || StrUtil.isEmpty(prefix) || StrUtil.startWith(str, prefix, ignoreCase)) {
            return str.toString();
        }
        if (prefixes != null && prefixes.length > 0) {
            for (CharSequence s : prefixes) {
                if (!StrUtil.startWith(str, s, ignoreCase)) continue;
                return str.toString();
            }
        }
        return prefix.toString().concat(str.toString());
    }
}

