/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.tool.core;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateTool {
    private static Logger logger = LoggerFactory.getLogger(DateTool.class);
    public static final String DATE_TIME = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE = "yyyy-MM-dd";
    public static final String TIME = "HH:mm:ss";
    public static final String TIME_WITHOUT_SECOND = "HH:mm";
    private static final ThreadLocal<ConcurrentHashMap<String, DateFormat>> dateFormatThreadLocal = ThreadLocal.withInitial(ConcurrentHashMap::new);
    public static final long MILLIS_PER_MS = 1L;
    public static final long MILLIS_PER_SECOND = 1000L;
    public static final long MILLIS_PER_MINUTE = 60000L;
    public static final long MILLIS_PER_HOUR = 3600000L;
    public static final long MILLIS_PER_DAY = 86400000L;
    public static final long MILLIS_PER_WEEK = 604800000L;
    public static final long MILLIS_PER_MONTH_30 = 2592000000L;
    public static final long MILLIS_PER_YEAR_365 = 31536000000L;

    private static DateFormat loadDateFormat(String pattern) {
        if (pattern == null || pattern.trim().isEmpty()) {
            throw new IllegalArgumentException("pattern cannot be empty.");
        }
        return dateFormatThreadLocal.get().computeIfAbsent(pattern.trim(), k -> new SimpleDateFormat(pattern.trim(), Locale.getDefault()));
    }

    public static Date parse(String dateString, String pattern) {
        try {
            return DateTool.loadDateFormat(pattern).parse(dateString);
        }
        catch (ParseException e) {
            throw new RuntimeException("parse error.", e);
        }
    }

    public static Date parseDateTime(String dateString) {
        return DateTool.parse(dateString, DATE_TIME);
    }

    public static Date parseDate(String dateString) {
        return DateTool.parse(dateString, DATE);
    }

    public static String format(Date date, String pattern) {
        return DateTool.loadDateFormat(pattern).format(date);
    }

    public static String formatDate(Date date) {
        return DateTool.format(date, DATE);
    }

    public static String formatDateTime(Date date) {
        return DateTool.format(date, DATE_TIME);
    }

    public static LocalDateTime parseLocalDateTime(String dateString, String pattern) {
        return LocalDateTime.parse(dateString, DateTimeFormatter.ofPattern(pattern));
    }

    public static LocalDate parseLocalDate(String dateString, String pattern) {
        return LocalDate.parse(dateString, DateTimeFormatter.ofPattern(pattern));
    }

    public static LocalTime parseLocalTime(String dateString, String pattern) {
        return LocalTime.parse(dateString, DateTimeFormatter.ofPattern(pattern));
    }

    public static YearMonth parseYearMonth(String dateString, String pattern) {
        return YearMonth.parse(dateString, DateTimeFormatter.ofPattern(pattern));
    }

    public static String formatTemporal(Temporal temporal, String pattern) {
        if (temporal instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)temporal;
            return localDateTime.format(DateTimeFormatter.ofPattern(pattern));
        }
        if (temporal instanceof LocalDate) {
            LocalDate localDate = (LocalDate)temporal;
            return localDate.format(DateTimeFormatter.ofPattern(pattern));
        }
        if (temporal instanceof LocalTime) {
            LocalTime localTime = (LocalTime)temporal;
            return localTime.format(DateTimeFormatter.ofPattern(pattern));
        }
        if (temporal instanceof YearMonth) {
            YearMonth yearMonth = (YearMonth)temporal;
            return yearMonth.format(DateTimeFormatter.ofPattern(pattern));
        }
        throw new IllegalArgumentException("Unsupported temporal type: " + temporal.getClass().getName());
    }

    public static Date addYears(Date date, long amount) {
        LocalDateTime dateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        LocalDateTime newDateTime = dateTime.plusYears(amount);
        return Date.from(newDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date addMonths(Date date, long amount) {
        LocalDateTime dateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        LocalDateTime newDateTime = dateTime.plusMonths(amount);
        return Date.from(newDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date addDays(Date date, long amount) {
        LocalDateTime dateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        LocalDateTime newDateTime = dateTime.plusDays(amount);
        return Date.from(newDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date addHours(Date date, long amount) {
        LocalDateTime dateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        LocalDateTime newDateTime = dateTime.plusHours(amount);
        return Date.from(newDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date addMinutes(Date date, long amount) {
        LocalDateTime dateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        LocalDateTime newDateTime = dateTime.plusMinutes(amount);
        return Date.from(newDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date addSeconds(Date date, long amount) {
        LocalDateTime dateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        LocalDateTime newDateTime = dateTime.plusSeconds(amount);
        return Date.from(newDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date addWeeks(Date date, long amount) {
        LocalDateTime dateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        LocalDateTime newDateTime = dateTime.plusWeeks(amount);
        return Date.from(newDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date addMilliseconds(Date date, long amount) {
        LocalDateTime dateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        LocalDateTime newDateTime = dateTime.plusNanos(amount * 1000000L);
        return Date.from(newDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date set(Date date, int calendarField, int amount) {
        Calendar c = Calendar.getInstance();
        c.setLenient(false);
        c.setTime(date);
        c.set(calendarField, amount);
        return c.getTime();
    }

    public static Date setYears(Date date, int amount) {
        return DateTool.set(date, 1, amount);
    }

    public static Date setMonths(Date date, int amount) {
        return DateTool.set(date, 2, amount);
    }

    public static Date setDays(Date date, int amount) {
        return DateTool.set(date, 5, amount);
    }

    public static Date setHours(Date date, int amount) {
        return DateTool.set(date, 11, amount);
    }

    public static Date setMinutes(Date date, int amount) {
        return DateTool.set(date, 12, amount);
    }

    public static Date setSeconds(Date date, int amount) {
        return DateTool.set(date, 13, amount);
    }

    public static Date setMilliseconds(Date date, int amount) {
        return DateTool.set(date, 14, amount);
    }

    public static Date setStartOfDay(Date date) {
        Calendar c = Calendar.getInstance();
        c.setLenient(false);
        c.setTime(date);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    private static long between(Date beginDate, Date endDate, int calendarField) {
        long unitMillis;
        if (beginDate == null || endDate == null) {
            throw new IllegalArgumentException("date must not be null");
        }
        switch (calendarField) {
            case 1: {
                unitMillis = 31536000000L;
                break;
            }
            case 2: {
                unitMillis = 2592000000L;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                unitMillis = 86400000L;
                break;
            }
            case 10: 
            case 11: {
                unitMillis = 3600000L;
                break;
            }
            case 12: {
                unitMillis = 60000L;
                break;
            }
            case 13: {
                unitMillis = 1000L;
                break;
            }
            case 14: {
                unitMillis = 1L;
                break;
            }
            case 3: 
            case 4: {
                unitMillis = 604800000L;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported time unit: " + calendarField);
            }
        }
        long diffMillis = endDate.getTime() - beginDate.getTime();
        return diffMillis / unitMillis;
    }

    public static long betweenYear(Date beginDate, Date endDate) {
        return DateTool.between(beginDate, endDate, 1);
    }

    public static long betweenMonth(Date beginDate, Date endDate) {
        return DateTool.between(beginDate, endDate, 2);
    }

    public static long betweenDay(Date beginDate, Date endDate) {
        return DateTool.between(beginDate, endDate, 5);
    }

    public static long betweenHour(Date beginDate, Date endDate) {
        return DateTool.between(beginDate, endDate, 11);
    }

    public static long betweenMinute(Date beginDate, Date endDate) {
        return DateTool.between(beginDate, endDate, 12);
    }

    public static long betweenSecond(Date beginDate, Date endDate) {
        return DateTool.between(beginDate, endDate, 13);
    }

    public static long betweenWeek(Date beginDate, Date endDate) {
        return DateTool.between(beginDate, endDate, 3);
    }

    public static boolean isSameDay(Calendar cal1, Calendar cal2) {
        Objects.requireNonNull(cal1, "cal1");
        Objects.requireNonNull(cal2, "cal2");
        return cal1.get(0) == cal2.get(0) && cal1.get(1) == cal2.get(1) && cal1.get(6) == cal2.get(6);
    }
}

