/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.tool.core;

import java.util.StringJoiner;

public class ObjectTool {
    private static final String EMPTY_STRING = "";
    private static final String NULL_STRING = "null";
    private static final String ARRAY_START = "{";
    private static final String ARRAY_END = "}";
    private static final String EMPTY_ARRAY = "{}";
    private static final String ARRAY_ELEMENT_SEPARATOR = ", ";

    public static boolean equal(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static boolean isArray(Object obj) {
        return obj != null && obj.getClass().isArray();
    }

    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static String toString(Object obj) {
        if (obj == null) {
            return NULL_STRING;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof Object[]) {
            return ObjectTool.toString((Object[])obj);
        }
        if (obj instanceof boolean[]) {
            return ObjectTool.toString((Object)((boolean[])obj));
        }
        if (obj instanceof byte[]) {
            return ObjectTool.toString((Object)((byte[])obj));
        }
        if (obj instanceof char[]) {
            return ObjectTool.toString((Object)((char[])obj));
        }
        if (obj instanceof double[]) {
            return ObjectTool.toString((Object)((double[])obj));
        }
        if (obj instanceof float[]) {
            return ObjectTool.toString((Object)((float[])obj));
        }
        if (obj instanceof int[]) {
            return ObjectTool.toString((Object)((int[])obj));
        }
        if (obj instanceof long[]) {
            return ObjectTool.toString((Object)((long[])obj));
        }
        if (obj instanceof short[]) {
            return ObjectTool.toString((Object)((short[])obj));
        }
        String str = obj.toString();
        return str != null ? str : EMPTY_STRING;
    }

    public static String toString(Object[] array) {
        if (array == null) {
            return NULL_STRING;
        }
        int length = array.length;
        if (length == 0) {
            return EMPTY_ARRAY;
        }
        StringJoiner stringJoiner = new StringJoiner(ARRAY_ELEMENT_SEPARATOR, ARRAY_START, ARRAY_END);
        for (Object o : array) {
            stringJoiner.add(String.valueOf(o));
        }
        return stringJoiner.toString();
    }

    public static String identityToString(Object obj) {
        if (obj == null) {
            return EMPTY_STRING;
        }
        return obj.getClass().getName() + "@" + ObjectTool.getIdentityHexString(obj);
    }

    public static String getIdentityHexString(Object obj) {
        return Integer.toHexString(System.identityHashCode(obj));
    }
}

