/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.tool.jsonrpc;

import com.google.gson.JsonElement;
import com.xxl.tool.gson.GsonTool;
import com.xxl.tool.jsonrpc.model.JsonRpcRequest;
import com.xxl.tool.jsonrpc.model.JsonRpcResponse;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRpcServer {
    private static Logger logger = LoggerFactory.getLogger(JsonRpcServer.class);
    private Map<String, Object> serviceStore = new ConcurrentHashMap<String, Object>();

    public JsonRpcServer() {
    }

    public JsonRpcServer(Map<String, Object> initServiceStore) {
        if (initServiceStore != null && !initServiceStore.isEmpty()) {
            for (Map.Entry<String, Object> entry : initServiceStore.entrySet()) {
                this.register(entry.getKey(), entry.getValue());
            }
        }
    }

    public void register(String service, Object serviceInstance) {
        this.serviceStore.put(service, serviceInstance);
    }

    public String invoke(String requestBody) {
        JsonRpcRequest jsonRpcRequest = GsonTool.fromJson(requestBody, JsonRpcRequest.class);
        JsonRpcResponse jsonRpcResponse = this.invoke(jsonRpcRequest);
        return GsonTool.toJson(jsonRpcResponse);
    }

    public JsonRpcResponse invoke(JsonRpcRequest request) {
        String service = request.getService();
        String method = request.getMethod();
        JsonElement[] params = request.getParams();
        try {
            Object serviceInstance = this.serviceStore.get(service);
            if (serviceInstance == null) {
                return JsonRpcResponse.ofError("service[" + service + "] not found.");
            }
            Method methodObj = null;
            for (Method m : serviceInstance.getClass().getMethods()) {
                if (!m.getName().equals(method)) continue;
                methodObj = m;
                break;
            }
            if (methodObj == null) {
                return JsonRpcResponse.ofError("method [" + method + "] not found.");
            }
            Object[] parameters = null;
            Class<?>[] parameterTypes = methodObj.getParameterTypes();
            if (parameterTypes.length > 0) {
                if (params == null || params.length != parameterTypes.length) {
                    return JsonRpcResponse.ofError("method[" + method + "] params number not match.");
                }
                parameters = new Object[parameterTypes.length];
                for (int i = 0; i < parameterTypes.length; ++i) {
                    parameters[i] = GsonTool.fromJsonElement(params[i], parameterTypes[i]);
                }
            }
            methodObj.setAccessible(true);
            Object resultObj = methodObj.invoke(serviceInstance, parameters);
            JsonElement resultJson = GsonTool.toJsonElement(resultObj);
            return JsonRpcResponse.ofSuccess(resultJson);
        }
        catch (Exception e) {
            logger.error("server invoke error:{}", (Object)e.getMessage(), (Object)e);
            return JsonRpcResponse.ofError("server invoke error: " + e.getMessage());
        }
    }
}

