/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.parser.sql.polling;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.digest.DigestUtil;
import com.yomahub.liteflow.parser.sql.exception.ELSQLException;
import com.yomahub.liteflow.parser.sql.polling.SqlReadPollTask;
import com.yomahub.liteflow.parser.sql.read.SqlRead;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class AbstractSqlReadPollTask<T>
implements SqlReadPollTask<T> {
    private final Map<String, String> DATA_SHA_MAP = new HashMap<String, String>();
    private final SqlRead<T> read;

    public AbstractSqlReadPollTask(SqlRead<T> read) {
        this.read = read;
        if (!read.type().equals((Object)this.type())) {
            throw new ELSQLException("SqlReadPollTask type not match");
        }
    }

    @Override
    public void execute() {
        List<T> dataList = this.read.read();
        ArrayList<T> saveElementList = new ArrayList<T>();
        for (T data : dataList) {
            String id = this.getKey(data);
            String newSHA = this.getNeedSha1Value(data);
            if (!this.DATA_SHA_MAP.containsKey(id)) {
                saveElementList.add(data);
                this.DATA_SHA_MAP.put(id, newSHA);
                continue;
            }
            if (StrUtil.equals((CharSequence)newSHA, (CharSequence)this.DATA_SHA_MAP.get(id))) continue;
            saveElementList.add(data);
            this.DATA_SHA_MAP.put(id, newSHA);
        }
        Set<String> oldIdList = this.DATA_SHA_MAP.keySet();
        Set newIdList = dataList.stream().map(this::getKey).collect(Collectors.toSet());
        List deleteElementIds = CollUtil.subtractToList(oldIdList, newIdList);
        for (String id : deleteElementIds) {
            this.DATA_SHA_MAP.remove(id);
        }
        if (CollUtil.isNotEmpty(saveElementList)) {
            this.doSave(saveElementList);
        }
        if (CollUtil.isNotEmpty((Collection)deleteElementIds)) {
            this.doDelete(deleteElementIds);
        }
    }

    @Override
    public void initData(List<T> dataList) {
        this.DATA_SHA_MAP.putAll(this.shaValue(dataList));
    }

    public abstract void doSave(List<T> var1);

    public abstract void doDelete(List<String> var1);

    private Map<String, String> shaValue(List<T> dataList) {
        HashMap<String, String> result = new HashMap<String, String>();
        dataList.forEach(t -> result.put(this.getKey(t), DigestUtil.sha1Hex((String)this.getNeedSha1Value(t))));
        return result;
    }

    private String getNeedSha1Value(T data) {
        if (StrUtil.isBlank((CharSequence)this.getExtValue(data))) {
            return DigestUtil.sha1Hex((String)this.getValue(data));
        }
        return DigestUtil.sha1Hex((String)(this.getValue(data) + "|||" + this.getExtValue(data)));
    }

    protected abstract String getKey(T var1);

    protected abstract String getValue(T var1);

    protected abstract String getExtValue(T var1);
}

