/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.parser.sql.util;

import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.parser.sql.exception.ELSQLException;
import com.yomahub.liteflow.parser.sql.vo.SQLParserVO;
import com.yomahub.liteflow.spi.holder.ContextAwareHolder;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiteFlowJdbcUtil {
    private static final Logger LOG = LoggerFactory.getLogger(LiteFlowJdbcUtil.class);
    private static final String CHECK_SQL_PATTERN = "SELECT {},{} FROM {}";

    public static Connection getConn(SQLParserVO sqlParserVO) {
        Connection connection = null;
        String url = sqlParserVO.getUrl();
        String username = sqlParserVO.getUsername();
        String password = sqlParserVO.getPassword();
        try {
            if (sqlParserVO.isDefaultDataSource()) {
                String executeSql = LiteFlowJdbcUtil.buildCheckSql(sqlParserVO);
                Map dataSourceMap = ContextAwareHolder.loadContextAware().getBeansOfType(DataSource.class);
                for (Map.Entry entry : dataSourceMap.entrySet()) {
                    String dataSourceName = (String)entry.getKey();
                    DataSource dataSource = (DataSource)entry.getValue();
                    if (LiteFlowJdbcUtil.checkConnectionCanExecuteSql(dataSource.getConnection(), executeSql)) {
                        connection = dataSource.getConnection();
                        LOG.info("use dataSourceName[{}],has found liteflow config", (Object)dataSourceName);
                        continue;
                    }
                    LOG.info("check dataSourceName[{}],but not has liteflow config", (Object)dataSourceName);
                }
                if (connection == null) {
                    throw new ELSQLException("can not found liteflow config in dataSourceName " + dataSourceMap.keySet());
                }
            } else {
                connection = DriverManager.getConnection(url, username, password);
            }
        }
        catch (Exception e) {
            throw new ELSQLException(e);
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkConnectionCanExecuteSql(Connection conn, String sql) {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement(sql, 1003, 1007);
            stmt.setFetchSize(1);
            rs = stmt.executeQuery();
            boolean bl = true;
            LiteFlowJdbcUtil.close(conn, stmt, rs);
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            LiteFlowJdbcUtil.close(conn, stmt, rs);
        }
    }

    public static void close(Connection conn, PreparedStatement stmt, ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                throw new ELSQLException(e);
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                throw new ELSQLException(e);
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                throw new ELSQLException(e);
            }
        }
    }

    private static String buildCheckSql(SQLParserVO sqlParserVO) {
        String chainTableName = sqlParserVO.getChainTableName();
        String elDataField = sqlParserVO.getElDataField();
        String chainNameField = sqlParserVO.getChainNameField();
        return StrUtil.format((CharSequence)CHECK_SQL_PATTERN, (Object[])new Object[]{chainNameField, elDataField, chainTableName});
    }
}

