/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.spring;

import cn.hutool.core.annotation.AnnotationUtil;
import cn.hutool.core.util.ReflectUtil;
import com.yomahub.liteflow.annotation.LiteflowMethod;
import com.yomahub.liteflow.core.proxy.DeclWarpBean;
import com.yomahub.liteflow.log.LFLog;
import com.yomahub.liteflow.log.LFLoggerManager;
import com.yomahub.liteflow.spi.holder.DeclComponentParserHolder;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.GenericBeanDefinition;

public class DeclBeanDefinition
implements BeanDefinitionRegistryPostProcessor {
    private final LFLog LOG = LFLoggerManager.getLogger(this.getClass());

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        DefaultListableBeanFactory defaultListableBeanFactory = (DefaultListableBeanFactory)registry;
        String[] beanDefinitionNames = defaultListableBeanFactory.getBeanDefinitionNames();
        Arrays.stream(beanDefinitionNames).filter(beanName -> {
            BeanDefinition beanDefinition = defaultListableBeanFactory.getMergedBeanDefinition(beanName);
            Class<?> rawClass = this.getRawClassFromBeanDefinition(beanDefinition);
            if (rawClass == null) {
                return false;
            }
            return Arrays.stream(rawClass.getMethods()).anyMatch(method -> AnnotationUtil.getAnnotation((AnnotatedElement)method, LiteflowMethod.class) != null);
        }).forEach(beanName -> {
            BeanDefinition beanDefinition = defaultListableBeanFactory.getMergedBeanDefinition(beanName);
            Class<?> rawClass = this.getRawClassFromBeanDefinition(beanDefinition);
            List declWarpBeanList = DeclComponentParserHolder.loadDeclComponentParser().parseDeclBean(rawClass);
            declWarpBeanList.forEach(declWarpBean -> {
                GenericBeanDefinition newBeanDefinition = new GenericBeanDefinition();
                newBeanDefinition.setBeanClass(DeclWarpBean.class);
                newBeanDefinition.setScope("singleton");
                MutablePropertyValues mutablePropertyValues = new MutablePropertyValues();
                mutablePropertyValues.add("nodeId", (Object)declWarpBean.getNodeId());
                mutablePropertyValues.add("nodeName", (Object)declWarpBean.getNodeName());
                mutablePropertyValues.add("nodeType", (Object)declWarpBean.getNodeType());
                mutablePropertyValues.add("rawClazz", (Object)declWarpBean.getRawClazz());
                mutablePropertyValues.add("methodWrapBeanList", (Object)declWarpBean.getMethodWrapBeanList());
                mutablePropertyValues.add("rawBean", (Object)beanDefinition);
                newBeanDefinition.setPropertyValues(mutablePropertyValues);
                defaultListableBeanFactory.setAllowBeanDefinitionOverriding(true);
                defaultListableBeanFactory.registerBeanDefinition(declWarpBean.getNodeId(), (BeanDefinition)newBeanDefinition);
            });
        });
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    private Class<?> getRawClassFromBeanDefinition(BeanDefinition beanDefinition) {
        try {
            Method method = ReflectUtil.getMethodByName(DeclBeanDefinition.class, (String)"getResolvableType");
            if (method != null) {
                Object resolvableType = ReflectUtil.invoke((Object)beanDefinition, (Method)method, (Object[])new Object[0]);
                return (Class)ReflectUtil.invoke((Object)resolvableType, (String)"getRawClass", (Object[])new Object[0]);
            }
            return (Class)ReflectUtil.invoke((Object)beanDefinition, (String)"getTargetType", (Object[])new Object[0]);
        }
        catch (Exception e) {
            this.LOG.error("An error occurred while obtaining the rowClass.", (Throwable)e);
            return null;
        }
    }
}

