/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.spring;

import com.yomahub.liteflow.core.proxy.LiteFlowProxyUtil;
import com.yomahub.liteflow.process.LiteflowScannerProcessStep;
import com.yomahub.liteflow.process.LiteflowScannerProcessStepFactory;
import com.yomahub.liteflow.process.context.LiteflowScannerProcessStepContext;
import com.yomahub.liteflow.process.holder.SpringNodeIdHolder;
import com.yomahub.liteflow.property.LiteflowConfig;
import com.yomahub.liteflow.util.LOGOPrinter;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class ComponentScanner
implements BeanPostProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ComponentScanner.class);
    private final LiteflowScannerProcessStepFactory liteflowScannerProcessStepFactory = new LiteflowScannerProcessStepFactory();

    public ComponentScanner() {
        LOGOPrinter.print();
    }

    public ComponentScanner(LiteflowConfig liteflowConfig) {
        if (liteflowConfig.getPrintBanner().booleanValue()) {
            LOGOPrinter.print();
        }
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class clazz = LiteFlowProxyUtil.getUserClass(bean.getClass());
        LiteflowScannerProcessStepContext ctx = LiteflowScannerProcessStepContext.of(bean, beanName, clazz);
        Optional<LiteflowScannerProcessStep> finderOpt = this.liteflowScannerProcessStepFactory.getSteps().stream().filter(t -> t.filter(ctx)).findFirst();
        if (finderOpt.isPresent()) {
            return finderOpt.get().postProcessAfterInitialization(ctx);
        }
        return bean;
    }

    public static void cleanCache() {
        SpringNodeIdHolder.getNodeIdSet().clear();
    }
}

