/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.client.registration;

import de.codecentric.boot.admin.client.config.ClientProperties;
import de.codecentric.boot.admin.client.registration.Application;
import de.codecentric.boot.admin.client.registration.ApplicationFactory;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class ApplicationRegistrator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationRegistrator.class);
    private static final ParameterizedTypeReference<Map<String, Object>> RESPONSE_TYPE = new ParameterizedTypeReference<Map<String, Object>>(){};
    private static final HttpHeaders HTTP_HEADERS = ApplicationRegistrator.createHttpHeaders();
    private final ConcurrentHashMap<String, LongAdder> attempts = new ConcurrentHashMap();
    private final AtomicReference<String> registeredId = new AtomicReference();
    private final ClientProperties client;
    private final RestTemplate template;
    private final ApplicationFactory applicationFactory;

    public ApplicationRegistrator(RestTemplate template, ClientProperties client, ApplicationFactory applicationFactory) {
        this.client = client;
        this.template = template;
        this.applicationFactory = applicationFactory;
    }

    private static HttpHeaders createHttpHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        return HttpHeaders.readOnlyHttpHeaders((HttpHeaders)headers);
    }

    public boolean register() {
        Application self = this.createApplication();
        boolean isRegistrationSuccessful = false;
        String[] stringArray = this.client.getAdminUrl();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String adminUrl;
            LongAdder attempt = this.attempts.computeIfAbsent(adminUrl = stringArray[i], k -> new LongAdder());
            boolean successful = this.register(self, adminUrl, attempt.intValue() == 0);
            if (!successful) {
                attempt.increment();
                continue;
            }
            attempt.reset();
            isRegistrationSuccessful = true;
            if (this.client.isRegisterOnce()) break;
        }
        return isRegistrationSuccessful;
    }

    protected boolean register(Application self, String adminUrl, boolean firstAttempt) {
        try {
            ResponseEntity response = this.template.exchange(adminUrl, HttpMethod.POST, new HttpEntity((Object)self, (MultiValueMap)HTTP_HEADERS), RESPONSE_TYPE, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful()) {
                if (this.registeredId.compareAndSet(null, ((Map)response.getBody()).get("id").toString())) {
                    LOGGER.info("Application registered itself as {}", (Object)((Map)response.getBody()).get("id").toString());
                } else {
                    LOGGER.debug("Application refreshed itself as {}", (Object)((Map)response.getBody()).get("id").toString());
                }
                return true;
            }
            if (firstAttempt) {
                LOGGER.warn("Application failed to registered itself as {}. Response: {}. Further attempts are logged on DEBUG level", (Object)self, (Object)response.toString());
            } else {
                LOGGER.debug("Application failed to registered itself as {}. Response: {}", (Object)self, (Object)response.toString());
            }
        }
        catch (Exception ex) {
            if (firstAttempt) {
                LOGGER.warn("Failed to register application as {} at spring-boot-admin ({}): {}. Further attempts are logged on DEBUG level", new Object[]{self, this.client.getAdminUrl(), ex.getMessage()});
            }
            LOGGER.debug("Failed to register application as {} at spring-boot-admin ({}): {}", new Object[]{self, this.client.getAdminUrl(), ex.getMessage()});
        }
        return false;
    }

    public void deregister() {
        String id = this.registeredId.get();
        if (id != null) {
            for (String adminUrl : this.client.getAdminUrl()) {
                try {
                    this.template.delete(adminUrl + "/" + id, new Object[0]);
                    this.registeredId.compareAndSet(id, null);
                    if (!this.client.isRegisterOnce()) continue;
                    break;
                }
                catch (Exception ex) {
                    LOGGER.warn("Failed to deregister application (id={}) at spring-boot-admin ({}): {}", new Object[]{id, adminUrl, ex.getMessage()});
                }
            }
        }
    }

    public String getRegisteredId() {
        return this.registeredId.get();
    }

    protected Application createApplication() {
        return this.applicationFactory.createApplication();
    }
}

